/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.codec.xml;

import com.google.common.base.Verify;
import java.net.URI;
import java.util.Map;
import java.util.Objects;
import javax.xml.stream.XMLStreamException;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.codec.xml.RandomPrefixInstanceIdentifierSerializer;
import org.opendaylight.yangtools.yang.data.codec.xml.ValueWriter;
import org.opendaylight.yangtools.yang.data.codec.xml.XMLStreamWriterUtils;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.api.SchemaContextProvider;
import org.opendaylight.yangtools.yang.model.api.SchemaNode;
import org.opendaylight.yangtools.yang.model.api.TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.LeafrefTypeDefinition;
import org.opendaylight.yangtools.yang.model.util.SchemaContextUtil;

final class SchemaAwareXMLStreamWriterUtils
extends XMLStreamWriterUtils
implements SchemaContextProvider {
    private final @NonNull SchemaContext schemaContext;

    SchemaAwareXMLStreamWriterUtils(SchemaContext schemaContext) {
        this.schemaContext = Objects.requireNonNull(schemaContext);
    }

    @Override
    TypeDefinition<?> getBaseTypeForLeafRef(SchemaNode schemaNode, LeafrefTypeDefinition type) {
        TypeDefinition ret = SchemaContextUtil.getBaseTypeForLeafRef((LeafrefTypeDefinition)type, (SchemaContext)this.schemaContext, (SchemaNode)schemaNode);
        return (TypeDefinition)Verify.verifyNotNull((Object)ret, (String)"Unable to find base type for leafref node '%s'.", (Object[])new Object[]{schemaNode});
    }

    @Override
    String encodeInstanceIdentifier(ValueWriter writer, YangInstanceIdentifier value) throws XMLStreamException {
        RandomPrefixInstanceIdentifierSerializer iiCodec = new RandomPrefixInstanceIdentifierSerializer(this.schemaContext, writer.getNamespaceContext());
        String serializedValue = (String)iiCodec.serialize(value);
        for (Map.Entry<URI, String> e : iiCodec.getPrefixes()) {
            writer.writeNamespace(e.getValue(), e.getKey().toString());
        }
        return serializedValue;
    }

    public SchemaContext getSchemaContext() {
        return this.schemaContext;
    }
}

