/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver;

import io.aeron.driver.CongestionControlSupplier;
import io.aeron.driver.FeedbackDelayGenerator;
import io.aeron.driver.FlowControlSupplier;
import io.aeron.driver.MediaDriver;
import io.aeron.driver.OptimalMulticastDelayGenerator;
import io.aeron.driver.ReceiveChannelEndpointSupplier;
import io.aeron.driver.SendChannelEndpointSupplier;
import io.aeron.driver.StaticDelayGenerator;
import io.aeron.driver.ThreadingMode;
import io.aeron.exceptions.AeronException;
import io.aeron.exceptions.ConfigurationException;
import java.io.IOException;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.nio.channels.DatagramChannel;
import java.util.concurrent.TimeUnit;
import org.agrona.BitUtil;
import org.agrona.LangUtil;
import org.agrona.SystemUtil;
import org.agrona.concurrent.BackoffIdleStrategy;
import org.agrona.concurrent.ControllableIdleStrategy;
import org.agrona.concurrent.IdleStrategy;
import org.agrona.concurrent.broadcast.BroadcastBufferDescriptor;
import org.agrona.concurrent.ringbuffer.RingBufferDescriptor;
import org.agrona.concurrent.status.StatusIndicator;
import org.agrona.concurrent.status.StatusIndicatorReader;

public class Configuration {
    public static final String DIR_WARN_IF_EXISTS_PROP_NAME = "aeron.dir.warn.if.exists";
    public static final boolean DIR_WARN_IF_EXISTS = "true".equalsIgnoreCase(System.getProperty("aeron.dir.warn.if.exists", "true"));
    public static final String DIR_DELETE_ON_START_PROP_NAME = "aeron.dir.delete.on.start";
    public static final boolean DIR_DELETE_ON_START = "true".equalsIgnoreCase(System.getProperty("aeron.dir.delete.on.start", "false"));
    public static final String USE_WINDOWS_HIGH_RES_TIMER_PROP_NAME = "aeron.use.windows.high.res.timer";
    public static final boolean USE_WINDOWS_HIGH_RES_TIMER = "true".equalsIgnoreCase(System.getProperty("aeron.use.windows.high.res.timer", "false"));
    public static final String TERM_BUFFER_SPARSE_FILE_PROP_NAME = "aeron.term.buffer.sparse.file";
    public static final boolean TERM_BUFFER_SPARSE_FILE = "true".equalsIgnoreCase(System.getProperty("aeron.term.buffer.sparse.file", "false"));
    public static final String FILE_PAGE_SIZE_PROP_NAME = "aeron.file.page.size";
    public static final int FILE_PAGE_SIZE_DEFAULT = 4096;
    public static final int FILE_PAGE_SIZE = SystemUtil.getSizeAsInt((String)"aeron.file.page.size", (int)4096);
    public static final String PERFORM_STORAGE_CHECKS_PROP_NAME = "aeron.perform.storage.checks";
    public static final boolean PERFORM_STORAGE_CHECKS = "true".equalsIgnoreCase(System.getProperty("aeron.perform.storage.checks", "true"));
    public static final String TERM_BUFFER_LENGTH_PROP_NAME = "aeron.term.buffer.length";
    public static final int TERM_BUFFER_LENGTH_DEFAULT = 0x1000000;
    public static final String IPC_TERM_BUFFER_LENGTH_PROP_NAME = "aeron.ipc.term.buffer.length";
    public static final int TERM_BUFFER_IPC_LENGTH_DEFAULT = 0x4000000;
    public static final int IPC_TERM_BUFFER_LENGTH = SystemUtil.getSizeAsInt((String)"aeron.ipc.term.buffer.length", (int)0x4000000);
    public static final String LOW_FILE_STORE_WARNING_THRESHOLD_PROP_NAME = "aeron.low.file.store.warning.threshold";
    public static final long LOW_FILE_STORE_WARNING_THRESHOLD_DEFAULT = 0xA000000L;
    public static final long LOW_FILE_STORE_WARNING_THRESHOLD = SystemUtil.getSizeAsLong((String)"aeron.low.file.store.warning.threshold", (long)0xA000000L);
    public static final String CONDUCTOR_BUFFER_LENGTH_PROP_NAME = "aeron.conductor.buffer.length";
    public static final int CONDUCTOR_BUFFER_LENGTH_DEFAULT = 0x100000 + RingBufferDescriptor.TRAILER_LENGTH;
    public static final int CONDUCTOR_BUFFER_LENGTH = SystemUtil.getSizeAsInt((String)"aeron.conductor.buffer.length", (int)CONDUCTOR_BUFFER_LENGTH_DEFAULT);
    public static final String TO_CLIENTS_BUFFER_LENGTH_PROP_NAME = "aeron.clients.buffer.length";
    public static final int TO_CLIENTS_BUFFER_LENGTH_DEFAULT = 0x100000 + BroadcastBufferDescriptor.TRAILER_LENGTH;
    public static final int TO_CLIENTS_BUFFER_LENGTH = SystemUtil.getSizeAsInt((String)"aeron.clients.buffer.length", (int)TO_CLIENTS_BUFFER_LENGTH_DEFAULT);
    public static final String COUNTERS_VALUES_BUFFER_LENGTH_PROP_NAME = "aeron.counters.buffer.length";
    public static final int COUNTERS_VALUES_BUFFER_LENGTH_DEFAULT = 0x100000;
    public static final int COUNTERS_VALUES_BUFFER_LENGTH = SystemUtil.getSizeAsInt((String)"aeron.counters.buffer.length", (int)0x100000);
    public static final int COUNTERS_METADATA_BUFFER_LENGTH = COUNTERS_VALUES_BUFFER_LENGTH * 4;
    public static final String ERROR_BUFFER_LENGTH_PROP_NAME = "aeron.error.buffer.length";
    public static final int ERROR_BUFFER_LENGTH_DEFAULT = 0x100000;
    public static final int ERROR_BUFFER_LENGTH = SystemUtil.getSizeAsInt((String)"aeron.error.buffer.length", (int)0x100000);
    public static final String LOSS_REPORT_BUFFER_LENGTH_PROP_NAME = "aeron.loss.report.buffer.length";
    public static final int LOSS_REPORT_BUFFER_LENGTH_DEFAULT = 0x100000;
    public static final int LOSS_REPORT_BUFFER_LENGTH = SystemUtil.getSizeAsInt((String)"aeron.loss.report.buffer.length", (int)0x100000);
    public static final String INITIAL_WINDOW_LENGTH_PROP_NAME = "aeron.rcv.initial.window.length";
    public static final int INITIAL_WINDOW_LENGTH_DEFAULT = 131072;
    public static final String STATUS_MESSAGE_TIMEOUT_PROP_NAME = "aeron.rcv.status.message.timeout";
    public static final long STATUS_MESSAGE_TIMEOUT_DEFAULT_NS = TimeUnit.MILLISECONDS.toNanos(200L);
    public static final String SEND_TO_STATUS_POLL_RATIO_PROP_NAME = "aeron.send.to.status.poll.ratio";
    public static final int SEND_TO_STATUS_POLL_RATIO_DEFAULT = 6;
    public static final String SOCKET_RCVBUF_LENGTH_PROP_NAME = "aeron.socket.so_rcvbuf";
    public static final int SOCKET_RCVBUF_LENGTH_DEFAULT = 131072;
    public static final int SOCKET_RCVBUF_LENGTH = SystemUtil.getSizeAsInt((String)"aeron.socket.so_rcvbuf", (int)131072);
    public static final String SOCKET_SNDBUF_LENGTH_PROP_NAME = "aeron.socket.so_sndbuf";
    public static final int SOCKET_SNDBUF_LENGTH_DEFAULT = 0;
    public static final int SOCKET_SNDBUF_LENGTH = SystemUtil.getSizeAsInt((String)"aeron.socket.so_sndbuf", (int)0);
    public static final String SOCKET_MULTICAST_TTL_PROP_NAME = "aeron.socket.multicast.ttl";
    public static final int SOCKET_MULTICAST_TTL_DEFAULT = 0;
    public static final int SOCKET_MULTICAST_TTL = Integer.getInteger("aeron.socket.multicast.ttl", 0);
    public static final String PUBLICATION_LINGER_PROP_NAME = "aeron.publication.linger.timeout";
    public static final long PUBLICATION_LINGER_DEFAULT_NS = TimeUnit.SECONDS.toNanos(5L);
    public static final long PUBLICATION_LINGER_NS = SystemUtil.getDurationInNanos((String)"aeron.publication.linger.timeout", (long)PUBLICATION_LINGER_DEFAULT_NS);
    public static final String CLIENT_LIVENESS_TIMEOUT_PROP_NAME = "aeron.client.liveness.timeout";
    public static final long CLIENT_LIVENESS_TIMEOUT_DEFAULT_NS = TimeUnit.MILLISECONDS.toNanos(5000L);
    public static final long CLIENT_LIVENESS_TIMEOUT_NS = SystemUtil.getDurationInNanos((String)"aeron.client.liveness.timeout", (long)CLIENT_LIVENESS_TIMEOUT_DEFAULT_NS);
    public static final String IMAGE_LIVENESS_TIMEOUT_PROP_NAME = "aeron.image.liveness.timeout";
    public static final long IMAGE_LIVENESS_TIMEOUT_DEFAULT_NS = TimeUnit.SECONDS.toNanos(10L);
    public static final long IMAGE_LIVENESS_TIMEOUT_NS = SystemUtil.getDurationInNanos((String)"aeron.image.liveness.timeout", (long)IMAGE_LIVENESS_TIMEOUT_DEFAULT_NS);
    public static final String PUBLICATION_TERM_WINDOW_LENGTH_PROP_NAME = "aeron.publication.term.window.length";
    public static final int PUBLICATION_TERM_WINDOW_LENGTH = SystemUtil.getSizeAsInt((String)"aeron.publication.term.window.length", (int)0);
    public static final String IPC_PUBLICATION_TERM_WINDOW_LENGTH_PROP_NAME = "aeron.ipc.publication.term.window.length";
    public static final int IPC_PUBLICATION_TERM_WINDOW_LENGTH = SystemUtil.getSizeAsInt((String)"aeron.ipc.publication.term.window.length", (int)0);
    public static final String PUBLICATION_UNBLOCK_TIMEOUT_PROP_NAME = "aeron.publication.unblock.timeout";
    public static final long PUBLICATION_UNBLOCK_TIMEOUT_DEFAULT_NS = TimeUnit.SECONDS.toNanos(10L);
    public static final long PUBLICATION_UNBLOCK_TIMEOUT_NS = SystemUtil.getDurationInNanos((String)"aeron.publication.unblock.timeout", (long)PUBLICATION_UNBLOCK_TIMEOUT_DEFAULT_NS);
    public static final String PUBLICATION_CONNECTION_TIMEOUT_PROP_NAME = "aeron.publication.connection.timeout";
    public static final long PUBLICATION_CONNECTION_TIMEOUT_DEFAULT_NS = TimeUnit.SECONDS.toNanos(5L);
    public static final long PUBLICATION_CONNECTION_TIMEOUT_NS = SystemUtil.getDurationInNanos((String)"aeron.publication.connection.timeout", (long)PUBLICATION_CONNECTION_TIMEOUT_DEFAULT_NS);
    public static final String SPIES_SIMULATE_CONNECTION_PROP_NAME = "aeron.spies.simulate.connection";
    public static final boolean SPIES_SIMULATE_CONNECTION = "true".equalsIgnoreCase(System.getProperty("aeron.spies.simulate.connection", "false"));
    private static final String DEFAULT_IDLE_STRATEGY = "org.agrona.concurrent.BackoffIdleStrategy";
    public static final long IDLE_MAX_SPINS = 10L;
    public static final long IDLE_MAX_YIELDS = 20L;
    public static final long IDLE_MIN_PARK_NS = 1000L;
    public static final long IDLE_MAX_PARK_NS = TimeUnit.MILLISECONDS.toNanos(1L);
    private static final String CONTROLLABLE_IDLE_STRATEGY = "org.agrona.concurrent.ControllableIdleStrategy";
    public static final String SENDER_IDLE_STRATEGY_PROP_NAME = "aeron.sender.idle.strategy";
    public static final String SENDER_IDLE_STRATEGY = System.getProperty("aeron.sender.idle.strategy", "org.agrona.concurrent.BackoffIdleStrategy");
    public static final String CONDUCTOR_IDLE_STRATEGY_PROP_NAME = "aeron.conductor.idle.strategy";
    public static final String CONDUCTOR_IDLE_STRATEGY = System.getProperty("aeron.conductor.idle.strategy", "org.agrona.concurrent.BackoffIdleStrategy");
    public static final String RECEIVER_IDLE_STRATEGY_PROP_NAME = "aeron.receiver.idle.strategy";
    public static final String RECEIVER_IDLE_STRATEGY = System.getProperty("aeron.receiver.idle.strategy", "org.agrona.concurrent.BackoffIdleStrategy");
    public static final String SHARED_NETWORK_IDLE_STRATEGY_PROP_NAME = "aeron.sharednetwork.idle.strategy";
    public static final String SHARED_NETWORK_IDLE_STRATEGY = System.getProperty("aeron.sharednetwork.idle.strategy", "org.agrona.concurrent.BackoffIdleStrategy");
    public static final String SHARED_IDLE_STRATEGY_PROP_NAME = "aeron.shared.idle.strategy";
    public static final String SHARED_IDLE_STRATEGY = System.getProperty("aeron.shared.idle.strategy", "org.agrona.concurrent.BackoffIdleStrategy");
    public static final String UNICAST_FLOW_CONTROL_STRATEGY_PROP_NAME = "aeron.unicast.flow.control.strategy";
    public static final String UNICAST_FLOW_CONTROL_STRATEGY = System.getProperty("aeron.unicast.flow.control.strategy", "io.aeron.driver.UnicastFlowControl");
    public static final String MULTICAST_FLOW_CONTROL_STRATEGY_PROP_NAME = "aeron.multicast.flow.control.strategy";
    public static final String MULTICAST_FLOW_CONTROL_STRATEGY = System.getProperty("aeron.multicast.flow.control.strategy", "io.aeron.driver.MaxMulticastFlowControl");
    public static final String UNICAST_FLOW_CONTROL_STRATEGY_SUPPLIER_PROP_NAME = "aeron.unicast.FlowControl.supplier";
    public static final String UNICAST_FLOW_CONTROL_STRATEGY_SUPPLIER = System.getProperty("aeron.unicast.FlowControl.supplier", "io.aeron.driver.DefaultUnicastFlowControlSupplier");
    public static final String MULTICAST_FLOW_CONTROL_STRATEGY_SUPPLIER_PROP_NAME = "aeron.multicast.FlowControl.supplier";
    public static final String MULTICAST_FLOW_CONTROL_STRATEGY_SUPPLIER = System.getProperty("aeron.multicast.FlowControl.supplier", "io.aeron.driver.DefaultMulticastFlowControlSupplier");
    public static final int MAX_UDP_PAYLOAD_LENGTH = 65504;
    public static final String MTU_LENGTH_PROP_NAME = "aeron.mtu.length";
    public static final int MTU_LENGTH_DEFAULT = 1408;
    public static final int MTU_LENGTH = SystemUtil.getSizeAsInt((String)"aeron.mtu.length", (int)1408);
    public static final String IPC_MTU_LENGTH_PROP_NAME = "aeron.ipc.mtu.length";
    public static final int IPC_MTU_LENGTH = SystemUtil.getSizeAsInt((String)"aeron.ipc.mtu.length", (int)1408);
    public static final String THREADING_MODE_PROP_NAME = "aeron.threading.mode";
    public static final ThreadingMode THREADING_MODE_DEFAULT = ThreadingMode.valueOf(System.getProperty("aeron.threading.mode", ThreadingMode.DEDICATED.name()));
    public static final String TIMER_INTERVAL_PROP_NAME = "aeron.timer.interval";
    public static final long DEFAULT_TIMER_INTERVAL_NS = TimeUnit.SECONDS.toNanos(1L);
    public static final long TIMER_INTERVAL_NS = SystemUtil.getDurationInNanos((String)"aeron.timer.interval", (long)DEFAULT_TIMER_INTERVAL_NS);
    public static final String COUNTER_FREE_TO_REUSE_TIMEOUT_PROP_NAME = "aeron.counters.free.to.reuse.timeout";
    public static final long DEFAULT_COUNTER_FREE_TO_REUSE_TIMEOUT_NS = TimeUnit.SECONDS.toNanos(1L);
    public static final String SEND_CHANNEL_ENDPOINT_SUPPLIER_PROP_NAME = "aeron.SendChannelEndpoint.supplier";
    public static final String SEND_CHANNEL_ENDPOINT_SUPPLIER = System.getProperty("aeron.SendChannelEndpoint.supplier", "io.aeron.driver.DefaultSendChannelEndpointSupplier");
    public static final String RECEIVE_CHANNEL_ENDPOINT_SUPPLIER_PROP_NAME = "aeron.ReceiveChannelEndpoint.supplier";
    public static final String RECEIVE_CHANNEL_ENDPOINT_SUPPLIER = System.getProperty("aeron.ReceiveChannelEndpoint.supplier", "io.aeron.driver.DefaultReceiveChannelEndpointSupplier");
    public static final String SM_APPLICATION_SPECIFIC_FEEDBACK_PROP_NAME = "aeron.flow.control.sm.applicationSpecificFeedback";
    public static final byte[] SM_APPLICATION_SPECIFIC_FEEDBACK = BitUtil.fromHex((String)System.getProperty("aeron.flow.control.sm.applicationSpecificFeedback", ""));
    public static final String CONGESTION_CONTROL_STRATEGY_SUPPLIER_PROP_NAME = "aeron.CongestionControl.supplier";
    public static final String CONGESTION_CONTROL_STRATEGY_SUPPLIER = System.getProperty("aeron.CongestionControl.supplier", "io.aeron.driver.DefaultCongestionControlSupplier");
    public static final String PUBLICATION_RESERVED_SESSION_ID_LOW_PROP_NAME = "aeron.publication.reserved.session.id.low";
    public static final int PUBLICATION_RESERVED_SESSION_ID_LOW_DEFAULT = -1;
    public static final int PUBLICATION_RESERVED_SESSION_ID_LOW = Integer.getInteger("aeron.publication.reserved.session.id.low", -1);
    public static final String PUBLICATION_RESERVED_SESSION_ID_HIGH_PROP_NAME = "aeron.publication.reserved.session.id.high";
    public static final int PUBLICATION_RESERVED_SESSION_ID_HIGH_DEFAULT = 1000;
    public static final int PUBLICATION_RESERVED_SESSION_ID_HIGH = Integer.getInteger("aeron.publication.reserved.session.id.high", 1000);
    public static final int COMMAND_DRAIN_LIMIT = 10;
    public static final int CMD_QUEUE_CAPACITY = 256;
    public static final long PENDING_SETUPS_TIMEOUT_NS = TimeUnit.MILLISECONDS.toNanos(1000L);
    public static final long PUBLICATION_SETUP_TIMEOUT_NS = TimeUnit.MILLISECONDS.toNanos(100L);
    public static final long PUBLICATION_HEARTBEAT_TIMEOUT_NS = TimeUnit.MILLISECONDS.toNanos(100L);
    public static final int NAK_GROUPSIZE_DEFAULT = 10;
    public static final int NAK_GRTT_DEFAULT = 10;
    public static final long NAK_MAX_BACKOFF_DEFAULT = TimeUnit.MILLISECONDS.toNanos(60L);
    public static final OptimalMulticastDelayGenerator NAK_MULTICAST_DELAY_GENERATOR = new OptimalMulticastDelayGenerator(NAK_MAX_BACKOFF_DEFAULT, 10.0, 10.0);
    public static final long NAK_UNICAST_DELAY_DEFAULT_NS = TimeUnit.MILLISECONDS.toNanos(60L);
    public static final StaticDelayGenerator NAK_UNICAST_DELAY_GENERATOR = new StaticDelayGenerator(NAK_UNICAST_DELAY_DEFAULT_NS, true);
    public static final long RETRANSMIT_UNICAST_DELAY_DEFAULT_NS = TimeUnit.NANOSECONDS.toNanos(0L);
    public static final FeedbackDelayGenerator RETRANSMIT_UNICAST_DELAY_GENERATOR = () -> RETRANSMIT_UNICAST_DELAY_DEFAULT_NS;
    public static final long RETRANSMIT_UNICAST_LINGER_DEFAULT_NS = TimeUnit.MILLISECONDS.toNanos(60L);
    public static final FeedbackDelayGenerator RETRANSMIT_UNICAST_LINGER_GENERATOR = () -> RETRANSMIT_UNICAST_LINGER_DEFAULT_NS;
    public static final int MAX_RETRANSMITS_DEFAULT = 16;

    public static int publicationTermWindowLength(int termBufferLength) {
        int publicationTermWindowLength = termBufferLength / 2;
        if (0 != PUBLICATION_TERM_WINDOW_LENGTH) {
            publicationTermWindowLength = Math.min(PUBLICATION_TERM_WINDOW_LENGTH, publicationTermWindowLength);
        }
        return publicationTermWindowLength;
    }

    public static int ipcPublicationTermWindowLength(int termBufferLength) {
        int publicationTermWindowLength = termBufferLength;
        if (0 != IPC_PUBLICATION_TERM_WINDOW_LENGTH) {
            publicationTermWindowLength = Math.min(IPC_PUBLICATION_TERM_WINDOW_LENGTH, publicationTermWindowLength);
        }
        return publicationTermWindowLength;
    }

    public static int ipcTermBufferLength(int termBufferLength) {
        return 0 != IPC_TERM_BUFFER_LENGTH ? IPC_TERM_BUFFER_LENGTH : termBufferLength;
    }

    public static IdleStrategy agentIdleStrategy(String strategyName, StatusIndicator controllableStatus) {
        ControllableIdleStrategy idleStrategy = null;
        switch (strategyName) {
            case "org.agrona.concurrent.BackoffIdleStrategy": {
                idleStrategy = new BackoffIdleStrategy(10L, 20L, 1000L, IDLE_MAX_PARK_NS);
                break;
            }
            case "org.agrona.concurrent.ControllableIdleStrategy": {
                idleStrategy = new ControllableIdleStrategy((StatusIndicatorReader)controllableStatus);
                controllableStatus.setOrdered(4L);
                break;
            }
            default: {
                try {
                    idleStrategy = (IdleStrategy)Class.forName(strategyName).getConstructor(new Class[0]).newInstance(new Object[0]);
                    break;
                }
                catch (Exception ex) {
                    LangUtil.rethrowUnchecked((Throwable)ex);
                }
            }
        }
        return idleStrategy;
    }

    static IdleStrategy senderIdleStrategy(StatusIndicator controllableStatus) {
        return Configuration.agentIdleStrategy(SENDER_IDLE_STRATEGY, controllableStatus);
    }

    static IdleStrategy conductorIdleStrategy(StatusIndicator controllableStatus) {
        return Configuration.agentIdleStrategy(CONDUCTOR_IDLE_STRATEGY, controllableStatus);
    }

    static IdleStrategy receiverIdleStrategy(StatusIndicator controllableStatus) {
        return Configuration.agentIdleStrategy(RECEIVER_IDLE_STRATEGY, controllableStatus);
    }

    static IdleStrategy sharedNetworkIdleStrategy(StatusIndicator controllableStatus) {
        return Configuration.agentIdleStrategy(SHARED_NETWORK_IDLE_STRATEGY, controllableStatus);
    }

    static IdleStrategy sharedIdleStrategy(StatusIndicator controllableStatus) {
        return Configuration.agentIdleStrategy(SHARED_IDLE_STRATEGY, controllableStatus);
    }

    static int termBufferLength() {
        return SystemUtil.getSizeAsInt((String)TERM_BUFFER_LENGTH_PROP_NAME, (int)0x1000000);
    }

    static int initialWindowLength() {
        return SystemUtil.getSizeAsInt((String)INITIAL_WINDOW_LENGTH_PROP_NAME, (int)131072);
    }

    static long statusMessageTimeout() {
        return SystemUtil.getDurationInNanos((String)STATUS_MESSAGE_TIMEOUT_PROP_NAME, (long)STATUS_MESSAGE_TIMEOUT_DEFAULT_NS);
    }

    static int sendToStatusMessagePollRatio() {
        return Integer.getInteger(SEND_TO_STATUS_POLL_RATIO_PROP_NAME, 6);
    }

    static long counterFreeToReuseTimeout() {
        return SystemUtil.getDurationInNanos((String)COUNTER_FREE_TO_REUSE_TIMEOUT_PROP_NAME, (long)DEFAULT_COUNTER_FREE_TO_REUSE_TIMEOUT_NS);
    }

    static SendChannelEndpointSupplier sendChannelEndpointSupplier() {
        SendChannelEndpointSupplier supplier = null;
        try {
            supplier = (SendChannelEndpointSupplier)Class.forName(SEND_CHANNEL_ENDPOINT_SUPPLIER).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception ex) {
            LangUtil.rethrowUnchecked((Throwable)ex);
        }
        return supplier;
    }

    static ReceiveChannelEndpointSupplier receiveChannelEndpointSupplier() {
        ReceiveChannelEndpointSupplier supplier = null;
        try {
            supplier = (ReceiveChannelEndpointSupplier)Class.forName(RECEIVE_CHANNEL_ENDPOINT_SUPPLIER).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception ex) {
            LangUtil.rethrowUnchecked((Throwable)ex);
        }
        return supplier;
    }

    static FlowControlSupplier unicastFlowControlSupplier() {
        FlowControlSupplier supplier = null;
        try {
            supplier = (FlowControlSupplier)Class.forName(UNICAST_FLOW_CONTROL_STRATEGY_SUPPLIER).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception ex) {
            LangUtil.rethrowUnchecked((Throwable)ex);
        }
        return supplier;
    }

    static FlowControlSupplier multicastFlowControlSupplier() {
        FlowControlSupplier supplier = null;
        try {
            supplier = (FlowControlSupplier)Class.forName(MULTICAST_FLOW_CONTROL_STRATEGY_SUPPLIER).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception ex) {
            LangUtil.rethrowUnchecked((Throwable)ex);
        }
        return supplier;
    }

    static CongestionControlSupplier congestionControlSupplier() {
        CongestionControlSupplier supplier = null;
        try {
            supplier = (CongestionControlSupplier)Class.forName(CONGESTION_CONTROL_STRATEGY_SUPPLIER).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception ex) {
            LangUtil.rethrowUnchecked((Throwable)ex);
        }
        return supplier;
    }

    static void validateInitialWindowLength(int initialWindowLength, int mtuLength) {
        if (mtuLength > initialWindowLength) {
            throw new ConfigurationException("initial window length must be >= to MTU length: " + mtuLength);
        }
    }

    static void validateMtuLength(int mtuLength) {
        if (mtuLength < 32 || mtuLength > 65504) {
            throw new ConfigurationException("mtuLength must be a >= HEADER_LENGTH and <= MAX_UDP_PAYLOAD_LENGTH: " + mtuLength);
        }
        if ((mtuLength & 0x1F) != 0) {
            throw new ConfigurationException("mtuLength must be a multiple of FRAME_ALIGNMENT: " + mtuLength);
        }
    }

    static void validatePublicationLingerTimeoutNs(long timeoutNs, long driverLingerTimeoutNs) {
        if (timeoutNs < driverLingerTimeoutNs) {
            throw new ConfigurationException("linger must be greater than or equal to driver linger timeout: " + timeoutNs);
        }
    }

    static void validateSocketBufferLengths(MediaDriver.Context ctx) {
        try (DatagramChannel probe = DatagramChannel.open();){
            int soSndBuf;
            int defaultSoSndBuf = probe.getOption(StandardSocketOptions.SO_SNDBUF);
            probe.setOption((SocketOption)StandardSocketOptions.SO_SNDBUF, (Object)Integer.MAX_VALUE);
            int maxSoSndBuf = probe.getOption(StandardSocketOptions.SO_SNDBUF);
            if (maxSoSndBuf < SOCKET_SNDBUF_LENGTH) {
                System.err.format("WARNING: Could not get desired SO_SNDBUF, adjust OS to allow %s: attempted=%d, actual=%d%n", SOCKET_SNDBUF_LENGTH_PROP_NAME, SOCKET_SNDBUF_LENGTH, maxSoSndBuf);
            }
            probe.setOption((SocketOption)StandardSocketOptions.SO_RCVBUF, (Object)Integer.MAX_VALUE);
            int maxSoRcvBuf = probe.getOption(StandardSocketOptions.SO_RCVBUF);
            if (maxSoRcvBuf < SOCKET_RCVBUF_LENGTH) {
                System.err.format("WARNING: Could not get desired SO_RCVBUF, adjust OS to allow %s: attempted=%d, actual=%d%n", SOCKET_RCVBUF_LENGTH_PROP_NAME, SOCKET_RCVBUF_LENGTH, maxSoRcvBuf);
            }
            int n = soSndBuf = 0 == SOCKET_SNDBUF_LENGTH ? defaultSoSndBuf : SOCKET_SNDBUF_LENGTH;
            if (ctx.mtuLength() > soSndBuf) {
                throw new ConfigurationException(String.format("MTU greater than socket SO_SNDBUF, adjust %s to match MTU: mtuLength=%d, SO_SNDBUF=%d", SOCKET_SNDBUF_LENGTH_PROP_NAME, ctx.mtuLength(), soSndBuf));
            }
            if (ctx.initialWindowLength() > maxSoRcvBuf) {
                throw new ConfigurationException("window length greater than socket SO_RCVBUF, increase 'aeron.rcv.initial.window.length' to match window: windowLength=" + ctx.initialWindowLength() + ", SO_RCVBUF=" + maxSoRcvBuf);
            }
        }
        catch (IOException ex) {
            throw new AeronException("probe socket: " + ex.toString(), (Throwable)ex);
        }
    }

    static void validatePageSize(int pageSize) {
        if (pageSize < 4096) {
            throw new ConfigurationException("page size less than min size of 4096: " + pageSize);
        }
        if (pageSize > 0x40000000) {
            throw new ConfigurationException("page size greater than max size of 1073741824: " + pageSize);
        }
        if (!BitUtil.isPowerOfTwo((int)pageSize)) {
            throw new ConfigurationException("page size not a power of 2: " + pageSize);
        }
    }
}

