/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.binding.runtime.spi;

import com.google.common.annotations.Beta;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.binding.runtime.api.ClassLoadingStrategy;
import org.opendaylight.yangtools.util.ClassLoaderUtils;

@Beta
public abstract class GeneratedClassLoadingStrategy
implements ClassLoadingStrategy {
    protected GeneratedClassLoadingStrategy() {
    }

    public static final @NonNull GeneratedClassLoadingStrategy getTCCLClassLoadingStrategy() {
        return TCCLClassLoadingStrategy.INSTANCE;
    }

    public static final @NonNull GeneratedClassLoadingStrategy getAlwaysFailClassLoadingStrategy() {
        return AlwaysFailClassLoadingStrategy.INSTANCE;
    }

    private static final class TCCLClassLoadingStrategy
    extends GeneratedClassLoadingStrategy {
        static final @NonNull TCCLClassLoadingStrategy INSTANCE = new TCCLClassLoadingStrategy();

        private TCCLClassLoadingStrategy() {
        }

        public Class<?> loadClass(String fullyQualifiedName) throws ClassNotFoundException {
            return ClassLoaderUtils.loadClassWithTCCL((String)fullyQualifiedName);
        }
    }

    private static final class AlwaysFailClassLoadingStrategy
    extends GeneratedClassLoadingStrategy {
        static final @NonNull AlwaysFailClassLoadingStrategy INSTANCE = new AlwaysFailClassLoadingStrategy();

        private AlwaysFailClassLoadingStrategy() {
        }

        public Class<?> loadClass(String fullyQualifiedName) throws ClassNotFoundException {
            throw new ClassNotFoundException(fullyQualifiedName);
        }
    }
}

