/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.binding.runtime.spi;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.checkerframework.checker.lock.qual.Holding;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.binding.runtime.api.BindingRuntimeContext;
import org.opendaylight.binding.runtime.api.BindingRuntimeGenerator;
import org.opendaylight.binding.runtime.api.BindingRuntimeTypes;
import org.opendaylight.binding.runtime.api.ClassLoadingStrategy;
import org.opendaylight.binding.runtime.api.DefaultBindingRuntimeContext;
import org.opendaylight.binding.runtime.spi.AbstractModuleInfoTracker;
import org.opendaylight.yangtools.util.ClassLoaderUtils;
import org.opendaylight.yangtools.yang.binding.YangModuleInfo;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContext;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContextProvider;
import org.opendaylight.yangtools.yang.model.parser.api.YangParserFactory;
import org.opendaylight.yangtools.yang.model.repo.api.SourceIdentifier;
import org.opendaylight.yangtools.yang.model.repo.api.YangTextSchemaSource;
import org.opendaylight.yangtools.yang.model.repo.spi.SchemaSourceProvider;
import org.opendaylight.yangtools.yang.parser.repo.YangTextSchemaContextResolver;

@Beta
public class ModuleInfoBackedContext
extends AbstractModuleInfoTracker
implements ClassLoadingStrategy,
EffectiveModelContextProvider,
SchemaSourceProvider<YangTextSchemaSource> {
    private static final LoadingCache<ClassLoadingStrategy, LoadingCache<ImmutableSet<YangModuleInfo>, ModuleInfoBackedContext>> CONTEXT_CACHES = CacheBuilder.newBuilder().weakKeys().build((CacheLoader)new CacheLoader<ClassLoadingStrategy, LoadingCache<ImmutableSet<YangModuleInfo>, ModuleInfoBackedContext>>(){

        public LoadingCache<ImmutableSet<YangModuleInfo>, ModuleInfoBackedContext> load(final ClassLoadingStrategy strategy) {
            return CacheBuilder.newBuilder().weakValues().build((CacheLoader)new CacheLoader<Set<YangModuleInfo>, ModuleInfoBackedContext>(){

                public ModuleInfoBackedContext load(Set<YangModuleInfo> key) {
                    ModuleInfoBackedContext context = ModuleInfoBackedContext.create(strategy);
                    context.registerModuleInfos(key);
                    return context;
                }
            });
        }
    });

    ModuleInfoBackedContext(YangTextSchemaContextResolver resolver) {
        super(resolver);
    }

    @Beta
    public static ModuleInfoBackedContext cacheContext(ClassLoadingStrategy loadingStrategy, ImmutableSet<YangModuleInfo> infos) {
        return (ModuleInfoBackedContext)((LoadingCache)CONTEXT_CACHES.getUnchecked((Object)loadingStrategy)).getUnchecked(infos);
    }

    public static ModuleInfoBackedContext create() {
        return ModuleInfoBackedContext.create("unnamed");
    }

    public static ModuleInfoBackedContext create(String id) {
        return new ModuleInfoBackedContext(YangTextSchemaContextResolver.create((String)id));
    }

    public static ModuleInfoBackedContext create(ClassLoadingStrategy loadingStrategy) {
        return ModuleInfoBackedContext.create("unnamed", loadingStrategy);
    }

    public static ModuleInfoBackedContext create(String id, ClassLoadingStrategy loadingStrategy) {
        return new WithFallback(YangTextSchemaContextResolver.create((String)id), loadingStrategy);
    }

    public static ModuleInfoBackedContext create(String id, YangParserFactory factory) {
        return new ModuleInfoBackedContext(YangTextSchemaContextResolver.create((String)id, (YangParserFactory)factory));
    }

    public static ModuleInfoBackedContext create(String id, YangParserFactory factory, ClassLoadingStrategy loadingStrategy) {
        return new WithFallback(YangTextSchemaContextResolver.create((String)id, (YangParserFactory)factory), loadingStrategy);
    }

    public final EffectiveModelContext getEffectiveModelContext() {
        Optional<? extends EffectiveModelContext> contextOptional = this.tryToCreateModelContext();
        Preconditions.checkState((boolean)contextOptional.isPresent(), (Object)"Unable to recreate SchemaContext, error while parsing");
        return contextOptional.get();
    }

    public final synchronized Class<?> loadClass(String fullyQualifiedName) throws ClassNotFoundException {
        ClassLoader loader = this.findClassLoader(fullyQualifiedName);
        return loader != null ? ClassLoaderUtils.loadClass((ClassLoader)loader, (String)fullyQualifiedName) : this.loadUnknownClass(fullyQualifiedName);
    }

    public final ListenableFuture<? extends YangTextSchemaSource> getSource(SourceIdentifier sourceIdentifier) {
        return this.getResolverSource(sourceIdentifier);
    }

    @Beta
    public final @NonNull BindingRuntimeContext createRuntimeContext(BindingRuntimeGenerator generator) {
        return DefaultBindingRuntimeContext.create((BindingRuntimeTypes)generator.generateTypeMapping(this.tryToCreateModelContext().orElseThrow()), (ClassLoadingStrategy)this);
    }

    public final Optional<? extends EffectiveModelContext> tryToCreateModelContext() {
        return this.getResolverEffectiveModel();
    }

    @Holding(value={"this"})
    Class<?> loadUnknownClass(String fullyQualifiedName) throws ClassNotFoundException {
        throw new ClassNotFoundException(fullyQualifiedName);
    }

    private static final class WithFallback
    extends ModuleInfoBackedContext {
        private final @NonNull ClassLoadingStrategy fallback;

        WithFallback(YangTextSchemaContextResolver resolver, ClassLoadingStrategy fallback) {
            super(resolver);
            this.fallback = Objects.requireNonNull(fallback);
        }

        @Override
        Class<?> loadUnknownClass(String fullyQualifiedName) throws ClassNotFoundException {
            Class cls = this.fallback.loadClass(fullyQualifiedName);
            this.registerImplicitBindingClass(cls);
            return cls;
        }
    }
}

