/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.concepts;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.Objects;
import org.checkerframework.checker.index.qual.NonNegative;
import org.eclipse.jdt.annotation.NonNull;

@Beta
public final class SemVer
implements Comparable<SemVer>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final int major;
    private final int minor;
    private final int patch;

    private SemVer(int major, int minor, int patch) {
        Preconditions.checkArgument((major >= 0 ? 1 : 0) != 0);
        this.major = major;
        Preconditions.checkArgument((minor >= 0 ? 1 : 0) != 0);
        this.minor = minor;
        Preconditions.checkArgument((patch >= 0 ? 1 : 0) != 0);
        this.patch = patch;
    }

    public static @NonNull SemVer create(@NonNegative int major) {
        return SemVer.create(major, 0);
    }

    public static @NonNull SemVer create(@NonNegative int major, @NonNegative int minor) {
        return SemVer.create(major, minor, 0);
    }

    public static @NonNull SemVer create(@NonNegative int major, @NonNegative int minor, @NonNegative int patch) {
        return new SemVer(major, minor, patch);
    }

    public static @NonNull SemVer valueOf(@NonNull String str) {
        int minorIdx = str.indexOf(46);
        if (minorIdx == -1) {
            return SemVer.create(Integer.parseInt(str));
        }
        int patchIdx = str.indexOf(46, minorIdx + 1);
        if (patchIdx == -1) {
            String minorStr = str.substring(minorIdx + 1);
            return SemVer.create(Integer.parseInt(str.substring(0, minorIdx), 10), Integer.parseInt(minorStr, 10));
        }
        String minorStr = str.substring(minorIdx + 1, patchIdx);
        return SemVer.create(Integer.parseInt(str.substring(0, minorIdx), 10), Integer.parseInt(minorStr, 10), Integer.parseInt(str.substring(patchIdx + 1), 10));
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getPatch() {
        return this.patch;
    }

    @Override
    public int compareTo(SemVer other) {
        int cmp = Integer.compare(this.major, other.major);
        if (cmp == 0 && (cmp = Integer.compare(this.minor, other.minor)) == 0) {
            return Integer.compare(this.patch, other.patch);
        }
        return cmp;
    }

    public int hashCode() {
        return Objects.hash(this.major, this.minor, this.patch);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof SemVer)) {
            return false;
        }
        SemVer o = (SemVer)obj;
        return this.major == o.major && this.minor == o.minor && this.patch == o.patch;
    }

    public String toString() {
        return this.major + "." + this.minor + "." + this.patch;
    }
}

