/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.codec.gson;

import com.google.common.annotations.Beta;
import com.google.common.base.Stopwatch;
import com.google.common.base.Verify;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.data.codec.gson.JSONCodec;
import org.opendaylight.yangtools.yang.data.codec.gson.JSONCodecFactory;
import org.opendaylight.yangtools.yang.data.codec.gson.Lhotka02JSONCodecFactory;
import org.opendaylight.yangtools.yang.data.codec.gson.RFC7951JSONCodecFactory;
import org.opendaylight.yangtools.yang.data.util.codec.CodecCache;
import org.opendaylight.yangtools.yang.data.util.codec.LazyCodecCache;
import org.opendaylight.yangtools.yang.data.util.codec.NoopCodecCache;
import org.opendaylight.yangtools.yang.data.util.codec.PrecomputedCodecCache;
import org.opendaylight.yangtools.yang.data.util.codec.SharedCodecCache;
import org.opendaylight.yangtools.yang.model.api.DataNodeContainer;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.api.TypeAware;
import org.opendaylight.yangtools.yang.model.api.TypedDataSchemaNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public enum JSONCodecFactorySupplier {
    RFC7951{

        @Override
        JSONCodecFactory createFactory(SchemaContext context, CodecCache<JSONCodec<?>> cache) {
            return new RFC7951JSONCodecFactory(context, cache);
        }
    }
    ,
    DRAFT_LHOTKA_NETMOD_YANG_JSON_02{

        @Override
        JSONCodecFactory createFactory(SchemaContext context, CodecCache<JSONCodec<?>> cache) {
            return new Lhotka02JSONCodecFactory(context, cache);
        }
    };

    private static final Logger LOG;
    private final LoadingCache<SchemaContext, JSONCodecFactory> precomputed = CacheBuilder.newBuilder().weakKeys().build((CacheLoader)new EagerCacheLoader(this::createFactory));
    private final LoadingCache<SchemaContext, JSONCodecFactory> shared = CacheBuilder.newBuilder().weakKeys().build((CacheLoader)new CacheLoader<SchemaContext, JSONCodecFactory>(){

        public JSONCodecFactory load(SchemaContext key) {
            return JSONCodecFactorySupplier.this.createFactory(key, (CodecCache<JSONCodec<?>>)new SharedCodecCache());
        }
    });

    public @NonNull JSONCodecFactory getPrecomputed(@NonNull SchemaContext context) {
        return (JSONCodecFactory)((Object)Verify.verifyNotNull((Object)((Object)((JSONCodecFactory)((Object)this.precomputed.getUnchecked((Object)context))))));
    }

    public @NonNull Optional<JSONCodecFactory> getPrecomputedIfAvailable(@NonNull SchemaContext context) {
        return Optional.ofNullable((JSONCodecFactory)((Object)this.precomputed.getIfPresent((Object)context)));
    }

    public @NonNull JSONCodecFactory getShared(@NonNull SchemaContext context) {
        return (JSONCodecFactory)((Object)Verify.verifyNotNull((Object)((Object)((JSONCodecFactory)((Object)this.shared.getUnchecked((Object)context))))));
    }

    public @NonNull JSONCodecFactory createLazy(@NonNull SchemaContext context) {
        return this.createFactory(context, (CodecCache<JSONCodec<?>>)new LazyCodecCache());
    }

    public @NonNull JSONCodecFactory createSimple(@NonNull SchemaContext context) {
        return this.createFactory(context, (CodecCache<JSONCodec<?>>)NoopCodecCache.getInstance());
    }

    abstract @NonNull JSONCodecFactory createFactory(SchemaContext var1, CodecCache<JSONCodec<?>> var2);

    static {
        LOG = LoggerFactory.getLogger(JSONCodecFactorySupplier.class);
    }

    private static final class EagerCacheLoader
    extends CacheLoader<SchemaContext, JSONCodecFactory> {
        private final BiFunction<SchemaContext, CodecCache<JSONCodec<?>>, JSONCodecFactory> factorySupplier;

        EagerCacheLoader(BiFunction<SchemaContext, CodecCache<JSONCodec<?>>, JSONCodecFactory> factorySupplier) {
            this.factorySupplier = Objects.requireNonNull(factorySupplier);
        }

        public JSONCodecFactory load(SchemaContext key) {
            Stopwatch sw = Stopwatch.createStarted();
            LazyCodecCache lazyCache = new LazyCodecCache();
            JSONCodecFactory lazy = this.factorySupplier.apply(key, (CodecCache<JSONCodec<?>>)lazyCache);
            int visitedLeaves = EagerCacheLoader.requestCodecsForChildren(lazy, (DataNodeContainer)key);
            sw.stop();
            PrecomputedCodecCache cache = lazyCache.toPrecomputed();
            LOG.debug("{} leaf nodes resulted in {} simple and {} complex codecs in {}", new Object[]{visitedLeaves, cache.simpleSize(), cache.complexSize(), sw});
            return this.factorySupplier.apply(key, (CodecCache<JSONCodec<?>>)cache);
        }

        private static int requestCodecsForChildren(JSONCodecFactory lazy, DataNodeContainer parent) {
            int ret = 0;
            for (DataSchemaNode child : parent.getChildNodes()) {
                if (child instanceof TypedDataSchemaNode) {
                    lazy.codecFor((TypeAware)((TypedDataSchemaNode)child));
                    ++ret;
                    continue;
                }
                if (!(child instanceof DataNodeContainer)) continue;
                ret += EagerCacheLoader.requestCodecsForChildren(lazy, (DataNodeContainer)child);
            }
            return ret;
        }
    }
}

