/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.codec.gson;

import com.google.common.base.Preconditions;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.net.URI;
import java.util.Iterator;
import java.util.Objects;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.codec.gson.JSONCodec;
import org.opendaylight.yangtools.yang.data.codec.gson.JSONCodecFactory;
import org.opendaylight.yangtools.yang.data.util.AbstractModuleStringInstanceIdentifierCodec;
import org.opendaylight.yangtools.yang.data.util.DataSchemaContextTree;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.LeafSchemaNode;
import org.opendaylight.yangtools.yang.model.api.Module;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.api.TypeAware;

abstract class JSONInstanceIdentifierCodec
extends AbstractModuleStringInstanceIdentifierCodec
implements JSONCodec<YangInstanceIdentifier> {
    private final DataSchemaContextTree dataContextTree;
    private final JSONCodecFactory codecFactory;
    private final SchemaContext context;

    JSONInstanceIdentifierCodec(SchemaContext context, JSONCodecFactory jsonCodecFactory) {
        this.context = Objects.requireNonNull(context);
        this.dataContextTree = DataSchemaContextTree.from((SchemaContext)context);
        this.codecFactory = Objects.requireNonNull(jsonCodecFactory);
    }

    protected final Module moduleForPrefix(String prefix) {
        Iterator modules = this.context.findModules(prefix).iterator();
        return modules.hasNext() ? (Module)modules.next() : null;
    }

    protected final String prefixForNamespace(URI namespace) {
        Iterator modules = this.context.findModules(namespace).iterator();
        return modules.hasNext() ? ((Module)modules.next()).getName() : null;
    }

    protected final DataSchemaContextTree getDataContextTree() {
        return this.dataContextTree;
    }

    protected final Object deserializeKeyValue(DataSchemaNode schemaNode, String value) {
        Objects.requireNonNull(schemaNode, "schemaNode cannot be null");
        Preconditions.checkArgument((boolean)(schemaNode instanceof LeafSchemaNode), (Object)"schemaNode must be of type LeafSchemaNode");
        JSONCodec objectJSONCodec = (JSONCodec)this.codecFactory.codecFor((TypeAware)((LeafSchemaNode)schemaNode));
        return objectJSONCodec.parseValue(null, value);
    }

    public final Class<YangInstanceIdentifier> getDataType() {
        return YangInstanceIdentifier.class;
    }

    public final YangInstanceIdentifier parseValue(Object ctx, String str) {
        return (YangInstanceIdentifier)this.deserialize(str);
    }

    @Override
    public final void writeValue(JsonWriter ctx, YangInstanceIdentifier value) throws IOException {
        ctx.value((String)this.serialize(value));
    }
}

