/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.spi.source;

import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.model.api.meta.StatementSource;
import org.opendaylight.yangtools.yang.parser.spi.source.StatementSourceReference;

public abstract class DeclarationInTextSource
implements StatementSourceReference {
    private final String sourceName;

    DeclarationInTextSource(String sourceName) {
        this.sourceName = sourceName;
    }

    public static @NonNull DeclarationInTextSource inSource(String sourceName) {
        return new InSource(sourceName);
    }

    public static @NonNull DeclarationInTextSource atLine(String sourceName, int line) {
        return new AtLine(sourceName, line);
    }

    public static @NonNull DeclarationInTextSource atPosition(String sourceName, int line, int position) {
        return new AtPosition(sourceName, line, position);
    }

    public final String getSourceName() {
        return this.sourceName;
    }

    @Override
    public final StatementSource getStatementSource() {
        return StatementSource.DECLARATION;
    }

    public final int hashCode() {
        return this.hashCodeImpl();
    }

    public final boolean equals(Object obj) {
        return this == obj || obj != null && this.getClass().equals(obj.getClass()) && this.equalsImpl((DeclarationInTextSource)obj);
    }

    @Override
    public String toString() {
        return this.sourceName == null ? "null" : this.sourceName;
    }

    int hashCodeImpl() {
        return Objects.hashCode(this.sourceName);
    }

    boolean equalsImpl(DeclarationInTextSource obj) {
        return Objects.equals(this.sourceName, obj.sourceName);
    }

    private static final class AtPosition
    extends AtLine {
        private final int character;

        AtPosition(String sourceName, int line, int character) {
            super(sourceName, line);
            this.character = character;
        }

        @Override
        int hashCodeImpl() {
            return super.hashCodeImpl() * 31 + this.character;
        }

        @Override
        boolean equalsImpl(DeclarationInTextSource obj) {
            return this.character == ((AtPosition)obj).character && super.equalsImpl(obj);
        }

        @Override
        public String toString() {
            return super.toString() + ":" + this.character;
        }
    }

    private static class AtLine
    extends InSource {
        private final int line;

        AtLine(String sourceName, int line) {
            super(sourceName);
            this.line = line;
        }

        @Override
        int hashCodeImpl() {
            return super.hashCodeImpl() * 31 + this.line;
        }

        @Override
        boolean equalsImpl(DeclarationInTextSource obj) {
            return this.line == ((AtLine)obj).line && super.equalsImpl(obj);
        }

        @Override
        public String toString() {
            return super.toString() + ":" + this.line;
        }
    }

    private static class InSource
    extends DeclarationInTextSource {
        InSource(String sourceName) {
            super(sourceName);
        }
    }
}

