/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715;

import com.google.common.base.Verify;
import java.util.regex.Pattern;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IpAddress;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv4Address;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv6Address;

public class IpAddressBuilder {
    private static final Pattern IPV4_PATTERN;

    private IpAddressBuilder() {
    }

    public static IpAddress getDefaultInstance(String defaultValue) {
        return IPV4_PATTERN.matcher(defaultValue).matches() ? new IpAddress(new Ipv4Address(defaultValue)) : new IpAddress(new Ipv6Address(defaultValue));
    }

    static {
        Verify.verify((Ipv4Address.PATTERN_CONSTANTS.size() == 1 ? 1 : 0) != 0);
        IPV4_PATTERN = Pattern.compile(Ipv4Address.PATTERN_CONSTANTS.get(0));
    }
}

