/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.binding.runtime.api;

import com.google.common.annotations.Beta;
import com.google.common.base.MoreObjects;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.mdsal.binding.model.api.Type;
import org.opendaylight.yangtools.concepts.Immutable;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.AugmentationSchemaNode;
import org.opendaylight.yangtools.yang.model.api.DocumentedNode;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContext;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContextProvider;

@Beta
public final class BindingRuntimeTypes
implements EffectiveModelContextProvider,
Immutable {
    private final @NonNull EffectiveModelContext schemaContext;
    private final ImmutableMap<Type, AugmentationSchemaNode> typeToAugmentation;
    private final ImmutableBiMap<Type, DocumentedNode.WithStatus> typeToSchema;
    private final ImmutableMultimap<Type, Type> choiceToCases;
    private final ImmutableMap<QName, Type> identities;

    public BindingRuntimeTypes(EffectiveModelContext schemaContext, Map<Type, AugmentationSchemaNode> typeToAugmentation, BiMap<Type, DocumentedNode.WithStatus> typeToDefiningSchema, Multimap<Type, Type> choiceToCases, Map<QName, Type> identities) {
        this.schemaContext = Objects.requireNonNull(schemaContext);
        this.typeToAugmentation = ImmutableMap.copyOf(typeToAugmentation);
        this.typeToSchema = ImmutableBiMap.copyOf(typeToDefiningSchema);
        this.choiceToCases = ImmutableMultimap.copyOf(choiceToCases);
        this.identities = ImmutableMap.copyOf(identities);
    }

    public EffectiveModelContext getEffectiveModelContext() {
        return this.schemaContext;
    }

    public Optional<AugmentationSchemaNode> findAugmentation(Type type) {
        return Optional.ofNullable((AugmentationSchemaNode)this.typeToAugmentation.get((Object)type));
    }

    public Optional<Type> findIdentity(QName qname) {
        return Optional.ofNullable((Type)this.identities.get((Object)qname));
    }

    public Optional<DocumentedNode.WithStatus> findSchema(Type type) {
        return Optional.ofNullable((DocumentedNode.WithStatus)this.typeToSchema.get((Object)type));
    }

    public Optional<Type> findType(DocumentedNode.WithStatus schema) {
        return Optional.ofNullable((Type)this.typeToSchema.inverse().get((Object)schema));
    }

    public Multimap<Type, Type> getChoiceToCases() {
        return this.choiceToCases;
    }

    public Collection<Type> findCases(Type choiceType) {
        return this.choiceToCases.get((Object)choiceType);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("typeToAugmentation", this.typeToAugmentation).add("typeToSchema", this.typeToSchema).add("choiceToCases", this.choiceToCases).add("identities", this.identities).toString();
    }
}

