/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.xpath.impl;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import com.google.common.collect.Maps;
import java.util.AbstractMap;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.xml.xpath.XPathExpressionException;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.opendaylight.yangtools.yang.common.AbstractQName;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.common.QualifiedQName;
import org.opendaylight.yangtools.yang.common.UnqualifiedQName;
import org.opendaylight.yangtools.yang.common.YangConstants;
import org.opendaylight.yangtools.yang.common.YangNamespaceContext;
import org.opendaylight.yangtools.yang.common.YangVersion;
import org.opendaylight.yangtools.yang.xpath.antlr.xpathLexer;
import org.opendaylight.yangtools.yang.xpath.antlr.xpathParser;
import org.opendaylight.yangtools.yang.xpath.api.YangBinaryOperator;
import org.opendaylight.yangtools.yang.xpath.api.YangBooleanConstantExpr;
import org.opendaylight.yangtools.yang.xpath.api.YangExpr;
import org.opendaylight.yangtools.yang.xpath.api.YangFilterExpr;
import org.opendaylight.yangtools.yang.xpath.api.YangFunction;
import org.opendaylight.yangtools.yang.xpath.api.YangFunctionCallExpr;
import org.opendaylight.yangtools.yang.xpath.api.YangLiteralExpr;
import org.opendaylight.yangtools.yang.xpath.api.YangLocationPath;
import org.opendaylight.yangtools.yang.xpath.api.YangNaryExpr;
import org.opendaylight.yangtools.yang.xpath.api.YangNaryOperator;
import org.opendaylight.yangtools.yang.xpath.api.YangNegateExpr;
import org.opendaylight.yangtools.yang.xpath.api.YangNumberExpr;
import org.opendaylight.yangtools.yang.xpath.api.YangPathExpr;
import org.opendaylight.yangtools.yang.xpath.api.YangVariableReferenceExpr;
import org.opendaylight.yangtools.yang.xpath.api.YangXPathAxis;
import org.opendaylight.yangtools.yang.xpath.api.YangXPathExpression;
import org.opendaylight.yangtools.yang.xpath.api.YangXPathMathMode;
import org.opendaylight.yangtools.yang.xpath.api.YangXPathMathSupport;
import org.opendaylight.yangtools.yang.xpath.api.YangXPathNodeType;
import org.opendaylight.yangtools.yang.xpath.api.YangXPathParser;
import org.opendaylight.yangtools.yang.xpath.impl.AntlrYangXPathExpression;
import org.opendaylight.yangtools.yang.xpath.impl.CapturingErrorListener;
import org.opendaylight.yangtools.yang.xpath.impl.FunctionSupport;
import org.opendaylight.yangtools.yang.xpath.impl.ParseTreeUtils;

abstract class AntlrXPathParser
implements YangXPathParser {
    private static final Map<String, YangBinaryOperator> BINARY_OPERATORS = Maps.uniqueIndex(Arrays.asList(YangBinaryOperator.values()), YangBinaryOperator::toString);
    private static final Map<String, YangXPathNodeType> NODE_TYPES = Maps.uniqueIndex(Arrays.asList(YangXPathNodeType.values()), YangXPathNodeType::toString);
    private static final Map<String, YangXPathAxis> XPATH_AXES = Maps.uniqueIndex(Arrays.asList(YangXPathAxis.values()), YangXPathAxis::toString);
    private static final Map<QName, YangFunction> YANG_FUNCTIONS = Maps.uniqueIndex(Arrays.asList(YangFunction.values()), YangFunction::getIdentifier);
    private static final YangLocationPath.AxisStep SELF_STEP = YangXPathAxis.SELF.asStep();
    final YangXPathMathMode mathMode;
    private final YangXPathMathSupport mathSupport;
    private final FunctionSupport functionSupport;
    private YangVersion minimumYangVersion = YangVersion.VERSION_1;

    AntlrXPathParser(YangXPathMathMode mathMode) {
        this.mathMode = Objects.requireNonNull(mathMode);
        this.mathSupport = mathMode.getSupport();
        this.functionSupport = new FunctionSupport(this.mathSupport);
    }

    abstract QName createQName(String var1);

    abstract QName createQName(String var1, String var2);

    abstract YangLocationPath.QNameStep createStep(YangXPathAxis var1, String var2, List<YangExpr> var3);

    abstract YangLocationPath.QNameStep createStep(YangXPathAxis var1, String var2, String var3, List<YangExpr> var4);

    private YangLocationPath.QNameStep createStep(YangXPathAxis axis, xpathParser.QNameContext expr, List<YangExpr> predicates) {
        switch (expr.getChildCount()) {
            case 1: {
                return this.createStep(axis, ParseTreeUtils.getChild((ParseTree)expr, xpathParser.NCNameContext.class, 0).getText(), predicates);
            }
            case 3: {
                return this.createStep(axis, ParseTreeUtils.getChild((ParseTree)expr, xpathParser.NCNameContext.class, 0).getText(), ParseTreeUtils.getChild((ParseTree)expr, xpathParser.NCNameContext.class, 2).getText(), predicates);
            }
        }
        throw ParseTreeUtils.illegalShape((ParseTree)expr);
    }

    final Map.Entry<YangVersion, YangExpr> parseExpr(String xpath) throws XPathExpressionException {
        YangExpr expr;
        xpathLexer lexer = new xpathLexer((CharStream)CharStreams.fromString((String)xpath));
        xpathParser parser = new xpathParser((TokenStream)new CommonTokenStream((TokenSource)lexer));
        CapturingErrorListener listener = new CapturingErrorListener();
        lexer.removeErrorListeners();
        lexer.addErrorListener((ANTLRErrorListener)listener);
        parser.removeErrorListeners();
        parser.addErrorListener((ANTLRErrorListener)listener);
        xpathParser.ExprContext antlr = parser.main().expr();
        listener.reportError();
        this.minimumYangVersion = YangVersion.VERSION_1;
        try {
            expr = this.parseExpr(antlr);
        }
        catch (RuntimeException e) {
            throw new XPathExpressionException(e);
        }
        return new AbstractMap.SimpleImmutableEntry<YangVersion, YangExpr>(this.minimumYangVersion, expr);
    }

    private YangExpr parseExpr(xpathParser.ExprContext expr) {
        xpathParser.OrExprContext or = expr.orExpr();
        int size = or.getChildCount();
        if (size == 1) {
            return this.parseAnd(ParseTreeUtils.getChild((ParseTree)or, xpathParser.AndExprContext.class, 0));
        }
        ArrayList<YangExpr> tmp = new ArrayList<YangExpr>((size + 1) / 2);
        for (int i = 0; i < size; i += 2) {
            tmp.add(this.parseAnd(ParseTreeUtils.getChild((ParseTree)or, xpathParser.AndExprContext.class, i)));
        }
        return YangNaryOperator.OR.exprWith(tmp);
    }

    private YangExpr parseAdditive(xpathParser.AdditiveExprContext expr) {
        Iterator<ParseTree> it = expr.children.iterator();
        YangExpr first = this.parseMultiplicative(AntlrXPathParser.nextContext(it, xpathParser.MultiplicativeExprContext.class));
        return it.hasNext() ? this.parseAdditiveExpr(first, it) : first;
    }

    private YangExpr parseAnd(xpathParser.AndExprContext expr) {
        int size = expr.getChildCount();
        if (size == 1) {
            return this.parseEquality(ParseTreeUtils.getChild((ParseTree)expr, xpathParser.EqualityExprContext.class, 0));
        }
        ArrayList<YangExpr> tmp = new ArrayList<YangExpr>((size + 1) / 2);
        for (int i = 0; i < size; i += 2) {
            tmp.add(this.parseEquality(ParseTreeUtils.getChild((ParseTree)expr, xpathParser.EqualityExprContext.class, i)));
        }
        return YangNaryOperator.AND.exprWith(tmp);
    }

    private YangExpr parseEquality(xpathParser.EqualityExprContext expr) {
        Iterator<ParseTree> it = expr.children.iterator();
        YangExpr first = this.parseRelational(AntlrXPathParser.nextContext(it, xpathParser.RelationalExprContext.class));
        return it.hasNext() ? this.parseEqualityExpr(first, it) : first;
    }

    private YangExpr parseFilter(xpathParser.FilterExprContext expr) {
        Iterator<ParseTree> it = expr.children.iterator();
        YangExpr first = this.parsePrimary(AntlrXPathParser.nextContext(it, xpathParser.PrimaryExprContext.class));
        return it.hasNext() ? YangFilterExpr.of((YangExpr)first, (Collection)ImmutableList.copyOf((Iterator)Iterators.transform(it, tree -> this.parsePredicate(ParseTreeUtils.verifyTree(xpathParser.PredicateContext.class, tree))))) : first;
    }

    private YangExpr parseFunctionCall(xpathParser.FunctionCallContext expr) {
        QName parsed;
        xpathParser.FunctionNameContext name = ParseTreeUtils.getChild((ParseTree)expr, xpathParser.FunctionNameContext.class, 0);
        switch (name.getChildCount()) {
            case 1: {
                parsed = QName.create((QNameModule)YangConstants.RFC6020_YIN_MODULE, (String)name.getChild(0).getText());
                break;
            }
            case 3: {
                parsed = this.createQName(name.getChild(0).getText(), name.getChild(2).getText());
                break;
            }
            default: {
                throw ParseTreeUtils.illegalShape((ParseTree)name);
            }
        }
        List args = (List)expr.expr().stream().map(this::parseExpr).collect(ImmutableList.toImmutableList());
        YangFunction func = YANG_FUNCTIONS.get(parsed);
        if (func != null) {
            if (this.minimumYangVersion.compareTo((Enum)func.getYangVersion()) < 0) {
                this.minimumYangVersion = func.getYangVersion();
            }
            return this.functionSupport.functionToExpr(func, args);
        }
        Preconditions.checkArgument((!YangConstants.RFC6020_YIN_MODULE.equals((Object)parsed.getModule()) ? 1 : 0) != 0, (String)"Unknown default function %s", (Object)parsed);
        return YangFunctionCallExpr.of((QName)parsed, (List)args);
    }

    private YangLocationPath parseLocationPath(xpathParser.LocationPathContext expr) {
        ParseTreeUtils.verifyChildCount((ParseTree)expr, 1);
        ParseTree first = expr.getChild(0);
        if (first instanceof xpathParser.RelativeLocationPathContext) {
            return YangLocationPath.relative(this.parseLocationPathSteps((xpathParser.RelativeLocationPathContext)first));
        }
        xpathParser.AbsoluteLocationPathNorootContext abs = ParseTreeUtils.verifyTree(xpathParser.AbsoluteLocationPathNorootContext.class, first);
        ParseTreeUtils.verifyChildCount((ParseTree)abs, 2);
        Deque<YangLocationPath.Step> steps = this.parseLocationPathSteps(ParseTreeUtils.getChild((ParseTree)abs, xpathParser.RelativeLocationPathContext.class, 1));
        AntlrXPathParser.parseStepShorthand(abs.getChild(0)).ifPresent(steps::addFirst);
        return YangLocationPath.absolute(steps);
    }

    private YangExpr parseMultiplicative(xpathParser.MultiplicativeExprContext expr) {
        ParseTree first = expr.getChild(0);
        Object left = first instanceof xpathParser.UnaryExprNoRootContext ? this.parseUnary((xpathParser.UnaryExprNoRootContext)first) : YangLocationPath.root();
        if (expr.getChildCount() == 1) {
            return left;
        }
        ParseTreeUtils.verifyChildCount((ParseTree)expr, 3);
        YangBinaryOperator operator = AntlrXPathParser.parseOperator(expr.getChild(1));
        YangExpr right = this.parseMultiplicative(ParseTreeUtils.getChild((ParseTree)expr, xpathParser.MultiplicativeExprContext.class, 2));
        Optional<YangExpr> simple = this.simplifyNumbers(operator, (YangExpr)left, right);
        return simple.isPresent() ? simple.get() : operator.exprWith((YangExpr)left, right);
    }

    private YangExpr parsePathExpr(xpathParser.PathExprNoRootContext expr) {
        ParseTree first = expr.getChild(0);
        if (first instanceof xpathParser.LocationPathContext) {
            return this.parseLocationPath((xpathParser.LocationPathContext)first);
        }
        YangExpr filter = this.parseFilter(ParseTreeUtils.verifyTree(xpathParser.FilterExprContext.class, first));
        if (expr.getChildCount() == 1) {
            return filter;
        }
        ParseTreeUtils.verifyChildCount((ParseTree)expr, 3);
        Deque<YangLocationPath.Step> steps = this.parseLocationPathSteps(ParseTreeUtils.getChild((ParseTree)expr, xpathParser.RelativeLocationPathContext.class, 2));
        AntlrXPathParser.parseStepShorthand(expr.getChild(1)).ifPresent(steps::addFirst);
        return YangPathExpr.of((YangExpr)filter, (YangLocationPath.Relative)YangLocationPath.relative(steps));
    }

    private YangExpr parsePredicate(xpathParser.PredicateContext expr) {
        ParseTreeUtils.verifyChildCount((ParseTree)expr, 3);
        return this.parseExpr(ParseTreeUtils.getChild((ParseTree)expr, xpathParser.ExprContext.class, 1));
    }

    private YangExpr parsePrimary(xpathParser.PrimaryExprContext expr) {
        if (expr.getChildCount() == 3) {
            return this.parseExpr(ParseTreeUtils.getChild((ParseTree)expr, xpathParser.ExprContext.class, 1));
        }
        ParseTreeUtils.verifyChildCount((ParseTree)expr, 1);
        ParseTree first = expr.getChild(0);
        if (first instanceof TerminalNode) {
            return this.parseTerminal((TerminalNode)first);
        }
        if (first instanceof xpathParser.FunctionCallContext) {
            return this.parseFunctionCall((xpathParser.FunctionCallContext)first);
        }
        if (first instanceof xpathParser.VariableReferenceContext) {
            return YangVariableReferenceExpr.of((QName)this.parseQName(((xpathParser.VariableReferenceContext)first).qName()));
        }
        throw ParseTreeUtils.illegalShape(first);
    }

    private YangExpr parseRelational(xpathParser.RelationalExprContext expr) {
        Iterator<ParseTree> it = expr.children.iterator();
        YangExpr first = this.parseAdditive(AntlrXPathParser.nextContext(it, xpathParser.AdditiveExprContext.class));
        return it.hasNext() ? this.parseRelationalExpr(first, it) : first;
    }

    private Deque<YangLocationPath.Step> parseLocationPathSteps(xpathParser.RelativeLocationPathContext expr) {
        ArrayDeque<YangLocationPath.Step> steps = new ArrayDeque<YangLocationPath.Step>(expr.getChildCount());
        Iterator<ParseTree> it = expr.children.iterator();
        AntlrXPathParser.addNotSelfStep(steps, this.parseStep(AntlrXPathParser.nextContext(it, xpathParser.StepContext.class)));
        while (it.hasNext()) {
            AntlrXPathParser.parseStepShorthand(it.next()).ifPresent(steps::add);
            AntlrXPathParser.addNotSelfStep(steps, this.parseStep(AntlrXPathParser.nextContext(it, xpathParser.StepContext.class)));
        }
        return steps;
    }

    private static void addNotSelfStep(Deque<YangLocationPath.Step> steps, YangLocationPath.Step step) {
        if (!SELF_STEP.equals((Object)step)) {
            steps.add(step);
        }
    }

    private YangExpr parseTerminal(TerminalNode term) {
        String text = term.getText();
        switch (term.getSymbol().getType()) {
            case 34: {
                return YangLiteralExpr.of((String)text.substring(1, text.length() - 1));
            }
            case 10: {
                return this.mathSupport.createNumber(text);
            }
        }
        throw ParseTreeUtils.illegalShape((ParseTree)term);
    }

    private YangExpr parseUnary(xpathParser.UnaryExprNoRootContext expr) {
        int size = ParseTreeUtils.verifyAtLeastChildren((ParseTree)expr, 1);
        YangExpr ret = this.parseUnion(ParseTreeUtils.getChild((ParseTree)expr, xpathParser.UnionExprNoRootContext.class, size - 1));
        if (size % 2 != 0) {
            return ret;
        }
        return ret instanceof YangNumberExpr ? this.mathSupport.negateNumber((YangNumberExpr)ret) : YangNegateExpr.of((YangExpr)ret);
    }

    private YangExpr parseUnion(xpathParser.UnionExprNoRootContext expr) {
        YangLocationPath.Absolute path;
        ParseTree first = expr.getChild(0);
        if (first instanceof xpathParser.PathExprNoRootContext) {
            path = this.parsePathExpr((xpathParser.PathExprNoRootContext)first);
            if (expr.getChildCount() == 1) {
                return path;
            }
        } else {
            path = YangLocationPath.root();
        }
        ParseTreeUtils.verifyChildCount((ParseTree)expr, 3);
        YangExpr union = this.parseUnion(ParseTreeUtils.getChild((ParseTree)expr, xpathParser.UnionExprNoRootContext.class, 2));
        LinkedHashSet<Object> expressions = new LinkedHashSet<Object>();
        expressions.add(path);
        if (union instanceof YangNaryExpr) {
            YangNaryExpr nary = (YangNaryExpr)union;
            if (nary.getOperator() == YangNaryOperator.UNION) {
                expressions.addAll(nary.getExpressions());
            } else {
                expressions.add(union);
            }
        } else {
            expressions.add(union);
        }
        return YangNaryOperator.UNION.exprWith(expressions);
    }

    private YangExpr parseAdditiveExpr(YangExpr left, Iterator<ParseTree> it) {
        YangExpr ret = left;
        do {
            YangExpr right;
            YangBinaryOperator operator;
            Optional<YangExpr> simple;
            Object object = ret = (simple = this.simplifyNumbers(operator = AntlrXPathParser.nextOperator(it), ret, right = this.parseMultiplicative(AntlrXPathParser.nextContext(it, xpathParser.MultiplicativeExprContext.class)))).isPresent() ? simple.get() : operator.exprWith(ret, right);
        } while (it.hasNext());
        return ret;
    }

    private Optional<YangExpr> simplifyNumbers(YangBinaryOperator operator, YangExpr left, YangExpr right) {
        if (left instanceof YangNumberExpr && right instanceof YangNumberExpr) {
            return this.mathSupport.tryEvaluate(operator, (YangNumberExpr)left, (YangNumberExpr)right);
        }
        return Optional.empty();
    }

    private YangExpr parseEqualityExpr(YangExpr left, Iterator<ParseTree> it) {
        YangExpr ret = left;
        do {
            Optional<YangExpr> simple;
            YangBinaryOperator operator = AntlrXPathParser.nextOperator(it);
            YangExpr right = this.parseRelational(AntlrXPathParser.nextContext(it, xpathParser.RelationalExprContext.class));
            if (left.equals(right)) {
                switch (operator) {
                    case EQUALS: {
                        return YangBooleanConstantExpr.TRUE;
                    }
                    case NOT_EQUALS: {
                        return YangBooleanConstantExpr.FALSE;
                    }
                }
            }
            Object object = ret = (simple = this.simplifyNumbers(operator, ret, right)).isPresent() ? simple.get() : operator.exprWith(ret, right);
        } while (it.hasNext());
        return ret;
    }

    private YangExpr parseRelationalExpr(YangExpr left, Iterator<ParseTree> it) {
        YangExpr ret = left;
        do {
            YangExpr right;
            YangBinaryOperator operator;
            Optional<YangExpr> simple;
            Object object = ret = (simple = this.simplifyNumbers(operator = AntlrXPathParser.nextOperator(it), ret, right = this.parseAdditive(AntlrXPathParser.nextContext(it, xpathParser.AdditiveExprContext.class)))).isPresent() ? simple.get() : operator.exprWith(ret, right);
        } while (it.hasNext());
        return ret;
    }

    private YangLocationPath.Step parseStep(xpathParser.StepContext expr) {
        if (expr.getChildCount() == 1) {
            xpathParser.AbbreviatedStepContext abbrev = ParseTreeUtils.getChild((ParseTree)expr, xpathParser.AbbreviatedStepContext.class, 0);
            ParseTreeUtils.verifyChildCount((ParseTree)abbrev, 1);
            switch (AntlrXPathParser.getTerminalType((ParseTree)abbrev, 0)) {
                case 20: {
                    return YangXPathAxis.SELF.asStep();
                }
                case 22: {
                    return YangXPathAxis.PARENT.asStep();
                }
            }
            throw ParseTreeUtils.illegalShape((ParseTree)abbrev);
        }
        int size = ParseTreeUtils.verifyAtLeastChildren((ParseTree)expr, 2);
        ArrayList<YangExpr> predicates = new ArrayList<YangExpr>(size - 2);
        for (int i = 2; i < size; ++i) {
            predicates.add(this.parsePredicate(ParseTreeUtils.getChild((ParseTree)expr, xpathParser.PredicateContext.class, i)));
        }
        YangXPathAxis axis = AntlrXPathParser.parseAxis(ParseTreeUtils.getChild((ParseTree)expr, xpathParser.AxisSpecifierContext.class, 0));
        xpathParser.NodeTestContext nodeTest = ParseTreeUtils.getChild((ParseTree)expr, xpathParser.NodeTestContext.class, 1);
        switch (nodeTest.getChildCount()) {
            case 1: {
                xpathParser.NameTestContext nameChild = ParseTreeUtils.getChild((ParseTree)nodeTest, xpathParser.NameTestContext.class, 0);
                ParseTree first = nameChild.getChild(0);
                if (first instanceof TerminalNode) {
                    Verify.verify((((TerminalNode)first).getSymbol().getType() == 21 ? 1 : 0) != 0);
                    return axis.asStep(predicates);
                }
                return this.createStep(axis, ParseTreeUtils.verifyTree(xpathParser.QNameContext.class, first), predicates);
            }
            case 3: {
                return axis.asStep(AntlrXPathParser.parseNodeType(nodeTest.getChild(0)), predicates);
            }
            case 4: {
                String text = ParseTreeUtils.verifyToken((ParseTree)nodeTest, 2, 34).getText();
                return axis.asStep(text.substring(1, text.length() - 1), predicates);
            }
        }
        throw ParseTreeUtils.illegalShape((ParseTree)nodeTest);
    }

    private static YangXPathAxis parseAxis(xpathParser.AxisSpecifierContext expr) {
        switch (expr.getChildCount()) {
            case 0: {
                return YangXPathAxis.CHILD;
            }
            case 1: {
                Verify.verify((AntlrXPathParser.getTerminalType((ParseTree)expr, 0) == 23 ? 1 : 0) != 0, (String)"Unhandled axis specifier shape %s", (Object)expr);
                return YangXPathAxis.ATTRIBUTE;
            }
            case 2: {
                String str = ParseTreeUtils.verifyTerminal(expr.getChild(0)).getText();
                return (YangXPathAxis)Verify.verifyNotNull((Object)XPATH_AXES.get(str), (String)"Unhandled axis %s", (Object[])new Object[]{str});
            }
        }
        throw ParseTreeUtils.illegalShape((ParseTree)expr);
    }

    private QName parseQName(xpathParser.QNameContext expr) {
        switch (expr.getChildCount()) {
            case 1: {
                return this.createQName(ParseTreeUtils.getChild((ParseTree)expr, xpathParser.NCNameContext.class, 0).getText());
            }
            case 3: {
                return this.createQName(ParseTreeUtils.getChild((ParseTree)expr, xpathParser.NCNameContext.class, 0).getText(), ParseTreeUtils.getChild((ParseTree)expr, xpathParser.NCNameContext.class, 2).getText());
            }
        }
        throw ParseTreeUtils.illegalShape((ParseTree)expr);
    }

    private static <T extends ParserRuleContext> T nextContext(Iterator<ParseTree> it, Class<T> type) {
        return (T)((ParserRuleContext)ParseTreeUtils.verifyTree(type, it.next()));
    }

    private static YangBinaryOperator nextOperator(Iterator<ParseTree> it) {
        return AntlrXPathParser.parseOperator(it.next());
    }

    private static int getTerminalType(ParseTree parent, int offset) {
        return ParseTreeUtils.verifyTerminal(parent.getChild(offset)).getSymbol().getType();
    }

    private static YangXPathNodeType parseNodeType(ParseTree tree) {
        String str = ParseTreeUtils.verifyTerminal(tree).getText();
        return (YangXPathNodeType)Verify.verifyNotNull((Object)NODE_TYPES.get(str), (String)"Unhandled node type %s", (Object[])new Object[]{str});
    }

    private static YangBinaryOperator parseOperator(ParseTree tree) {
        String str = ParseTreeUtils.verifyTerminal(tree).getText();
        return (YangBinaryOperator)Verify.verifyNotNull((Object)BINARY_OPERATORS.get(str), (String)"Unhandled operator %s", (Object[])new Object[]{str});
    }

    private static Optional<YangLocationPath.Step> parseStepShorthand(ParseTree tree) {
        switch (ParseTreeUtils.verifyTerminal(tree).getSymbol().getType()) {
            case 12: {
                return Optional.empty();
            }
            case 13: {
                return Optional.of(YangXPathAxis.DESCENDANT_OR_SELF.asStep());
            }
        }
        throw ParseTreeUtils.illegalShape(tree);
    }

    static final class Unqualified
    extends Qualified
    implements YangXPathParser.UnqualifiedBound {
        private final QNameModule defaultNamespace;

        Unqualified(YangXPathMathMode mathMode, YangNamespaceContext namespaceContext, QNameModule defaultNamespace) {
            super(mathMode, namespaceContext);
            this.defaultNamespace = Objects.requireNonNull(defaultNamespace);
        }

        public YangXPathExpression.UnqualifiedBound parseExpression(String xpath) throws XPathExpressionException {
            Map.Entry<YangVersion, YangExpr> result = this.parseExpr(xpath);
            return new AntlrYangXPathExpression.Unqualified(this.mathMode, result.getKey(), result.getValue(), xpath, this.namespaceContext, this.defaultNamespace);
        }

        @Override
        QName createQName(String localName) {
            return QName.create((QNameModule)this.defaultNamespace, (String)localName);
        }

        YangLocationPath.ResolvedQNameStep createStep(YangXPathAxis axis, String localName, List<YangExpr> predicates) {
            return axis.asStep(QName.create((QNameModule)this.defaultNamespace, (String)localName), predicates);
        }
    }

    static class Qualified
    extends Base
    implements YangXPathParser.QualifiedBound {
        final YangNamespaceContext namespaceContext;

        Qualified(YangXPathMathMode mathMode, YangNamespaceContext namespaceContext) {
            super(mathMode);
            this.namespaceContext = Objects.requireNonNull(namespaceContext);
        }

        public YangXPathExpression.QualifiedBound parseExpression(String xpath) throws XPathExpressionException {
            Map.Entry<YangVersion, YangExpr> result = this.parseExpr(xpath);
            return new AntlrYangXPathExpression.Qualified(this.mathMode, result.getKey(), result.getValue(), xpath, this.namespaceContext);
        }

        @Override
        final QName createQName(String prefix, String localName) {
            return this.namespaceContext.createQName(prefix, localName);
        }

        YangLocationPath.ResolvedQNameStep createStep(YangXPathAxis axis, String prefix, String localName, List<YangExpr> predicates) {
            return axis.asStep(this.createQName(prefix, localName), predicates);
        }
    }

    static class Base
    extends AntlrXPathParser {
        Base(YangXPathMathMode mathMode) {
            super(mathMode);
        }

        public YangXPathExpression parseExpression(String xpath) throws XPathExpressionException {
            Map.Entry<YangVersion, YangExpr> result = this.parseExpr(xpath);
            return new AntlrYangXPathExpression.Base(this.mathMode, result.getKey(), result.getValue(), xpath);
        }

        @Override
        YangLocationPath.QNameStep createStep(YangXPathAxis axis, String localName, List<YangExpr> predicates) {
            return axis.asStep((AbstractQName)UnqualifiedQName.of((String)localName).intern(), predicates);
        }

        @Override
        YangLocationPath.QNameStep createStep(YangXPathAxis axis, String prefix, String localName, List<YangExpr> predicates) {
            return axis.asStep((AbstractQName)QualifiedQName.of((String)prefix, (String)localName).intern(), predicates);
        }

        @Override
        QName createQName(String localName) {
            throw new UnsupportedOperationException();
        }

        @Override
        QName createQName(String prefix, String localName) {
            throw new UnsupportedOperationException();
        }
    }
}

