/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021;

import com.google.common.base.MoreObjects;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.NetworkTopology;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.Topology;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.TopologyKey;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class NetworkTopologyBuilder
implements Builder<NetworkTopology> {
    private Map<TopologyKey, Topology> _topology;
    Map<Class<? extends Augmentation<NetworkTopology>>, Augmentation<NetworkTopology>> augmentation = Collections.emptyMap();

    public NetworkTopologyBuilder() {
    }

    public NetworkTopologyBuilder(NetworkTopology base) {
        Map aug;
        if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<NetworkTopology>>, Augmentation<NetworkTopology>>(aug);
        }
        this._topology = base.getTopology();
    }

    public Map<TopologyKey, Topology> getTopology() {
        return this._topology;
    }

    public <E$$ extends Augmentation<NetworkTopology>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public NetworkTopologyBuilder setTopology(Map<TopologyKey, Topology> values) {
        this._topology = values;
        return this;
    }

    @Deprecated(forRemoval=true)
    public NetworkTopologyBuilder setTopology(List<Topology> values) {
        return this.setTopology(CodeHelpers.compatMap(values));
    }

    public NetworkTopologyBuilder addAugmentation(Augmentation<NetworkTopology> augmentation) {
        return this.doAddAugmentation(augmentation.implementedInterface(), augmentation);
    }

    @Deprecated(forRemoval=true)
    public NetworkTopologyBuilder addAugmentation(Class<? extends Augmentation<NetworkTopology>> augmentationType, Augmentation<NetworkTopology> augmentationValue) {
        return augmentationValue == null ? this.removeAugmentation(augmentationType) : this.doAddAugmentation(augmentationType, augmentationValue);
    }

    public NetworkTopologyBuilder removeAugmentation(Class<? extends Augmentation<NetworkTopology>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    private NetworkTopologyBuilder doAddAugmentation(Class<? extends Augmentation<NetworkTopology>> augmentationType, Augmentation<NetworkTopology> augmentationValue) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<NetworkTopology>>, Augmentation<NetworkTopology>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public NetworkTopology build() {
        return new NetworkTopologyImpl(this);
    }

    private static final class NetworkTopologyImpl
    extends AbstractAugmentable<NetworkTopology>
    implements NetworkTopology {
        private final Map<TopologyKey, Topology> _topology;
        private int hash = 0;
        private volatile boolean hashValid = false;

        NetworkTopologyImpl(NetworkTopologyBuilder base) {
            super(base.augmentation);
            this._topology = CodeHelpers.emptyToNull(base.getTopology());
        }

        @Override
        public Map<TopologyKey, Topology> getTopology() {
            return this._topology;
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._topology);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentations());
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!NetworkTopology.class.equals((Object)((DataObject)obj).implementedInterface())) {
                return false;
            }
            NetworkTopology other = (NetworkTopology)obj;
            if (!Objects.equals(this._topology, other.getTopology())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                NetworkTopologyImpl otherImpl = (NetworkTopologyImpl)obj;
                if (!Objects.equals(this.augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                for (Map.Entry e : this.augmentations().entrySet()) {
                    if (((Augmentation)e.getValue()).equals(other.augmentation((Class)e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"NetworkTopology");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_topology", this._topology);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", (Object)this.augmentations().values());
            return helper.toString();
        }
    }
}

