/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.runtime.osgi.impl;

import com.google.common.annotations.Beta;
import com.google.common.base.Verify;
import java.util.Collections;
import java.util.Comparator;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.checkerframework.checker.lock.qual.GuardedBy;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.binding.runtime.api.BindingRuntimeContext;
import org.opendaylight.binding.runtime.api.BindingRuntimeGenerator;
import org.opendaylight.binding.runtime.api.BindingRuntimeTypes;
import org.opendaylight.binding.runtime.api.ClassLoadingStrategy;
import org.opendaylight.binding.runtime.api.DefaultBindingRuntimeContext;
import org.opendaylight.binding.runtime.api.ModuleInfoSnapshot;
import org.opendaylight.mdsal.binding.runtime.osgi.impl.OSGiBindingRuntimeContextImpl;
import org.opendaylight.mdsal.dom.schema.osgi.ModelGenerationAware;
import org.opendaylight.mdsal.dom.schema.osgi.OSGiModuleInfoSnapshot;
import org.osgi.service.component.ComponentFactory;
import org.osgi.service.component.ComponentInstance;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
@Component(immediate=true)
public final class OSGiBindingRuntime {
    private static final Logger LOG = LoggerFactory.getLogger(OSGiBindingRuntime.class);
    @Reference
    BindingRuntimeGenerator generator = null;
    @Reference(target="(component.factory=org.opendaylight.mdsal.binding.runtime.osgi.impl.OSGiBindingRuntimeContextImpl)")
    ComponentFactory contextFactory = null;
    private @GuardedBy(value={"this"}) AbstractInstances instances = new InactiveInstances();

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    synchronized void addModuleInfoSnapshot(OSGiModuleInfoSnapshot snapshot) {
        this.instances.add(snapshot);
    }

    synchronized void removeModuleInfoSnapshot(OSGiModuleInfoSnapshot snapshot) {
        this.instances.remove(snapshot);
    }

    @Activate
    synchronized void activate() {
        LOG.info("Binding Runtime activating");
        this.instances = this.instances.toActive(this.generator, this.contextFactory);
        LOG.info("Binding Runtime activated");
    }

    @Deactivate
    synchronized void deactivate() {
        LOG.info("Binding Runtime deactivating");
        this.instances = this.instances.toInactive();
        LOG.info("Binding Runtime deactivated");
    }

    private static final class ActiveInstances
    extends AbstractInstances {
        private final Map<OSGiModuleInfoSnapshot, ComponentInstance> instances = new IdentityHashMap<OSGiModuleInfoSnapshot, ComponentInstance>();
        private final BindingRuntimeGenerator generator;
        private final ComponentFactory factory;

        ActiveInstances(BindingRuntimeGenerator generator, ComponentFactory factory) {
            this.generator = Objects.requireNonNull(generator);
            this.factory = Objects.requireNonNull(factory);
        }

        @Override
        void add(OSGiModuleInfoSnapshot snapshot) {
            ModuleInfoSnapshot context = (ModuleInfoSnapshot)snapshot.getService();
            BindingRuntimeTypes types = this.generator.generateTypeMapping(context.getEffectiveModelContext());
            this.instances.put(snapshot, this.factory.newInstance(OSGiBindingRuntimeContextImpl.props(snapshot.getGeneration(), snapshot.getServiceRanking(), (BindingRuntimeContext)DefaultBindingRuntimeContext.create((BindingRuntimeTypes)types, (ClassLoadingStrategy)context))));
        }

        @Override
        void remove(OSGiModuleInfoSnapshot snapshot) {
            ComponentInstance instance = this.instances.remove(snapshot);
            if (instance != null) {
                instance.dispose();
            } else {
                LOG.warn("Instance for generation {} not found", (Object)snapshot.getGeneration());
            }
        }

        @Override
        AbstractInstances toActive(BindingRuntimeGenerator ignoreGenerator, ComponentFactory ignoreFactory) {
            throw new IllegalStateException("Attempted to activate active instances");
        }

        @Override
        AbstractInstances toInactive() {
            this.instances.values().forEach(ComponentInstance::dispose);
            return new InactiveInstances(this.instances.keySet());
        }
    }

    private static final class InactiveInstances
    extends AbstractInstances {
        private final Set<OSGiModuleInfoSnapshot> instances = Collections.newSetFromMap(new IdentityHashMap());

        InactiveInstances() {
        }

        InactiveInstances(Set<OSGiModuleInfoSnapshot> keySet) {
            this.instances.addAll(keySet);
        }

        @Override
        void add(OSGiModuleInfoSnapshot snapshot) {
            Verify.verify((boolean)this.instances.add(snapshot), (String)"Duplicate instance %s?!", (Object)snapshot);
        }

        @Override
        void remove(OSGiModuleInfoSnapshot snapshot) {
            this.instances.remove(snapshot);
        }

        @Override
        AbstractInstances toActive(BindingRuntimeGenerator generator, ComponentFactory factory) {
            ActiveInstances active = new ActiveInstances(generator, factory);
            this.instances.stream().sorted(Comparator.comparing(ModelGenerationAware::getGeneration).reversed()).forEach(active::add);
            return active;
        }

        @Override
        AbstractInstances toInactive() {
            throw new IllegalStateException("Attempted to deactivate inactive instances");
        }
    }

    private static abstract class AbstractInstances {
        private AbstractInstances() {
        }

        abstract void add(OSGiModuleInfoSnapshot var1);

        abstract void remove(OSGiModuleInfoSnapshot var1);

        abstract @NonNull AbstractInstances toActive(BindingRuntimeGenerator var1, ComponentFactory var2);

        abstract @NonNull AbstractInstances toInactive();
    }
}

