/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.codec.impl;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Objects;
import org.opendaylight.mdsal.binding.dom.codec.jar.bytebuddy.asm.AsmVisitorWrapper;
import org.opendaylight.mdsal.binding.dom.codec.jar.bytebuddy.description.field.FieldDescription;
import org.opendaylight.mdsal.binding.dom.codec.jar.bytebuddy.description.field.FieldList;
import org.opendaylight.mdsal.binding.dom.codec.jar.bytebuddy.description.method.MethodDescription;
import org.opendaylight.mdsal.binding.dom.codec.jar.bytebuddy.description.method.MethodList;
import org.opendaylight.mdsal.binding.dom.codec.jar.bytebuddy.description.type.TypeDescription;
import org.opendaylight.mdsal.binding.dom.codec.jar.bytebuddy.implementation.Implementation;
import org.opendaylight.mdsal.binding.dom.codec.jar.bytebuddy.implementation.bytecode.StackManipulation;
import org.opendaylight.mdsal.binding.dom.codec.jar.bytebuddy.implementation.bytecode.member.FieldAccess;
import org.opendaylight.mdsal.binding.dom.codec.jar.bytebuddy.implementation.bytecode.member.MethodInvocation;
import org.opendaylight.mdsal.binding.dom.codec.jar.bytebuddy.implementation.bytecode.member.MethodVariableAccess;
import org.opendaylight.mdsal.binding.dom.codec.jar.bytebuddy.jar.asm.ClassVisitor;
import org.opendaylight.mdsal.binding.dom.codec.jar.bytebuddy.jar.asm.Label;
import org.opendaylight.mdsal.binding.dom.codec.jar.bytebuddy.jar.asm.MethodVisitor;
import org.opendaylight.mdsal.binding.dom.codec.jar.bytebuddy.matcher.ElementMatchers;
import org.opendaylight.mdsal.binding.dom.codec.jar.bytebuddy.pool.TypePool;

final class ByteBuddyUtils {
    static final StackManipulation THIS = MethodVariableAccess.loadThis();

    private ByteBuddyUtils() {
    }

    static StackManipulation invokeMethod(Method method) {
        return MethodInvocation.invoke(ByteBuddyUtils.describe(method));
    }

    static StackManipulation invokeMethod(Class<?> clazz, String name, Class<?> ... args) {
        return MethodInvocation.invoke(ByteBuddyUtils.describe(clazz, name, args));
    }

    static AsmVisitorWrapper computeFrames() {
        return ComputeFrames.INSTANCE;
    }

    static StackManipulation ifEq(Label label) {
        return new IfEq(label);
    }

    static StackManipulation markLabel(Label label) {
        return new Mark(label);
    }

    static StackManipulation loadThis() {
        return THIS;
    }

    static StackManipulation getField(Field field) {
        return FieldAccess.forField(new FieldDescription.ForLoadedField(field).asDefined()).read();
    }

    static StackManipulation getField(TypeDescription instrumentedType, String fieldName) {
        return ByteBuddyUtils.fieldAccess(instrumentedType, fieldName).read();
    }

    static StackManipulation putField(TypeDescription instrumentedType, String fieldName) {
        return ByteBuddyUtils.fieldAccess(instrumentedType, fieldName).write();
    }

    private static MethodDescription.ForLoadedMethod describe(Method method) {
        return new MethodDescription.ForLoadedMethod(method);
    }

    private static MethodDescription.ForLoadedMethod describe(Class<?> clazz, String name, Class<?> ... args) {
        return ByteBuddyUtils.describe(ByteBuddyUtils.getMethod(clazz, name, args));
    }

    private static FieldAccess.Defined fieldAccess(TypeDescription instrumentedType, String fieldName) {
        return FieldAccess.forField((FieldDescription.InDefinedShape)((FieldList)instrumentedType.getDeclaredFields().filter(ElementMatchers.named(fieldName))).getOnly());
    }

    private static Method getMethod(Class<?> clazz, String name, Class<?> ... args) {
        try {
            return clazz.getDeclaredMethod(name, args);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException(e);
        }
    }

    private static final class Mark
    implements StackManipulation {
        private static final StackManipulation.Size SIZE = new StackManipulation.Size(0, 0);
        private final Label label;

        Mark(Label label) {
            this.label = Objects.requireNonNull(label);
        }

        @Override
        public boolean isValid() {
            return true;
        }

        @Override
        public StackManipulation.Size apply(MethodVisitor mv, Implementation.Context ctx) {
            mv.visitLabel(this.label);
            return SIZE;
        }
    }

    private static final class IfEq
    implements StackManipulation {
        private static final StackManipulation.Size SIZE = new StackManipulation.Size(-1, 0);
        private final Label label;

        IfEq(Label label) {
            this.label = Objects.requireNonNull(label);
        }

        @Override
        public boolean isValid() {
            return true;
        }

        @Override
        public StackManipulation.Size apply(MethodVisitor mv, Implementation.Context ctx) {
            mv.visitJumpInsn(153, this.label);
            return SIZE;
        }
    }

    private static enum ComputeFrames implements AsmVisitorWrapper
    {
        INSTANCE;


        @Override
        public int mergeWriter(int flags) {
            return flags | 2;
        }

        @Override
        public int mergeReader(int flags) {
            return flags | 2;
        }

        @Override
        public ClassVisitor wrap(TypeDescription td, ClassVisitor cv, Implementation.Context ctx, TypePool tp, FieldList<FieldDescription.InDefinedShape> fields, MethodList<?> methods, int wflags, int rflags) {
            return cv;
        }
    }
}

