/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.codec.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.mdsal.binding.dom.codec.impl.DataContainerCodecContext;
import org.opendaylight.mdsal.binding.dom.codec.impl.DataContainerCodecPrototype;
import org.opendaylight.mdsal.binding.dom.codec.impl.NodeCodecContext;
import org.opendaylight.mdsal.binding.spec.reflect.BindingReflections;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.ChoiceNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.impl.schema.SchemaUtils;
import org.opendaylight.yangtools.yang.data.util.DataSchemaContextNode;
import org.opendaylight.yangtools.yang.model.api.AugmentationSchemaNode;
import org.opendaylight.yangtools.yang.model.api.CaseSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ChoiceSchemaNode;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ChoiceNodeCodecContext<D extends DataObject>
extends DataContainerCodecContext<D, ChoiceSchemaNode> {
    private static final Logger LOG = LoggerFactory.getLogger(ChoiceNodeCodecContext.class);
    private final ImmutableMap<YangInstanceIdentifier.PathArgument, DataContainerCodecPrototype<?>> byYangCaseChild;
    private final ImmutableMap<Class<?>, DataContainerCodecPrototype<?>> byClass;
    private final ImmutableMap<Class<?>, DataContainerCodecPrototype<?>> byCaseChildClass;
    private final ImmutableListMultimap<Class<?>, DataContainerCodecPrototype<?>> ambiguousByCaseChildClass;
    private final Set<Class<?>> ambiguousByCaseChildWarnings;

    ChoiceNodeCodecContext(DataContainerCodecPrototype<ChoiceSchemaNode> prototype) {
        super(prototype);
        HashMap<Object, Object> byYangCaseChildBuilder = new HashMap<Object, Object>();
        HashMap<Class<Object>, Object> byClassBuilder = new HashMap<Class<Object>, Object>();
        SetMultimap childToCase = MultimapBuilder.SetMultimapBuilder.hashKeys().hashSetValues().build();
        HashSet<Class> potentialSubstitutions = new HashSet<Class>();
        for (Class caze : this.factory().getRuntimeContext().getCases(this.getBindingClass())) {
            DataContainerCodecPrototype<CaseSchemaNode> cazeDef = this.loadCase(caze);
            if (cazeDef != null) {
                byClassBuilder.put(cazeDef.getBindingClass(), cazeDef);
                Class clazz = caze;
                for (Class cazeChild : BindingReflections.getChildrenClasses((Class)clazz)) {
                    childToCase.put((Object)cazeChild, (Object)cazeDef);
                }
                for (Class cazeChild : ((CaseSchemaNode)cazeDef.getSchema()).getChildNodes()) {
                    AugmentationSchemaNode augment;
                    if (cazeChild.isAugmenting() && (augment = SchemaUtils.findCorrespondingAugment((DataSchemaNode)((DataSchemaNode)cazeDef.getSchema()), (DataSchemaNode)cazeChild)) != null) {
                        byYangCaseChildBuilder.put(DataSchemaContextNode.augmentationIdentifierFrom((AugmentationSchemaNode)augment), cazeDef);
                        continue;
                    }
                    byYangCaseChildBuilder.put(YangInstanceIdentifier.NodeIdentifier.create((QName)cazeChild.getQName()), cazeDef);
                }
                continue;
            }
            potentialSubstitutions.add(caze);
        }
        this.byYangCaseChild = ImmutableMap.copyOf(byYangCaseChildBuilder);
        ImmutableListMultimap.Builder ambiguousByCaseBuilder = ImmutableListMultimap.builder();
        ImmutableMap.Builder unambiguousByCaseBuilder = ImmutableMap.builder();
        for (Map.Entry entry : Multimaps.asMap((SetMultimap)childToCase).entrySet()) {
            Set cases = (Set)entry.getValue();
            if (cases.size() != 1) {
                ArrayList<DataContainerCodecPrototype> list = new ArrayList<DataContainerCodecPrototype>((Collection)entry.getValue());
                list.sort(Comparator.comparing(proto -> proto.getBindingClass().getCanonicalName()));
                ambiguousByCaseBuilder.putAll((Object)((Class)entry.getKey()), list);
                continue;
            }
            unambiguousByCaseBuilder.put((Object)((Class)entry.getKey()), (Object)((DataContainerCodecPrototype)cases.iterator().next()));
        }
        this.byCaseChildClass = unambiguousByCaseBuilder.build();
        this.ambiguousByCaseChildClass = ambiguousByCaseBuilder.build();
        this.ambiguousByCaseChildWarnings = this.ambiguousByCaseChildClass.isEmpty() ? ImmutableSet.of() : ConcurrentHashMap.newKeySet();
        HashMap<Class, DataContainerCodecPrototype> bySubstitutionBuilder = new HashMap<Class, DataContainerCodecPrototype>();
        block4: for (Class substitution : potentialSubstitutions) {
            for (Map.Entry real : byClassBuilder.entrySet()) {
                if (!BindingReflections.isSubstitutionFor((Class)substitution, (Class)((Class)real.getKey()))) continue;
                bySubstitutionBuilder.put(substitution, (DataContainerCodecPrototype)real.getValue());
                continue block4;
            }
        }
        byClassBuilder.putAll(bySubstitutionBuilder);
        this.byClass = ImmutableMap.copyOf(byClassBuilder);
    }

    @Override
    public <C extends DataObject> DataContainerCodecContext<C, ?> streamChild(Class<C> childClass) {
        DataContainerCodecPrototype child = (DataContainerCodecPrototype)this.byClass.get(childClass);
        return this.childNonNull(child, childClass, "Supplied class %s is not valid case in %s", childClass, this.bindingArg()).get();
    }

    @Override
    public <C extends DataObject> Optional<DataContainerCodecContext<C, ?>> possibleStreamChild(Class<C> childClass) {
        DataContainerCodecPrototype child = (DataContainerCodecPrototype)this.byClass.get(childClass);
        if (child != null) {
            return Optional.of(child.get());
        }
        return Optional.empty();
    }

    Iterable<Class<?>> getCaseChildrenClasses() {
        return Iterables.concat((Iterable)this.byCaseChildClass.keySet(), (Iterable)this.ambiguousByCaseChildClass.keySet());
    }

    protected DataContainerCodecPrototype<CaseSchemaNode> loadCase(Class<?> childClass) {
        Optional childSchema = this.factory().getRuntimeContext().getCaseSchemaDefinition((ChoiceSchemaNode)this.getSchema(), childClass);
        if (childSchema.isPresent()) {
            return DataContainerCodecPrototype.from(childClass, (CaseSchemaNode)childSchema.get(), this.factory());
        }
        LOG.debug("Supplied class {} is not valid case in schema {}", childClass, this.getSchema());
        return null;
    }

    @Override
    public NodeCodecContext yangPathArgumentChild(YangInstanceIdentifier.PathArgument arg) {
        DataContainerCodecPrototype cazeProto = arg instanceof YangInstanceIdentifier.NodeIdentifierWithPredicates ? (DataContainerCodecPrototype)this.byYangCaseChild.get((Object)new YangInstanceIdentifier.NodeIdentifier(arg.getNodeType())) : (DataContainerCodecPrototype)this.byYangCaseChild.get((Object)arg);
        return ((DataContainerCodecContext)this.childNonNull(cazeProto, arg, "Argument %s is not valid child of %s", arg, this.getSchema()).get()).yangPathArgumentChild(arg);
    }

    public D deserialize(NormalizedNode<?, ?> data) {
        Preconditions.checkArgument((boolean)(data instanceof ChoiceNode));
        ChoiceNode casted = (ChoiceNode)data;
        NormalizedNode first = (NormalizedNode)Iterables.getFirst((Iterable)casted.getValue(), null);
        if (first == null) {
            return null;
        }
        DataContainerCodecPrototype caze = (DataContainerCodecPrototype)this.byYangCaseChild.get((Object)first.getIdentifier());
        return (D)((DataObject)caze.get().deserialize(data));
    }

    @Override
    protected Object deserializeObject(NormalizedNode<?, ?> normalizedNode) {
        return this.deserialize(normalizedNode);
    }

    public InstanceIdentifier.PathArgument deserializePathArgument(YangInstanceIdentifier.PathArgument arg) {
        Preconditions.checkArgument((boolean)this.getDomPathArgument().equals(arg));
        return null;
    }

    public YangInstanceIdentifier.PathArgument serializePathArgument(InstanceIdentifier.PathArgument arg) {
        return this.getDomPathArgument();
    }

    DataContainerCodecContext<?, ?> getCaseByChildClass(@NonNull Class<? extends DataObject> type) {
        ImmutableList inexact;
        DataContainerCodecPrototype result = (DataContainerCodecPrototype)this.byCaseChildClass.get(type);
        if (result == null && !(inexact = this.ambiguousByCaseChildClass.get(type)).isEmpty()) {
            result = (DataContainerCodecPrototype)inexact.get(0);
            if (this.ambiguousByCaseChildWarnings.add(type)) {
                LOG.warn("Ambiguous reference {} to child of {} resolved to {}, the first case in {} This mapping is not guaranteed to be stable and is subject to variations based on runtime circumstances. Please see the stack trace for hints about the source of ambiguity.", new Object[]{type, this.bindingArg(), result.getBindingClass(), Lists.transform((List)inexact, DataContainerCodecPrototype::getBindingClass), new Throwable()});
            }
        }
        return this.childNonNull(result, type, "Class %s is not child of any cases for %s", type, this.bindingArg()).get();
    }
}

