/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.codec.impl;

import com.google.common.annotations.Beta;
import com.google.common.base.Supplier;
import com.google.common.base.Verify;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.mdsal.binding.dom.codec.impl.NodeContextSupplier;
import org.opendaylight.mdsal.binding.dom.codec.loader.CodecClassLoader;

@Beta
public final class ClassGeneratorBridge {
    private static final ThreadLocal<BridgeProvider<?>> CURRENT_CUSTOMIZER = new ThreadLocal();

    private ClassGeneratorBridge() {
    }

    public static @NonNull NodeContextSupplier resolveNodeContextSupplier(@NonNull String methodName) {
        return ClassGeneratorBridge.current(NodeContextSupplierProvider.class).resolveNodeContextSupplier(methodName);
    }

    public static @NonNull String resolveLocalName(@NonNull String methodName) {
        return ClassGeneratorBridge.current(LocalNameProvider.class).resolveLocalName(methodName);
    }

    static @Nullable BridgeProvider<?> setup(@NonNull BridgeProvider<?> next) {
        BridgeProvider<?> prev = CURRENT_CUSTOMIZER.get();
        CURRENT_CUSTOMIZER.set((BridgeProvider)Verify.verifyNotNull(next));
        return prev;
    }

    static void tearDown(@Nullable BridgeProvider<?> prev) {
        if (prev == null) {
            CURRENT_CUSTOMIZER.remove();
        } else {
            CURRENT_CUSTOMIZER.set(prev);
        }
    }

    private static <T extends BridgeProvider<?>> @NonNull T current(Class<T> requested) {
        return (T)((BridgeProvider)requested.cast(Verify.verifyNotNull(CURRENT_CUSTOMIZER.get(), (String)"No customizer attached", (Object[])new Object[0])));
    }

    static interface NodeContextSupplierProvider<T>
    extends BridgeProvider<T> {
        public @NonNull NodeContextSupplier resolveNodeContextSupplier(@NonNull String var1);
    }

    static interface LocalNameProvider<T>
    extends BridgeProvider<T> {
        public @NonNull String resolveLocalName(@NonNull String var1);
    }

    static interface BridgeProvider<T>
    extends CodecClassLoader.ClassGenerator<T> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        default public Class<T> customizeLoading(@NonNull Supplier<Class<T>> loader) {
            BridgeProvider<?> prev = ClassGeneratorBridge.setup(this);
            try {
                Class result = (Class)loader.get();
                try {
                    Class.forName(result.getName(), true, result.getClassLoader());
                }
                catch (ClassNotFoundException e) {
                    throw new LinkageError("Failed to find newly-defined " + result, e);
                }
                Class clazz = result;
                return clazz;
            }
            finally {
                ClassGeneratorBridge.tearDown(prev);
            }
        }
    }
}

