/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.codec.impl;

import com.google.common.base.MoreObjects;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.mdsal.binding.dom.codec.impl.AugmentableCodecDataObject;
import org.opendaylight.mdsal.binding.dom.codec.impl.ByteBuddyUtils;
import org.opendaylight.mdsal.binding.dom.codec.impl.ClassGeneratorBridge;
import org.opendaylight.mdsal.binding.dom.codec.impl.CodecDataObject;
import org.opendaylight.mdsal.binding.dom.codec.impl.NodeContextSupplier;
import org.opendaylight.mdsal.binding.dom.codec.impl.ValueNodeCodecContext;
import org.opendaylight.mdsal.binding.dom.codec.jar.bytebuddy.ByteBuddy;
import org.opendaylight.mdsal.binding.dom.codec.jar.bytebuddy.description.field.FieldDescription;
import org.opendaylight.mdsal.binding.dom.codec.jar.bytebuddy.description.method.MethodDescription;
import org.opendaylight.mdsal.binding.dom.codec.jar.bytebuddy.description.type.TypeDefinition;
import org.opendaylight.mdsal.binding.dom.codec.jar.bytebuddy.description.type.TypeDescription;
import org.opendaylight.mdsal.binding.dom.codec.jar.bytebuddy.dynamic.DynamicType;
import org.opendaylight.mdsal.binding.dom.codec.jar.bytebuddy.dynamic.scaffold.InstrumentedType;
import org.opendaylight.mdsal.binding.dom.codec.jar.bytebuddy.implementation.Implementation;
import org.opendaylight.mdsal.binding.dom.codec.jar.bytebuddy.implementation.bytecode.Addition;
import org.opendaylight.mdsal.binding.dom.codec.jar.bytebuddy.implementation.bytecode.ByteCodeAppender;
import org.opendaylight.mdsal.binding.dom.codec.jar.bytebuddy.implementation.bytecode.Multiplication;
import org.opendaylight.mdsal.binding.dom.codec.jar.bytebuddy.implementation.bytecode.StackManipulation;
import org.opendaylight.mdsal.binding.dom.codec.jar.bytebuddy.implementation.bytecode.assign.TypeCasting;
import org.opendaylight.mdsal.binding.dom.codec.jar.bytebuddy.implementation.bytecode.constant.ClassConstant;
import org.opendaylight.mdsal.binding.dom.codec.jar.bytebuddy.implementation.bytecode.constant.IntegerConstant;
import org.opendaylight.mdsal.binding.dom.codec.jar.bytebuddy.implementation.bytecode.constant.TextConstant;
import org.opendaylight.mdsal.binding.dom.codec.jar.bytebuddy.implementation.bytecode.member.MethodReturn;
import org.opendaylight.mdsal.binding.dom.codec.jar.bytebuddy.implementation.bytecode.member.MethodVariableAccess;
import org.opendaylight.mdsal.binding.dom.codec.jar.bytebuddy.jar.asm.Label;
import org.opendaylight.mdsal.binding.dom.codec.jar.bytebuddy.jar.asm.MethodVisitor;
import org.opendaylight.mdsal.binding.dom.codec.loader.CodecClassLoader;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class CodecDataObjectGenerator<T extends CodecDataObject<?>>
implements CodecClassLoader.ClassGenerator<T> {
    private static final Logger LOG = LoggerFactory.getLogger(CodecDataObjectGenerator.class);
    private static final TypeDescription.Generic BB_BOOLEAN = TypeDefinition.Sort.describe(Boolean.TYPE);
    private static final TypeDescription.Generic BB_DATAOBJECT = TypeDefinition.Sort.describe(DataObject.class);
    private static final TypeDescription.Generic BB_HELPER = TypeDefinition.Sort.describe(MoreObjects.ToStringHelper.class);
    private static final TypeDescription.Generic BB_INT = TypeDefinition.Sort.describe(Integer.TYPE);
    private static final TypeDescription BB_CDO = TypeDescription.ForLoadedType.of(CodecDataObject.class);
    private static final TypeDescription BB_ACDO = TypeDescription.ForLoadedType.of(AugmentableCodecDataObject.class);
    private static final Comparator<Method> METHOD_BY_ALPHABET = Comparator.comparing(Method::getName);
    private static final StackManipulation ARRAYS_EQUALS = ByteBuddyUtils.invokeMethod(Arrays.class, "equals", byte[].class, byte[].class);
    private static final StackManipulation OBJECTS_EQUALS = ByteBuddyUtils.invokeMethod(Objects.class, "equals", Object.class, Object.class);
    private static final StackManipulation HELPER_ADD = ByteBuddyUtils.invokeMethod(MoreObjects.ToStringHelper.class, "add", String.class, Object.class);
    private static final StackManipulation FIRST_ARG_REF = MethodVariableAccess.REFERENCE.loadFrom(1);
    private static final int PROT_FINAL = 4116;
    private static final int PUB_FINAL = 4113;
    private static final ByteBuddy BB = new ByteBuddy();
    private final TypeDescription superClass;
    private final Method keyMethod;

    CodecDataObjectGenerator(TypeDescription superClass, @Nullable Method keyMethod) {
        this.superClass = Objects.requireNonNull(superClass);
        this.keyMethod = keyMethod;
    }

    static <D extends DataObject, T extends CodecDataObject<T>> Class<T> generate(CodecClassLoader loader, Class<D> bindingInterface, ImmutableMap<Method, ValueNodeCodecContext> simpleProperties, Map<Method, Class<?>> daoProperties, Method keyMethod) {
        return loader.generateClass(bindingInterface, "codecImpl", new Reusable(BB_CDO, simpleProperties, daoProperties, keyMethod));
    }

    static <D extends DataObject, T extends CodecDataObject<T>> Class<T> generateAugmentable(CodecClassLoader loader, Class<D> bindingInterface, ImmutableMap<Method, ValueNodeCodecContext> simpleProperties, Map<Method, Class<?>> daoProperties, Method keyMethod) {
        return loader.generateClass(bindingInterface, "codecImpl", new Reusable(BB_ACDO, simpleProperties, daoProperties, keyMethod));
    }

    @Override
    public final CodecClassLoader.GeneratorResult<T> generateClass(CodecClassLoader loeader, String fqcn, Class<?> bindingInterface) {
        LOG.trace("Generating class {}", (Object)fqcn);
        TypeDescription.Generic bindingDef = TypeDefinition.Sort.describe(bindingInterface);
        DynamicType.Builder<?> builder = BB.subclass(TypeDescription.Generic.Builder.parameterizedType(this.superClass, bindingDef).build()).visit(ByteBuddyUtils.computeFrames()).name(fqcn).implement(bindingDef);
        builder = this.generateGetters(builder);
        if (this.keyMethod != null) {
            LOG.trace("Generating for key {}", (Object)this.keyMethod);
            String methodName = this.keyMethod.getName();
            TypeDescription retType = TypeDescription.ForLoadedType.of(this.keyMethod.getReturnType());
            builder = builder.defineMethod(methodName, (TypeDefinition)retType, 4113).intercept(new KeyMethodImplementation(methodName, retType));
        }
        ArrayList<Method> properties = this.getterMethods();
        properties.sort(METHOD_BY_ALPHABET);
        ImmutableMap methods = Maps.uniqueIndex(properties, ByteBuddyUtils::invokeMethod);
        return CodecClassLoader.GeneratorResult.of(builder.defineMethod("codecHashCode", (TypeDefinition)BB_INT, 4116).intercept(new Implementation.Simple(new CodecHashCode((ImmutableMap<StackManipulation, Method>)methods))).defineMethod("codecEquals", (TypeDefinition)BB_BOOLEAN, 4116).withParameter(BB_DATAOBJECT).intercept(CodecDataObjectGenerator.codecEquals((ImmutableMap<StackManipulation, Method>)methods)).defineMethod("codecFillToString", (TypeDefinition)BB_HELPER, 4116).withParameter(BB_HELPER).intercept(CodecDataObjectGenerator.codecFillToString((ImmutableMap<StackManipulation, Method>)methods)).make());
    }

    abstract DynamicType.Builder<T> generateGetters(DynamicType.Builder<T> var1);

    abstract ArrayList<Method> getterMethods();

    private static Implementation codecEquals(ImmutableMap<StackManipulation, Method> properties) {
        Label falseLabel = new Label();
        StackManipulation ifFalse = ByteBuddyUtils.ifEq(falseLabel);
        ArrayList<StackManipulation> manipulations = new ArrayList<StackManipulation>(properties.size() * 6 + 5);
        for (Map.Entry entry : properties.entrySet()) {
            manipulations.add(ByteBuddyUtils.THIS);
            manipulations.add((StackManipulation)entry.getKey());
            manipulations.add(FIRST_ARG_REF);
            manipulations.add((StackManipulation)entry.getKey());
            manipulations.add(((Method)entry.getValue()).getReturnType().isArray() ? ARRAYS_EQUALS : OBJECTS_EQUALS);
            manipulations.add(ifFalse);
        }
        manipulations.add(IntegerConstant.ONE);
        manipulations.add(MethodReturn.INTEGER);
        manipulations.add(ByteBuddyUtils.markLabel(falseLabel));
        manipulations.add(IntegerConstant.ZERO);
        manipulations.add(MethodReturn.INTEGER);
        return new Implementation.Simple(manipulations.toArray(new StackManipulation[0]));
    }

    private static Implementation codecFillToString(ImmutableMap<StackManipulation, Method> properties) {
        ArrayList<StackManipulation> manipulations = new ArrayList<StackManipulation>(properties.size() * 4 + 2);
        manipulations.add(FIRST_ARG_REF);
        for (Map.Entry entry : properties.entrySet()) {
            manipulations.add(new TextConstant(((Method)entry.getValue()).getName()));
            manipulations.add(ByteBuddyUtils.THIS);
            manipulations.add((StackManipulation)entry.getKey());
            manipulations.add(HELPER_ADD);
        }
        manipulations.add(MethodReturn.REFERENCE);
        return new Implementation.Simple(manipulations.toArray(new StackManipulation[0]));
    }

    private static final class CodecHashCode
    implements ByteCodeAppender {
        private static final StackManipulation THIRTY_ONE = IntegerConstant.forValue(31);
        private static final StackManipulation LOAD_RESULT = MethodVariableAccess.INTEGER.loadFrom(1);
        private static final StackManipulation STORE_RESULT = MethodVariableAccess.INTEGER.storeAt(1);
        private static final StackManipulation ARRAYS_HASHCODE = ByteBuddyUtils.invokeMethod(Arrays.class, "hashCode", byte[].class);
        private static final StackManipulation OBJECTS_HASHCODE = ByteBuddyUtils.invokeMethod(Objects.class, "hashCode", Object.class);
        private final ImmutableMap<StackManipulation, Method> properties;

        CodecHashCode(ImmutableMap<StackManipulation, Method> properties) {
            this.properties = Objects.requireNonNull(properties);
        }

        @Override
        public ByteCodeAppender.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext, MethodDescription instrumentedMethod) {
            ArrayList<StackManipulation> manipulations = new ArrayList<StackManipulation>(this.properties.size() * 8 + 4);
            manipulations.add(IntegerConstant.ONE);
            manipulations.add(STORE_RESULT);
            for (Map.Entry entry : this.properties.entrySet()) {
                manipulations.add(THIRTY_ONE);
                manipulations.add(LOAD_RESULT);
                manipulations.add(Multiplication.INTEGER);
                manipulations.add(ByteBuddyUtils.THIS);
                manipulations.add((StackManipulation)entry.getKey());
                manipulations.add(((Method)entry.getValue()).getReturnType().isArray() ? ARRAYS_HASHCODE : OBJECTS_HASHCODE);
                manipulations.add(Addition.INTEGER);
                manipulations.add(STORE_RESULT);
            }
            manipulations.add(LOAD_RESULT);
            manipulations.add(MethodReturn.INTEGER);
            StackManipulation.Size operandStackSize = new StackManipulation.Compound(manipulations).apply(methodVisitor, implementationContext);
            return new ByteCodeAppender.Size(operandStackSize.getMaximalSize(), instrumentedMethod.getStackSize() + 1);
        }
    }

    private static final class SupplierGetterMethodImplementation
    extends AbstractMethodImplementation {
        private static final StackManipulation CODEC_MEMBER = ByteBuddyUtils.invokeMethod(CodecDataObject.class, "codecMember", VarHandle.class, NodeContextSupplier.class);
        private static final StackManipulation BRIDGE_RESOLVE = ByteBuddyUtils.invokeMethod(ClassGeneratorBridge.class, "resolveNodeContextSupplier", String.class);
        private static final TypeDescription.Generic BB_NCS = TypeDefinition.Sort.describe(NodeContextSupplier.class);
        private final String contextName;

        SupplierGetterMethodImplementation(String methodName, TypeDescription retType) {
            super(methodName, retType);
            this.contextName = methodName + "$$$C";
        }

        @Override
        public InstrumentedType prepare(InstrumentedType instrumentedType) {
            InstrumentedType tmp = super.prepare(instrumentedType).withField(new FieldDescription.Token(this.contextName, 4122, BB_NCS));
            return tmp.withInitializer(new ByteCodeAppender.Simple(new TextConstant(this.methodName), BRIDGE_RESOLVE, ByteBuddyUtils.putField(tmp, this.contextName)));
        }

        @Override
        public ByteCodeAppender appender(Implementation.Target implementationTarget) {
            TypeDescription instrumentedType = implementationTarget.getInstrumentedType();
            return new ByteCodeAppender.Simple(ByteBuddyUtils.THIS, ByteBuddyUtils.getField(instrumentedType, this.handleName), ByteBuddyUtils.getField(instrumentedType, this.contextName), CODEC_MEMBER, TypeCasting.to(this.retType), MethodReturn.REFERENCE);
        }
    }

    private static final class StructuredGetterMethodImplementation
    extends AbstractMethodImplementation {
        private static final StackManipulation CODEC_MEMBER = ByteBuddyUtils.invokeMethod(CodecDataObject.class, "codecMember", VarHandle.class, Class.class);
        private final Class<?> bindingClass;

        StructuredGetterMethodImplementation(String methodName, TypeDescription retType, Class<?> bindingClass) {
            super(methodName, retType);
            this.bindingClass = Objects.requireNonNull(bindingClass);
        }

        @Override
        public ByteCodeAppender appender(Implementation.Target implementationTarget) {
            TypeDescription instrumentedType = implementationTarget.getInstrumentedType();
            return new ByteCodeAppender.Simple(ByteBuddyUtils.THIS, ByteBuddyUtils.getField(instrumentedType, this.handleName), ClassConstant.of(TypeDefinition.Sort.describe(this.bindingClass).asErasure()), CODEC_MEMBER, TypeCasting.to(this.retType), MethodReturn.REFERENCE);
        }
    }

    private static final class SimpleGetterMethodImplementation
    extends AbstractMethodImplementation {
        private static final StackManipulation CODEC_MEMBER = ByteBuddyUtils.invokeMethod(CodecDataObject.class, "codecMember", VarHandle.class, String.class);
        private static final StackManipulation BRIDGE_RESOLVE = ByteBuddyUtils.invokeMethod(ClassGeneratorBridge.class, "resolveLocalName", String.class);
        private static final TypeDescription.Generic BB_STRING = TypeDefinition.Sort.describe(String.class);
        private final String stringName;

        SimpleGetterMethodImplementation(String methodName, TypeDescription retType) {
            super(methodName, retType);
            this.stringName = methodName + "$$$S";
        }

        @Override
        public InstrumentedType prepare(InstrumentedType instrumentedType) {
            InstrumentedType tmp = super.prepare(instrumentedType).withField(new FieldDescription.Token(this.stringName, 4122, BB_STRING));
            return tmp.withInitializer(new ByteCodeAppender.Simple(new TextConstant(this.methodName), BRIDGE_RESOLVE, ByteBuddyUtils.putField(tmp, this.stringName)));
        }

        @Override
        public ByteCodeAppender appender(Implementation.Target implementationTarget) {
            TypeDescription instrumentedType = implementationTarget.getInstrumentedType();
            return new ByteCodeAppender.Simple(ByteBuddyUtils.THIS, ByteBuddyUtils.getField(instrumentedType, this.handleName), ByteBuddyUtils.getField(instrumentedType, this.stringName), CODEC_MEMBER, TypeCasting.to(this.retType), MethodReturn.REFERENCE);
        }
    }

    private static final class KeyMethodImplementation
    extends AbstractMethodImplementation {
        private static final StackManipulation CODEC_KEY = ByteBuddyUtils.invokeMethod(CodecDataObject.class, "codecKey", VarHandle.class);

        KeyMethodImplementation(String methodName, TypeDescription retType) {
            super(methodName, retType);
        }

        @Override
        public ByteCodeAppender appender(Implementation.Target implementationTarget) {
            TypeDescription instrumentedType = implementationTarget.getInstrumentedType();
            return new ByteCodeAppender.Simple(ByteBuddyUtils.THIS, ByteBuddyUtils.getField(instrumentedType, this.handleName), CODEC_KEY, TypeCasting.to(this.retType), MethodReturn.REFERENCE);
        }
    }

    private static abstract class AbstractMethodImplementation
    implements Implementation {
        private static final TypeDescription.Generic BB_HANDLE = TypeDefinition.Sort.describe(VarHandle.class);
        private static final TypeDescription.Generic BB_OBJECT = TypeDefinition.Sort.describe(Object.class);
        private static final StackManipulation OBJECT_CLASS = ClassConstant.of(TypeDescription.OBJECT);
        private static final StackManipulation LOOKUP = ByteBuddyUtils.invokeMethod(MethodHandles.class, "lookup", new Class[0]);
        private static final StackManipulation FIND_VAR_HANDLE = ByteBuddyUtils.invokeMethod(MethodHandles.Lookup.class, "findVarHandle", Class.class, String.class, Class.class);
        static final int PRIV_CONST = 4122;
        private static final int PRIV_VOLATILE = 4162;
        final TypeDescription retType;
        final String methodName;
        final String handleName;

        AbstractMethodImplementation(String methodName, TypeDescription retType) {
            this.methodName = Objects.requireNonNull(methodName);
            this.retType = Objects.requireNonNull(retType);
            this.handleName = methodName + "$$$V";
        }

        @Override
        public InstrumentedType prepare(InstrumentedType instrumentedType) {
            InstrumentedType tmp = instrumentedType.withField(new FieldDescription.Token(this.handleName, 4122, BB_HANDLE)).withField(new FieldDescription.Token(this.methodName, 4162, BB_OBJECT));
            return tmp.withInitializer(new ByteCodeAppender.Simple(LOOKUP, ClassConstant.of(tmp), new TextConstant(this.methodName), OBJECT_CLASS, FIND_VAR_HANDLE, ByteBuddyUtils.putField(tmp, this.handleName)));
        }
    }

    private static final class Reusable<T extends CodecDataObject<?>>
    extends CodecDataObjectGenerator<T>
    implements ClassGeneratorBridge.LocalNameProvider<T> {
        private final ImmutableMap<Method, ValueNodeCodecContext> simpleProperties;
        private final Map<Method, Class<?>> daoProperties;

        Reusable(TypeDescription superClass, ImmutableMap<Method, ValueNodeCodecContext> simpleProperties, Map<Method, Class<?>> daoProperties, @Nullable Method keyMethod) {
            super(superClass, keyMethod);
            this.simpleProperties = Objects.requireNonNull(simpleProperties);
            this.daoProperties = Objects.requireNonNull(daoProperties);
        }

        @Override
        DynamicType.Builder<T> generateGetters(DynamicType.Builder<T> builder) {
            DynamicType.Builder<T> tmp = builder;
            for (Method method : this.simpleProperties.keySet()) {
                LOG.trace("Generating for simple method {}", (Object)method);
                String methodName = method.getName();
                TypeDescription retType = TypeDescription.ForLoadedType.of(method.getReturnType());
                tmp = tmp.defineMethod(methodName, (TypeDefinition)retType, 4113).intercept(new SimpleGetterMethodImplementation(methodName, retType));
            }
            for (Map.Entry entry : this.daoProperties.entrySet()) {
                Method method = (Method)entry.getKey();
                LOG.trace("Generating for structured method {}", (Object)method);
                String methodName = method.getName();
                TypeDescription retType = TypeDescription.ForLoadedType.of(method.getReturnType());
                tmp = tmp.defineMethod(methodName, (TypeDefinition)retType, 4113).intercept(new StructuredGetterMethodImplementation(methodName, retType, (Class)entry.getValue()));
            }
            return tmp;
        }

        @Override
        ArrayList<Method> getterMethods() {
            ArrayList<Method> ret = new ArrayList<Method>(this.simpleProperties.size() + this.daoProperties.size());
            ret.addAll((Collection<Method>)this.simpleProperties.keySet());
            ret.addAll(this.daoProperties.keySet());
            return ret;
        }

        @Override
        public String resolveLocalName(String methodName) {
            Optional<Map.Entry> found = this.simpleProperties.entrySet().stream().filter(entry -> methodName.equals(((Method)entry.getKey()).getName())).findAny();
            Verify.verify((boolean)found.isPresent(), (String)"Failed to find property for %s in %s", (Object)methodName, (Object)this);
            return ((ValueNodeCodecContext)found.get().getValue()).getSchema().getQName().getLocalName();
        }
    }

    private static final class Fixed<T extends CodecDataObject<?>>
    extends CodecDataObjectGenerator<T>
    implements ClassGeneratorBridge.NodeContextSupplierProvider<T> {
        private final ImmutableMap<Method, NodeContextSupplier> properties;

        Fixed(TypeDescription superClass, ImmutableMap<Method, NodeContextSupplier> properties, @Nullable Method keyMethod) {
            super(superClass, keyMethod);
            this.properties = Objects.requireNonNull(properties);
        }

        @Override
        DynamicType.Builder<T> generateGetters(DynamicType.Builder<T> builder) {
            DynamicType.Builder<T> tmp = builder;
            for (Method method : this.properties.keySet()) {
                LOG.trace("Generating for fixed method {}", (Object)method);
                String methodName = method.getName();
                TypeDescription retType = TypeDescription.ForLoadedType.of(method.getReturnType());
                tmp = tmp.defineMethod(methodName, (TypeDefinition)retType, 4113).intercept(new SupplierGetterMethodImplementation(methodName, retType));
            }
            return tmp;
        }

        @Override
        ArrayList<Method> getterMethods() {
            return new ArrayList<Method>((Collection<Method>)this.properties.keySet());
        }

        @Override
        public NodeContextSupplier resolveNodeContextSupplier(String methodName) {
            Optional<Map.Entry> found = this.properties.entrySet().stream().filter(entry -> methodName.equals(((Method)entry.getKey()).getName())).findAny();
            Verify.verify((boolean)found.isPresent(), (String)"Failed to find property for %s in %s", (Object)methodName, (Object)this);
            return (NodeContextSupplier)Verify.verifyNotNull((Object)((NodeContextSupplier)found.get().getValue()));
        }
    }
}

