/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.codec.impl;

import com.google.common.base.Preconditions;
import java.util.Objects;
import org.opendaylight.binding.runtime.api.BindingRuntimeContext;
import org.opendaylight.mdsal.binding.dom.codec.api.BindingIdentityCodec;
import org.opendaylight.mdsal.binding.spec.reflect.BindingReflections;
import org.opendaylight.yangtools.concepts.AbstractIllegalArgumentCodec;
import org.opendaylight.yangtools.yang.binding.BaseIdentity;
import org.opendaylight.yangtools.yang.common.QName;

final class IdentityCodec
extends AbstractIllegalArgumentCodec<QName, Class<?>>
implements BindingIdentityCodec {
    private final BindingRuntimeContext context;

    IdentityCodec(BindingRuntimeContext context) {
        this.context = Objects.requireNonNull(context);
    }

    protected Class<?> deserializeImpl(QName input) {
        return this.context.getIdentityClass(input);
    }

    protected QName serializeImpl(Class<?> input) {
        Preconditions.checkArgument((boolean)BaseIdentity.class.isAssignableFrom(input), (String)"%s is not an identity", input);
        return BindingReflections.findQName(input);
    }

    public Class<? extends BaseIdentity> toBinding(QName qname) {
        Class identity = this.context.getIdentityClass(Objects.requireNonNull(qname));
        Preconditions.checkArgument((boolean)BaseIdentity.class.isAssignableFrom(identity), (String)"%s resolves to non-identity %s", (Object)qname, (Object)identity);
        return identity.asSubclass(BaseIdentity.class);
    }

    public QName fromBinding(Class<? extends BaseIdentity> bindingClass) {
        return BindingReflections.getQName(bindingClass);
    }
}

