/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.codec.jar.bytebuddy.implementation.bytecode.assign;

import org.opendaylight.mdsal.binding.dom.codec.jar.bytebuddy.build.HashCodeAndEqualsPlugin;
import org.opendaylight.mdsal.binding.dom.codec.jar.bytebuddy.description.type.TypeDefinition;
import org.opendaylight.mdsal.binding.dom.codec.jar.bytebuddy.description.type.TypeDescription;
import org.opendaylight.mdsal.binding.dom.codec.jar.bytebuddy.implementation.Implementation;
import org.opendaylight.mdsal.binding.dom.codec.jar.bytebuddy.implementation.bytecode.StackManipulation;
import org.opendaylight.mdsal.binding.dom.codec.jar.bytebuddy.implementation.bytecode.StackSize;
import org.opendaylight.mdsal.binding.dom.codec.jar.bytebuddy.jar.asm.MethodVisitor;

@HashCodeAndEqualsPlugin.Enhance
public class TypeCasting
implements StackManipulation {
    private final TypeDescription typeDescription;

    protected TypeCasting(TypeDescription typeDescription) {
        this.typeDescription = typeDescription;
    }

    public static StackManipulation to(TypeDefinition typeDefinition) {
        if (typeDefinition.isPrimitive()) {
            throw new IllegalArgumentException("Cannot cast to primitive type: " + typeDefinition);
        }
        return new TypeCasting(typeDefinition.asErasure());
    }

    public boolean isValid() {
        return true;
    }

    public StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
        methodVisitor.visitTypeInsn(192, this.typeDescription.getInternalName());
        return StackSize.ZERO.toIncreasingSize();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        return this.typeDescription.equals(((TypeCasting)object).typeDescription);
    }

    public int hashCode() {
        return 17 * 31 + this.typeDescription.hashCode();
    }
}

