/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.audit.layout;

import java.io.IOException;
import org.apache.karaf.audit.Event;
import org.apache.karaf.audit.layout.AbstractLayout;
import org.apache.karaf.audit.util.Buffer;

public class GelfLayout
extends AbstractLayout {
    public GelfLayout() {
        super(new Buffer(Buffer.Format.Json));
    }

    @Override
    protected void header(Event event) throws IOException {
        this.buffer.append('{');
        this.append("version", "1.1", false);
        this.append("host", this.hostName, false);
        this.datetime(event.timestamp());
        this.append("short_message", event.type() + "." + event.subtype(), false);
    }

    private void datetime(long timestamp) throws IOException {
        this.buffer.append(" timestamp=");
        long secs = timestamp / 1000L;
        int ms = (int)(timestamp - secs * 1000L);
        this.buffer.format(secs);
        this.buffer.append('.');
        int temp = ms / 100;
        this.buffer.append((char)(temp + 48));
        ms -= 100 * temp;
        temp = ms / 10;
        this.buffer.append((char)(temp + 48));
        this.buffer.append((char)((ms -= 10 * temp) + 48));
    }

    @Override
    protected void footer(Event event) throws IOException {
        this.buffer.append(' ');
        this.buffer.append('}');
    }

    @Override
    protected void append(String key, Object val) throws IOException {
        this.append(key, val, true);
    }

    protected void append(String key, Object val, boolean custom) throws IOException {
        if (val != null) {
            this.buffer.append(' ');
            if (custom) {
                this.buffer.append('_');
            }
            this.buffer.append(key);
            this.buffer.append('=');
            if (val instanceof Number) {
                if (val instanceof Long) {
                    this.buffer.format((Long)val);
                } else if (val instanceof Integer) {
                    this.buffer.format((Integer)val);
                } else {
                    this.buffer.append(val.toString());
                }
            } else {
                this.buffer.append('\"');
                this.buffer.format(val);
                this.buffer.append('\"');
            }
        }
    }
}

