/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.audit.util;

import java.io.IOException;
import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;

public class FastDateFormat {
    public static final String YYYY_MM_DD = "yyyy-MM-dd";
    public static final String MMM_D2 = "MMM d2";
    public static final String XXX = "XXX";
    private final TimeZone timeZone;
    private final Locale locale;
    private long midnightTomorrow;
    private long midnightToday;
    private final int[] dstOffsets = new int[25];
    private Map<String, String> cache = new HashMap<String, String>();

    public FastDateFormat() {
        this(TimeZone.getDefault(), Locale.ENGLISH);
    }

    public FastDateFormat(TimeZone timeZone, Locale locale) {
        this.timeZone = timeZone;
        this.locale = locale;
    }

    public boolean sameDay(long now) {
        if (now >= this.midnightTomorrow || now < this.midnightToday) {
            this.updateMidnightMillis(now);
            this.updateDaylightSavingTime();
            this.cache.clear();
            return false;
        }
        return true;
    }

    public String getDate(long now, String pattern) {
        this.sameDay(now);
        String date = this.cache.get(pattern);
        if (date == null) {
            if (MMM_D2.equals(pattern)) {
                StringBuffer sb = new StringBuffer();
                FieldPosition fp = new FieldPosition(DateFormat.Field.DAY_OF_MONTH);
                SimpleDateFormat sdf = new SimpleDateFormat("MMM dd", this.locale);
                sdf.setCalendar(Calendar.getInstance(this.timeZone, this.locale));
                sdf.format(new Date(now), sb, fp);
                if (sb.charAt(fp.getBeginIndex()) == '0') {
                    sb.setCharAt(fp.getBeginIndex(), ' ');
                }
                date = sb.toString();
            } else {
                SimpleDateFormat sdf = new SimpleDateFormat(pattern, this.locale);
                sdf.setCalendar(Calendar.getInstance(this.timeZone, this.locale));
                date = sdf.format(new Date(now));
            }
            this.cache.put(pattern, date);
        }
        return date;
    }

    public void writeTime(long now, boolean writeMillis, Appendable buffer) throws IOException {
        int ms = this.millisSinceMidnight(now);
        int hourOfDay = ms / 3600000;
        int hours = hourOfDay + this.daylightSavingTime(hourOfDay) / 3600000;
        int minutes = (ms -= 3600000 * hourOfDay) / 60000;
        int seconds = (ms -= 60000 * minutes) / 1000;
        ms -= 1000 * seconds;
        int temp = hours / 10;
        buffer.append((char)(temp + 48));
        buffer.append((char)(hours - 10 * temp + 48));
        buffer.append(':');
        temp = minutes / 10;
        buffer.append((char)(temp + 48));
        buffer.append((char)(minutes - 10 * temp + 48));
        buffer.append(':');
        temp = seconds / 10;
        buffer.append((char)(temp + 48));
        buffer.append((char)(seconds - 10 * temp + 48));
        if (writeMillis) {
            buffer.append('.');
            temp = ms / 100;
            buffer.append((char)(temp + 48));
            ms -= 100 * temp;
            temp = ms / 10;
            buffer.append((char)(temp + 48));
            buffer.append((char)((ms -= 10 * temp) + 48));
        }
    }

    private int millisSinceMidnight(long now) {
        this.sameDay(now);
        return (int)(now - this.midnightToday);
    }

    private int daylightSavingTime(int hourOfDay) {
        return hourOfDay > 23 ? this.dstOffsets[23] : this.dstOffsets[hourOfDay];
    }

    private void updateMidnightMillis(long now) {
        Calendar cal = Calendar.getInstance(this.timeZone);
        cal.setTimeInMillis(now);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        this.midnightToday = cal.getTimeInMillis();
        cal.add(5, 1);
        this.midnightTomorrow = cal.getTimeInMillis();
    }

    private void updateDaylightSavingTime() {
        Arrays.fill(this.dstOffsets, 0);
        int ONE_HOUR = (int)TimeUnit.HOURS.toMillis(1L);
        if (this.timeZone.getOffset(this.midnightToday) != this.timeZone.getOffset(this.midnightToday + (long)(23 * ONE_HOUR))) {
            int i;
            for (i = 0; i < this.dstOffsets.length; ++i) {
                long time = this.midnightToday + (long)(i * ONE_HOUR);
                this.dstOffsets[i] = this.timeZone.getOffset(time) - this.timeZone.getRawOffset();
            }
            if (this.dstOffsets[0] > this.dstOffsets[23]) {
                i = this.dstOffsets.length - 1;
                while (i >= 0) {
                    int n = i--;
                    this.dstOffsets[n] = this.dstOffsets[n] - this.dstOffsets[0];
                }
            }
        }
    }
}

