/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.adapter;

import com.google.common.base.Verify;
import com.google.common.collect.ClassToInstanceMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Objects;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.opendaylight.mdsal.binding.api.ActionProviderService;
import org.opendaylight.mdsal.binding.api.DataTreeIdentifier;
import org.opendaylight.mdsal.binding.dom.adapter.AbstractBindingAdapter;
import org.opendaylight.mdsal.binding.dom.adapter.AdapterContext;
import org.opendaylight.mdsal.binding.dom.adapter.BindingDOMAdapterBuilder;
import org.opendaylight.mdsal.binding.dom.adapter.BindingOperationFluentFuture;
import org.opendaylight.mdsal.binding.dom.adapter.CurrentAdapterSerializer;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.mdsal.dom.api.DOMActionImplementation;
import org.opendaylight.mdsal.dom.api.DOMActionProviderService;
import org.opendaylight.mdsal.dom.api.DOMActionResult;
import org.opendaylight.mdsal.dom.api.DOMDataTreeIdentifier;
import org.opendaylight.mdsal.dom.api.DOMService;
import org.opendaylight.yangtools.concepts.AbstractObjectRegistration;
import org.opendaylight.yangtools.concepts.ObjectRegistration;
import org.opendaylight.yangtools.yang.binding.Action;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.common.YangConstants;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.ContainerNode;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;

@NonNullByDefault
public final class ActionProviderServiceAdapter
extends AbstractBindingAdapter<DOMActionProviderService>
implements ActionProviderService {
    static final BindingDOMAdapterBuilder.Factory<ActionProviderService> BUILDER_FACTORY = Builder::new;

    ActionProviderServiceAdapter(AdapterContext adapterContext, DOMActionProviderService delegate) {
        super(adapterContext, delegate);
    }

    public <O extends DataObject, P extends InstanceIdentifier<O>, T extends Action<P, ?, ?>, S extends T> ObjectRegistration<S> registerImplementation(Class<T> actionInterface, S implementation, LogicalDatastoreType datastore, Set<DataTreeIdentifier<O>> validNodes) {
        SchemaPath path = this.currentSerializer().getActionPath(actionInterface);
        final ObjectRegistration reg = ((DOMActionProviderService)this.getDelegate()).registerActionImplementation((DOMActionImplementation)new Impl(this.adapterContext(), YangInstanceIdentifier.NodeIdentifier.create((QName)YangConstants.operationOutputQName((QNameModule)path.getLastComponent().getModule())), (Class<? extends Action<?, ?, ?>>)actionInterface, (Action<?, ?, ?>)implementation), (Set)ImmutableSet.of());
        return new AbstractObjectRegistration<S>((Action)implementation){

            protected void removeRegistration() {
                reg.close();
            }
        };
    }

    private static final class Impl
    implements DOMActionImplementation {
        private final Class<? extends Action<?, ?, ?>> actionInterface;
        private final AdapterContext adapterContext;
        private final Action implementation;
        private final YangInstanceIdentifier.NodeIdentifier outputName;

        Impl(AdapterContext adapterContext, YangInstanceIdentifier.NodeIdentifier outputName, Class<? extends Action<?, ?, ?>> actionInterface, Action<?, ?, ?> implementation) {
            this.adapterContext = Objects.requireNonNull(adapterContext);
            this.outputName = Objects.requireNonNull(outputName);
            this.actionInterface = Objects.requireNonNull(actionInterface);
            this.implementation = Objects.requireNonNull(implementation);
        }

        public ListenableFuture<? extends DOMActionResult> invokeAction(SchemaPath type, DOMDataTreeIdentifier path, ContainerNode input) {
            CurrentAdapterSerializer codec = this.adapterContext.currentSerializer();
            ListenableFuture userFuture = this.implementation.invoke((InstanceIdentifier)Verify.verifyNotNull((Object)codec.fromYangInstanceIdentifier(path.getRootIdentifier())), codec.fromNormalizedNodeActionInput(this.actionInterface, input));
            if (userFuture instanceof BindingOperationFluentFuture) {
                return (BindingOperationFluentFuture)userFuture;
            }
            return new BindingOperationFluentFuture(userFuture, this.actionInterface, this.outputName, this.adapterContext);
        }
    }

    private static final class Builder
    extends BindingDOMAdapterBuilder<ActionProviderService> {
        Builder(AdapterContext adapterContext) {
            super(adapterContext);
        }

        @Override
        protected ActionProviderService createInstance(ClassToInstanceMap<DOMService> delegates) {
            return new ActionProviderServiceAdapter(this.adapterContext(), (DOMActionProviderService)delegates.getInstance(DOMActionProviderService.class));
        }

        @Override
        public Set<? extends Class<? extends DOMService>> getRequiredDelegates() {
            return ImmutableSet.of(DOMActionProviderService.class);
        }
    }
}

