/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.adapter;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ClassToInstanceMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.ListenableFuture;
import java.time.Instant;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.mdsal.binding.api.NotificationPublishService;
import org.opendaylight.mdsal.binding.dom.adapter.AbstractBindingAdapter;
import org.opendaylight.mdsal.binding.dom.adapter.AdapterContext;
import org.opendaylight.mdsal.binding.dom.adapter.BindingDOMAdapterBuilder;
import org.opendaylight.mdsal.binding.dom.adapter.LazySerializedDOMNotification;
import org.opendaylight.mdsal.binding.dom.codec.api.BindingNormalizedNodeSerializer;
import org.opendaylight.mdsal.dom.api.DOMNotification;
import org.opendaylight.mdsal.dom.api.DOMNotificationPublishService;
import org.opendaylight.mdsal.dom.api.DOMService;
import org.opendaylight.yangtools.yang.binding.EventInstantAware;
import org.opendaylight.yangtools.yang.binding.Notification;

@VisibleForTesting
public class BindingDOMNotificationPublishServiceAdapter
extends AbstractBindingAdapter<DOMNotificationPublishService>
implements NotificationPublishService {
    static final BindingDOMAdapterBuilder.Factory<NotificationPublishService> BUILDER_FACTORY = Builder::new;

    public BindingDOMNotificationPublishServiceAdapter(AdapterContext adapterContext, DOMNotificationPublishService domPublishService) {
        super(adapterContext, domPublishService);
    }

    public DOMNotificationPublishService getDomPublishService() {
        return (DOMNotificationPublishService)this.getDelegate();
    }

    public void putNotification(Notification notification) throws InterruptedException {
        ((DOMNotificationPublishService)this.getDelegate()).putNotification(this.toDomNotification(notification));
    }

    public ListenableFuture<? extends Object> offerNotification(Notification notification) {
        ListenableFuture offerResult = ((DOMNotificationPublishService)this.getDelegate()).offerNotification(this.toDomNotification(notification));
        return DOMNotificationPublishService.REJECTED.equals(offerResult) ? NotificationPublishService.REJECTED : offerResult;
    }

    public ListenableFuture<? extends Object> offerNotification(Notification notification, int timeout, TimeUnit unit) throws InterruptedException {
        ListenableFuture offerResult = ((DOMNotificationPublishService)this.getDelegate()).offerNotification(this.toDomNotification(notification), (long)timeout, unit);
        return DOMNotificationPublishService.REJECTED.equals(offerResult) ? NotificationPublishService.REJECTED : offerResult;
    }

    private @NonNull DOMNotification toDomNotification(Notification notification) {
        Instant instant = notification instanceof EventInstantAware ? ((EventInstantAware)notification).eventInstant() : Instant.now();
        return LazySerializedDOMNotification.create((BindingNormalizedNodeSerializer)this.currentSerializer(), notification, instant);
    }

    protected static class Builder
    extends BindingDOMAdapterBuilder<NotificationPublishService> {
        Builder(AdapterContext adapterContext) {
            super(adapterContext);
        }

        @Override
        public Set<Class<? extends DOMService>> getRequiredDelegates() {
            return ImmutableSet.of(DOMNotificationPublishService.class);
        }

        @Override
        protected NotificationPublishService createInstance(ClassToInstanceMap<DOMService> delegates) {
            return new BindingDOMNotificationPublishServiceAdapter(this.adapterContext(), (DOMNotificationPublishService)delegates.getInstance(DOMNotificationPublishService.class));
        }
    }
}

