/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.adapter;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ClassToInstanceMap;
import com.google.common.collect.ImmutableSet;
import java.util.Objects;
import java.util.Set;
import org.opendaylight.mdsal.binding.api.NotificationService;
import org.opendaylight.mdsal.binding.dom.adapter.AdapterContext;
import org.opendaylight.mdsal.binding.dom.adapter.BindingDOMAdapterBuilder;
import org.opendaylight.mdsal.binding.dom.adapter.BindingDOMNotificationListenerAdapter;
import org.opendaylight.mdsal.dom.api.DOMNotificationListener;
import org.opendaylight.mdsal.dom.api.DOMNotificationService;
import org.opendaylight.mdsal.dom.api.DOMService;
import org.opendaylight.yangtools.concepts.AbstractListenerRegistration;
import org.opendaylight.yangtools.concepts.ListenerRegistration;
import org.opendaylight.yangtools.yang.binding.NotificationListener;

@VisibleForTesting
public class BindingDOMNotificationServiceAdapter
implements NotificationService {
    public static final BindingDOMAdapterBuilder.Factory<NotificationService> BUILDER_FACTORY = Builder::new;
    private final AdapterContext adapterContext;
    private final DOMNotificationService domNotifService;

    public BindingDOMNotificationServiceAdapter(AdapterContext adapterContext, DOMNotificationService domNotifService) {
        this.adapterContext = Objects.requireNonNull(adapterContext);
        this.domNotifService = domNotifService;
    }

    public <T extends NotificationListener> ListenerRegistration<T> registerNotificationListener(T listener) {
        BindingDOMNotificationListenerAdapter domListener = new BindingDOMNotificationListenerAdapter(this.adapterContext, listener);
        ListenerRegistration domRegistration = this.domNotifService.registerNotificationListener((DOMNotificationListener)domListener, domListener.getSupportedNotifications());
        return new ListenerRegistrationImpl<T>(listener, domRegistration);
    }

    public DOMNotificationService getDomService() {
        return this.domNotifService;
    }

    private static class Builder
    extends BindingDOMAdapterBuilder<NotificationService> {
        Builder(AdapterContext adapterContext) {
            super(adapterContext);
        }

        @Override
        protected NotificationService createInstance(ClassToInstanceMap<DOMService> delegates) {
            DOMNotificationService domNotification = (DOMNotificationService)delegates.getInstance(DOMNotificationService.class);
            return new BindingDOMNotificationServiceAdapter(this.adapterContext(), domNotification);
        }

        @Override
        public Set<? extends Class<? extends DOMService>> getRequiredDelegates() {
            return ImmutableSet.of(DOMNotificationService.class);
        }
    }

    private static class ListenerRegistrationImpl<T extends NotificationListener>
    extends AbstractListenerRegistration<T> {
        private final ListenerRegistration<?> listenerRegistration;

        ListenerRegistrationImpl(T listener, ListenerRegistration<?> listenerRegistration) {
            super(listener);
            this.listenerRegistration = listenerRegistration;
        }

        protected void removeRegistration() {
            this.listenerRegistration.close();
        }
    }
}

