/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.adapter.osgi;

import java.util.Dictionary;
import java.util.Objects;
import java.util.function.Function;
import org.opendaylight.mdsal.binding.api.BindingService;
import org.opendaylight.mdsal.binding.dom.adapter.osgi.Dict;
import org.opendaylight.mdsal.dom.api.DOMService;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class AdaptingTracker<D extends DOMService, B extends BindingService>
extends ServiceTracker<D, ServiceRegistration<B>> {
    private static final Logger LOG = LoggerFactory.getLogger(AdaptingTracker.class);
    private final Function<D, B> bindingFactory;
    private final Class<B> bindingClass;

    AdaptingTracker(BundleContext ctx, Class<D> domClass, Class<B> bindingClass, Function<D, B> bindingFactory) {
        super(ctx, domClass, null);
        this.bindingClass = Objects.requireNonNull(bindingClass);
        this.bindingFactory = Objects.requireNonNull(bindingFactory);
    }

    public void open(boolean trackAllServices) {
        LOG.debug("Starting tracker for {}", (Object)this.bindingClass.getName());
        super.open(trackAllServices);
        LOG.debug("Tracker for {} started", (Object)this.bindingClass.getName());
    }

    public ServiceRegistration<B> addingService(ServiceReference<D> reference) {
        if (reference == null) {
            LOG.debug("Null reference for {}, ignoring it", (Object)this.bindingClass.getName());
            return null;
        }
        if (reference.getProperty("odl.mdsal.binding.adapter.ignore") != null) {
            LOG.debug("Ignoring reference {} due to {}", reference, (Object)"odl.mdsal.binding.adapter.ignore");
            return null;
        }
        DOMService dom = (DOMService)this.context.getService(reference);
        if (dom == null) {
            LOG.debug("Could not get {} service from {}, ignoring it", (Object)this.bindingClass.getName(), reference);
            return null;
        }
        BindingService binding = (BindingService)this.bindingFactory.apply(dom);
        Dict props = Dict.fromReference(reference);
        ServiceRegistration reg = this.context.registerService(this.bindingClass, (Object)binding, (Dictionary)props);
        LOG.debug("Registered {} adapter {} of {} with {} as {}", new Object[]{this.bindingClass.getName(), binding, dom, props, reg});
        return reg;
    }

    public void modifiedService(ServiceReference<D> reference, ServiceRegistration<B> service) {
        if (service != null && reference != null) {
            Dict newProps = Dict.fromReference(reference);
            LOG.debug("Updating service {} with properties {}", service, (Object)newProps);
            service.setProperties((Dictionary)newProps);
        }
    }

    public void removedService(ServiceReference<D> reference, ServiceRegistration<B> service) {
        if (service != null) {
            this.context.ungetService(reference);
            service.unregister();
            LOG.debug("Unregistered service {}", service);
        }
    }
}

