/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.adapter.osgi;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.opendaylight.mdsal.binding.api.ActionProviderService;
import org.opendaylight.mdsal.binding.api.ActionService;
import org.opendaylight.mdsal.binding.api.DataBroker;
import org.opendaylight.mdsal.binding.api.DataTreeService;
import org.opendaylight.mdsal.binding.api.MountPointService;
import org.opendaylight.mdsal.binding.api.NotificationPublishService;
import org.opendaylight.mdsal.binding.api.NotificationService;
import org.opendaylight.mdsal.binding.api.RpcConsumerRegistry;
import org.opendaylight.mdsal.binding.api.RpcProviderService;
import org.opendaylight.mdsal.binding.dom.adapter.osgi.AdaptingTracker;
import org.opendaylight.mdsal.binding.dom.adapter.spi.AdapterFactory;
import org.opendaylight.mdsal.dom.api.DOMActionProviderService;
import org.opendaylight.mdsal.dom.api.DOMActionService;
import org.opendaylight.mdsal.dom.api.DOMDataBroker;
import org.opendaylight.mdsal.dom.api.DOMDataTreeService;
import org.opendaylight.mdsal.dom.api.DOMMountPointService;
import org.opendaylight.mdsal.dom.api.DOMNotificationPublishService;
import org.opendaylight.mdsal.dom.api.DOMNotificationService;
import org.opendaylight.mdsal.dom.api.DOMRpcProviderService;
import org.opendaylight.mdsal.dom.api.DOMRpcService;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
public final class DynamicBindingAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(DynamicBindingAdapter.class);
    private List<AdaptingTracker<?, ?>> trackers = ImmutableList.of();
    @Reference
    AdapterFactory factory = null;

    @Activate
    void activate(BundleContext ctx) {
        this.trackers = ImmutableList.of(new AdaptingTracker<DOMDataBroker, DataBroker>(ctx, DOMDataBroker.class, DataBroker.class, this.factory::createDataBroker), new AdaptingTracker<DOMDataTreeService, DataTreeService>(ctx, DOMDataTreeService.class, DataTreeService.class, this.factory::createDataTreeService), new AdaptingTracker<DOMMountPointService, MountPointService>(ctx, DOMMountPointService.class, MountPointService.class, this.factory::createMountPointService), new AdaptingTracker<DOMNotificationService, NotificationService>(ctx, DOMNotificationService.class, NotificationService.class, this.factory::createNotificationService), new AdaptingTracker<DOMNotificationPublishService, NotificationPublishService>(ctx, DOMNotificationPublishService.class, NotificationPublishService.class, this.factory::createNotificationPublishService), new AdaptingTracker<DOMRpcService, RpcConsumerRegistry>(ctx, DOMRpcService.class, RpcConsumerRegistry.class, this.factory::createRpcConsumerRegistry), new AdaptingTracker<DOMRpcProviderService, RpcProviderService>(ctx, DOMRpcProviderService.class, RpcProviderService.class, this.factory::createRpcProviderService), new AdaptingTracker<DOMActionService, ActionService>(ctx, DOMActionService.class, ActionService.class, this.factory::createActionService), new AdaptingTracker<DOMActionProviderService, ActionProviderService>(ctx, DOMActionProviderService.class, ActionProviderService.class, this.factory::createActionProviderService));
        LOG.debug("Starting {} DOMService trackers", (Object)this.trackers.size());
        this.trackers.forEach(ServiceTracker::open);
        LOG.info("{} DOMService trackers started", (Object)this.trackers.size());
    }

    @Deactivate
    void deactivate() {
        LOG.debug("Stopping {} DOMService trackers", (Object)this.trackers.size());
        if (!this.trackers.isEmpty()) {
            this.trackers.forEach(ServiceTracker::close);
            LOG.info("{} DOMService trackers stopped", (Object)this.trackers.size());
        }
        this.trackers = ImmutableList.of();
    }
}

