/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.adapter.query;

import com.google.common.annotations.Beta;
import java.util.Objects;
import java.util.ServiceLoader;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.opendaylight.mdsal.binding.api.query.DescendantQueryBuilder;
import org.opendaylight.mdsal.binding.api.query.QueryFactory;
import org.opendaylight.mdsal.binding.dom.adapter.query.DefaultDescendantQueryBuilder;
import org.opendaylight.mdsal.binding.dom.codec.api.BindingCodecTree;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;

@Singleton
@Beta
public final class DefaultQueryFactory
implements QueryFactory {
    private final BindingCodecTree codec;

    public DefaultQueryFactory() {
        this(ServiceLoader.load(BindingCodecTree.class).findFirst().orElseThrow());
    }

    @Inject
    public DefaultQueryFactory(BindingCodecTree codec) {
        this.codec = Objects.requireNonNull(codec);
    }

    public <T extends DataObject> DescendantQueryBuilder<T> querySubtree(InstanceIdentifier<T> rootPath) {
        return new DefaultDescendantQueryBuilder(this.codec, rootPath);
    }
}

