/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.adapter.query;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.mdsal.binding.api.query.QueryExpression;
import org.opendaylight.mdsal.binding.api.query.QueryStructureException;
import org.opendaylight.mdsal.binding.dom.adapter.query.DefaultQuery;
import org.opendaylight.mdsal.binding.dom.adapter.query.LambdaDecoder;
import org.opendaylight.mdsal.binding.dom.codec.api.BindingCodecTree;
import org.opendaylight.mdsal.binding.dom.codec.api.BindingCodecTreeNode;
import org.opendaylight.mdsal.binding.dom.codec.api.BindingDataObjectCodecTreeNode;
import org.opendaylight.mdsal.binding.dom.codec.spi.BindingSchemaMapping;
import org.opendaylight.mdsal.dom.api.query.DOMQuery;
import org.opendaylight.mdsal.dom.api.query.DOMQueryPredicate;
import org.opendaylight.yangtools.concepts.Immutable;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.model.api.DataNodeContainer;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.DocumentedNode;

final class QueryBuilderState {
    private final BindingCodecTree codec;
    private final List<DOMQueryPredicate> predicates = new ArrayList<DOMQueryPredicate>();
    private final YangInstanceIdentifier root;
    private YangInstanceIdentifier absoluteSelect;
    private YangInstanceIdentifier relativeSelect;

    QueryBuilderState(BindingCodecTree codec, InstanceIdentifier<?> root) {
        this.codec = Objects.requireNonNull(codec);
        this.root = this.fromBinding(root);
    }

    void setSelectPath(@NonNull InstanceIdentifier<?> selectPath) {
        Preconditions.checkState((this.root != null ? 1 : 0) != 0, (Object)"Root path has not been set yet");
        Preconditions.checkState((this.relativeSelect == null ? 1 : 0) != 0, (String)"Select path has already been set to %s", (Object)this.relativeSelect);
        this.absoluteSelect = this.fromBinding(selectPath);
        this.relativeSelect = (YangInstanceIdentifier)this.absoluteSelect.relativeTo(this.root).orElseThrow(() -> new IllegalStateException(this.root + " is not an ancestor of " + this.absoluteSelect));
    }

    @NonNull BoundMethod bindMethod(@NonNull InstanceIdentifier<?> bindingPath, // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull MatchBuilderPath.LeafReference<?, ?> ref) {
        BindingDataObjectCodecTreeNode targetCodec = this.codec.getSubtreeCodec(bindingPath);
        Preconditions.checkState((targetCodec != null ? 1 : 0) != 0, (String)"Failed to find codec for %s", bindingPath);
        DocumentedNode.WithStatus targetSchema = targetCodec.getSchema();
        Verify.verify((boolean)(targetSchema instanceof DataNodeContainer), (String)"Unexpected target schema %s", (Object)targetSchema);
        LambdaDecoder.LambdaTarget targetLeaf = LambdaDecoder.resolveLambda(ref);
        Verify.verify((boolean)targetLeaf.targetClass.equals(bindingPath.getTargetType().getName()), (String)"Mismatched target %s and path %s", (Object)targetLeaf, bindingPath);
        DataSchemaNode child = QueryBuilderState.findChild((DataNodeContainer)targetSchema, targetLeaf.targetMethod);
        YangInstanceIdentifier absTarget = this.fromBinding(bindingPath);
        YangInstanceIdentifier relTarget = (YangInstanceIdentifier)absTarget.relativeTo(this.absoluteSelect).orElseThrow(() -> new IllegalStateException(this.absoluteSelect + " is not an ancestor of " + absTarget));
        return new BoundMethod(relTarget, targetCodec.yangPathArgumentChild((YangInstanceIdentifier.PathArgument)new YangInstanceIdentifier.NodeIdentifier(child.getQName())));
    }

    void addPredicate(DOMQueryPredicate predicate) {
        this.predicates.add(Objects.requireNonNull(predicate));
    }

    <T extends DataObject> @NonNull QueryExpression<T> buildQuery() {
        return new DefaultQuery(new DOMQuery(this.root, this.relativeSelect, this.predicates));
    }

    private @NonNull YangInstanceIdentifier fromBinding(InstanceIdentifier<?> bindingId) {
        return this.codec.getInstanceIdentifierCodec().fromBinding(bindingId);
    }

    private static DataSchemaNode findChild(DataNodeContainer parent, String methodName) {
        for (DataSchemaNode child : parent.getChildNodes()) {
            if (!methodName.equals(BindingSchemaMapping.getGetterMethodName((DataSchemaNode)child))) continue;
            return child;
        }
        throw new QueryStructureException("Failed to find schema matching " + methodName + " in " + parent);
    }

    static final class BoundMethod
    implements Immutable {
        final @NonNull YangInstanceIdentifier parentPath;
        final @NonNull BindingCodecTreeNode methodCodec;

        BoundMethod(YangInstanceIdentifier parentPath, BindingCodecTreeNode methodCodec) {
            this.parentPath = Objects.requireNonNull(parentPath);
            this.methodCodec = Objects.requireNonNull(methodCodec);
        }
    }
}

