/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.remote.rpc.registry;

import akka.actor.ActorRef;
import akka.actor.ExtendedActorSystem;
import akka.serialization.JavaSerializer;
import akka.serialization.Serialization;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.opendaylight.controller.remote.rpc.registry.AbstractRoutingTable;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.mdsal.dom.api.DOMActionInstance;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.codec.binfmt.NormalizedNodeDataInput;
import org.opendaylight.yangtools.yang.data.codec.binfmt.NormalizedNodeDataOutput;
import org.opendaylight.yangtools.yang.data.codec.binfmt.NormalizedNodeStreamVersion;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ActionRoutingTable
extends AbstractRoutingTable<ActionRoutingTable, DOMActionInstance> {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(ActionRoutingTable.class);

    ActionRoutingTable(ActorRef invoker, Collection<DOMActionInstance> actions) {
        super(invoker, actions);
    }

    ActionRoutingTable updateActions(Collection<DOMActionInstance> toAdd, Collection<DOMActionInstance> toRemove) {
        LOG.debug("Updating actions in ActionRoutingTable");
        HashSet<DOMActionInstance> newActions = new HashSet<DOMActionInstance>((Collection<DOMActionInstance>)this.getItems());
        newActions.addAll(toAdd);
        newActions.removeAll(toRemove);
        return new ActionRoutingTable(this.getInvoker(), (Collection<DOMActionInstance>)newActions);
    }

    @Override
    Object writeReplace() {
        return new Proxy(this);
    }

    private static final class Proxy
    implements Externalizable {
        private static final long serialVersionUID = 1L;
        private static final Logger LOG = LoggerFactory.getLogger(ActionRoutingTable.class);
        @SuppressFBWarnings(value={"SE_BAD_FIELD"}, justification="We deal with the field in serialization methods.")
        private Collection<DOMActionInstance> actions;
        private ActorRef opsInvoker;

        public Proxy() {
        }

        Proxy(ActionRoutingTable table) {
            this.actions = table.getItems();
            this.opsInvoker = table.getInvoker();
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            LOG.debug("serializing ActionRoutingTable.");
            out.writeObject(Serialization.serializedActorPath((ActorRef)this.opsInvoker));
            NormalizedNodeDataOutput nnout = NormalizedNodeStreamVersion.current().newDataOutput((DataOutput)out);
            nnout.writeInt(this.actions.size());
            for (DOMActionInstance id : this.actions) {
                nnout.writeSchemaPath(id.getType());
                YangInstanceIdentifier actionPath = YangInstanceIdentifier.create((YangInstanceIdentifier.PathArgument[])new YangInstanceIdentifier.PathArgument[]{new YangInstanceIdentifier.NodeIdentifier(id.getType().getLastComponent())});
                nnout.writeYangInstanceIdentifier(actionPath);
            }
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            LOG.debug("deserializing ActionRoutingTable");
            this.opsInvoker = ((ExtendedActorSystem)JavaSerializer.currentSystem().value()).provider().resolveActorRef((String)in.readObject());
            NormalizedNodeDataInput nnin = NormalizedNodeDataInput.newDataInput((DataInput)in);
            int size = nnin.readInt();
            this.actions = new ArrayList<DOMActionInstance>(size);
            for (int i = 0; i < size; ++i) {
                this.actions.add(DOMActionInstance.of((SchemaPath)nnin.readSchemaPath(), (LogicalDatastoreType)LogicalDatastoreType.OPERATIONAL, (YangInstanceIdentifier)nnin.readYangInstanceIdentifier()));
            }
        }

        private Object readResolve() {
            return new ActionRoutingTable(this.opsInvoker, this.actions);
        }
    }
}

