/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.rfc8528.data.api;

import com.google.common.annotations.Beta;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.concepts.WritableObject;
import org.opendaylight.yangtools.rfc8528.data.api.MPIv1;
import org.opendaylight.yangtools.util.AbstractIdentifier;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;

@Beta
@NonNullByDefault
public final class MountPointIdentifier
extends AbstractIdentifier<QName>
implements YangInstanceIdentifier.PathArgument,
WritableObject {
    private static final long serialVersionUID = 1L;
    private static final LoadingCache<QName, MountPointIdentifier> CACHE = CacheBuilder.newBuilder().weakValues().build((CacheLoader)new CacheLoader<QName, MountPointIdentifier>(){

        public MountPointIdentifier load(QName key) {
            return MountPointIdentifier.of(key);
        }
    });

    private MountPointIdentifier(QName qname) {
        super((Object)qname);
    }

    public static MountPointIdentifier of(QName qname) {
        return new MountPointIdentifier(qname);
    }

    public static MountPointIdentifier create(QName qname) {
        MountPointIdentifier existing = (MountPointIdentifier)((Object)CACHE.getIfPresent((Object)qname));
        return existing != null ? existing : (MountPointIdentifier)((Object)CACHE.getUnchecked((Object)qname.intern()));
    }

    public static MountPointIdentifier readFrom(DataInput in) throws IOException {
        return MountPointIdentifier.create(QName.readFrom((DataInput)in));
    }

    public QName getLabel() {
        return (QName)this.getValue();
    }

    public void writeTo(DataOutput out) throws IOException {
        ((QName)this.getValue()).writeTo(out);
    }

    private Object writeReplace() {
        return new MPIv1((QName)this.getValue());
    }

    public int compareTo(// Could not load outer class - annotation placement on inner may be incorrect
     @Nullable YangInstanceIdentifier.PathArgument o) {
        if (o instanceof YangInstanceIdentifier.AugmentationIdentifier) {
            return 1;
        }
        if (!(o instanceof MountPointIdentifier)) {
            return -1;
        }
        return ((QName)this.getValue()).compareTo(((MountPointIdentifier)o).getLabel());
    }

    public QName getNodeType() {
        return this.getLabel();
    }

    public String toRelativeString(// Could not load outer class - annotation placement on inner may be incorrect
     @Nullable YangInstanceIdentifier.PathArgument previous) {
        return this.toString();
    }
}

