/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.dom.schema.osgi.impl;

import com.google.common.annotations.Beta;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Verify;
import com.google.common.primitives.UnsignedLong;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Map;
import java.util.Objects;
import org.gaul.modernizer_maven_annotations.SuppressModernizer;
import org.opendaylight.binding.runtime.api.ModuleInfoSnapshot;
import org.opendaylight.mdsal.dom.schema.osgi.ModelGenerationAware;
import org.opendaylight.mdsal.dom.schema.osgi.OSGiModuleInfoSnapshot;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
@Component(factory="org.opendaylight.mdsal.dom.schema.osgi.impl.OSGiEffectiveModelImpl", service={OSGiModuleInfoSnapshot.class})
public final class OSGiModuleInfoSnapshotImpl
implements OSGiModuleInfoSnapshot {
    static final String FACTORY_NAME = "org.opendaylight.mdsal.dom.schema.osgi.impl.OSGiEffectiveModelImpl";
    @VisibleForTesting
    static final String GENERATION = "org.opendaylight.mdsal.dom.schema.osgi.impl.Generation";
    @VisibleForTesting
    static final String DELEGATE = "org.opendaylight.mdsal.dom.schema.osgi.impl.ModuleInfoSnapshot";
    private static final Logger LOG = LoggerFactory.getLogger(OSGiModuleInfoSnapshotImpl.class);
    private ModuleInfoSnapshot delegate;
    private UnsignedLong generation;

    @Override
    public UnsignedLong getGeneration() {
        return (UnsignedLong)Verify.verifyNotNull((Object)this.generation);
    }

    @Override
    public ModuleInfoSnapshot getService() {
        return (ModuleInfoSnapshot)Verify.verifyNotNull((Object)this.delegate);
    }

    @Activate
    void activate(Map<String, ?> properties) {
        this.generation = (UnsignedLong)Verify.verifyNotNull(properties.get(GENERATION));
        this.delegate = (ModuleInfoSnapshot)Verify.verifyNotNull(properties.get(DELEGATE));
        LOG.info("EffectiveModelContext generation {} activated", (Object)this.generation);
    }

    @Deactivate
    void deactivate() {
        this.delegate = null;
        LOG.info("EffectiveModelContext generation {} deactivated", (Object)this.generation);
    }

    @SuppressModernizer
    static Dictionary<String, ?> props(long generation, ModuleInfoSnapshot delegate) {
        Hashtable<String, Integer> ret = new Hashtable<String, Integer>(4);
        ((Dictionary)ret).put("service.ranking", ModelGenerationAware.computeServiceRanking(generation));
        ((Dictionary)ret).put(GENERATION, (Integer)UnsignedLong.fromLongBits((long)generation));
        ((Dictionary)ret).put(DELEGATE, (Integer)Objects.requireNonNull(delegate));
        return ret;
    }
}

