/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.dom.schema.osgi.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.io.Resources;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.opendaylight.mdsal.dom.schema.osgi.impl.YangModuleInfoRegistry;
import org.opendaylight.yangtools.concepts.ObjectRegistration;
import org.opendaylight.yangtools.concepts.Registration;
import org.opendaylight.yangtools.yang.binding.YangModelBindingProvider;
import org.opendaylight.yangtools.yang.binding.YangModuleInfo;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.util.tracker.BundleTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class YangModuleInfoScanner
extends BundleTracker<List<ObjectRegistration<YangModuleInfo>>> {
    private static final Logger LOG = LoggerFactory.getLogger(YangModuleInfoScanner.class);
    private static final String MODULE_INFO_PROVIDER_PATH_PREFIX = "META-INF/services/";
    private static final String YANG_MODLE_BINDING_PROVIDER_SERVICE = "META-INF/services/" + YangModelBindingProvider.class.getName();
    private final YangModuleInfoRegistry moduleInfoRegistry;

    YangModuleInfoScanner(BundleContext context, YangModuleInfoRegistry moduleInfoRegistry) {
        super(context, 60, null);
        this.moduleInfoRegistry = Objects.requireNonNull(moduleInfoRegistry);
    }

    public List<ObjectRegistration<YangModuleInfo>> addingBundle(Bundle bundle, BundleEvent event) {
        List lines;
        if (bundle.getBundleId() == 0L) {
            LOG.debug("Ignoring system bundle {}", (Object)bundle);
            return ImmutableList.of();
        }
        URL resource = bundle.getEntry(YANG_MODLE_BINDING_PROVIDER_SERVICE);
        if (resource == null) {
            LOG.debug("Bundle {} does not have an entry for {}", (Object)bundle, (Object)YANG_MODLE_BINDING_PROVIDER_SERVICE);
            return ImmutableList.of();
        }
        LOG.debug("Got addingBundle({}) with YangModelBindingProvider resource {}", (Object)bundle, (Object)resource);
        try {
            lines = Resources.readLines((URL)resource, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            LOG.error("Error while reading {} from bundle {}", new Object[]{resource, bundle, e});
            return ImmutableList.of();
        }
        if (lines.isEmpty()) {
            LOG.debug("Bundle {} has empty services for {}", (Object)bundle, (Object)YANG_MODLE_BINDING_PROVIDER_SERVICE);
            return ImmutableList.of();
        }
        ArrayList<YangModuleInfo> infos = new ArrayList<YangModuleInfo>(lines.size());
        for (String moduleInfoName : lines) {
            YangModuleInfo moduleInfo;
            LOG.trace("Retrieve ModuleInfo({}, {})", (Object)moduleInfoName, (Object)bundle);
            try {
                moduleInfo = YangModuleInfoScanner.retrieveModuleInfo(moduleInfoName, bundle);
            }
            catch (ScanningException e) {
                LOG.warn("Failed to acquire {} from bundle {}, ignoring it", new Object[]{moduleInfoName, bundle, e});
                continue;
            }
            infos.add(moduleInfo);
        }
        List<ObjectRegistration<YangModuleInfo>> registrations = this.moduleInfoRegistry.registerInfos(infos);
        LOG.trace("Bundle {} resulted in registrations {}", (Object)bundle, registrations);
        this.moduleInfoRegistry.scannerUpdate();
        return registrations;
    }

    public void modifiedBundle(Bundle bundle, BundleEvent event, List<ObjectRegistration<YangModuleInfo>> regs) {
        if (bundle.getBundleId() == 0L) {
            LOG.debug("Framework bundle {} got event {}", (Object)bundle, (Object)event.getType());
            if ((event.getType() & 0x100) != 0) {
                LOG.info("OSGi framework is being stopped, halting bundle scanning");
                this.moduleInfoRegistry.scannerShutdown();
            }
        }
    }

    public void removedBundle(Bundle bundle, BundleEvent event, List<ObjectRegistration<YangModuleInfo>> regs) {
        regs.forEach(Registration::close);
        this.moduleInfoRegistry.scannerUpdate();
    }

    private static YangModuleInfo retrieveModuleInfo(String className, Bundle bundle) throws ScanningException {
        YangModelBindingProvider instance;
        Constructor<YangModelBindingProvider> ctor;
        Class<YangModelBindingProvider> providerClass;
        Class loadedClass;
        try {
            loadedClass = bundle.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            throw new ScanningException(e, "Failed to load class %s", className);
        }
        try {
            providerClass = loadedClass.asSubclass(YangModelBindingProvider.class);
        }
        catch (ClassCastException e) {
            throw new ScanningException(e, "Failed to validate %s", loadedClass);
        }
        try {
            ctor = providerClass.getDeclaredConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new ScanningException(e, "%s does not have a no-argument constructor", providerClass);
        }
        catch (SecurityException e) {
            throw new ScanningException(e, "Failed to reflect on %s", providerClass);
        }
        try {
            instance = ctor.newInstance(new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
            throw new ScanningException(e, "Failed to instantiate %s", providerClass);
        }
        return instance.getModuleInfo();
    }

    @NonNullByDefault
    private static final class ScanningException
    extends Exception {
        private static final long serialVersionUID = 1L;

        ScanningException(Exception cause, String format, Object ... args) {
            super(String.format(format, args), cause);
        }
    }
}

