/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.entityownership;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import org.opendaylight.controller.cluster.entityownership.DistributedEntityOwnershipService;
import org.opendaylight.mdsal.eos.dom.api.DOMEntityOwnershipListener;
import org.opendaylight.mdsal.eos.dom.api.DOMEntityOwnershipListenerRegistration;
import org.opendaylight.yangtools.concepts.AbstractObjectRegistration;

class DistributedEntityOwnershipListenerRegistration
extends AbstractObjectRegistration<DOMEntityOwnershipListener>
implements DOMEntityOwnershipListenerRegistration {
    private final DistributedEntityOwnershipService service;
    private final String entityType;

    DistributedEntityOwnershipListenerRegistration(DOMEntityOwnershipListener listener, String entityType, DistributedEntityOwnershipService service) {
        super((Object)listener);
        this.entityType = Objects.requireNonNull(entityType, "entityType cannot be null");
        this.service = Objects.requireNonNull(service, "DOMEntityOwnershipListener cannot be null");
    }

    protected void removeRegistration() {
        this.service.unregisterListener(this.getEntityType(), (DOMEntityOwnershipListener)this.getInstance());
    }

    public String getEntityType() {
        return this.entityType;
    }

    protected MoreObjects.ToStringHelper addToStringAttributes(MoreObjects.ToStringHelper toStringHelper) {
        return toStringHelper.add("entityType", (Object)this.entityType);
    }
}

