/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.entityownership;

import akka.actor.ActorRef;
import akka.actor.Cancellable;
import akka.actor.Status;
import com.google.common.collect.ImmutableList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Queue;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.controller.cluster.access.concepts.ClientIdentifier;
import org.opendaylight.controller.cluster.access.concepts.FrontendIdentifier;
import org.opendaylight.controller.cluster.access.concepts.FrontendType;
import org.opendaylight.controller.cluster.access.concepts.LocalHistoryIdentifier;
import org.opendaylight.controller.cluster.access.concepts.MemberName;
import org.opendaylight.controller.cluster.access.concepts.TransactionIdentifier;
import org.opendaylight.controller.cluster.datastore.exceptions.NoShardLeaderException;
import org.opendaylight.controller.cluster.datastore.messages.BatchedModifications;
import org.opendaylight.controller.cluster.datastore.messages.CommitTransactionReply;
import org.opendaylight.controller.cluster.datastore.modification.Modification;
import org.opendaylight.controller.cluster.datastore.modification.WriteModification;
import org.opendaylight.controller.cluster.entityownership.EntityOwnersModel;
import org.opendaylight.controller.cluster.entityownership.EntityOwnershipShard;
import org.slf4j.Logger;
import scala.concurrent.ExecutionContext;
import scala.concurrent.duration.FiniteDuration;

class EntityOwnershipShardCommitCoordinator {
    private static final Object COMMIT_RETRY_MESSAGE = new Object(){

        public String toString() {
            return "entityCommitRetry";
        }
    };
    private static final FrontendType FRONTEND_TYPE = FrontendType.forName((String)"entity-ownership-internal");
    private final Queue<Modification> pendingModifications = new LinkedList<Modification>();
    private final LocalHistoryIdentifier historyId;
    private final Logger log;
    private BatchedModifications inflightCommit;
    private Cancellable retryCommitSchedule;
    private long transactionIDCounter = 0L;

    EntityOwnershipShardCommitCoordinator(MemberName localMemberName, Logger log) {
        this.log = Objects.requireNonNull(log);
        this.historyId = new LocalHistoryIdentifier(ClientIdentifier.create((FrontendIdentifier)FrontendIdentifier.create((MemberName)localMemberName, (FrontendType)FRONTEND_TYPE), (long)0L), 0L);
    }

    boolean handleMessage(Object message, EntityOwnershipShard shard) {
        boolean handled = true;
        if (CommitTransactionReply.isSerializedType((Object)message)) {
            this.inflightCommitSucceeded(shard);
        } else if (message instanceof Status.Failure) {
            this.inflightCommitFailure(((Status.Failure)message).cause(), shard);
        } else if (COMMIT_RETRY_MESSAGE.equals(message)) {
            this.retryInflightCommit(shard);
        } else {
            handled = false;
        }
        return handled;
    }

    private void retryInflightCommit(EntityOwnershipShard shard) {
        if (this.inflightCommit == null) {
            return;
        }
        if (shard.hasLeader()) {
            this.log.debug("Retrying commit for BatchedModifications {}", (Object)this.inflightCommit.getTransactionId());
            shard.tryCommitModifications(this.inflightCommit);
        } else {
            this.scheduleInflightCommitRetry(shard);
        }
    }

    void inflightCommitFailure(Throwable cause, EntityOwnershipShard shard) {
        if (this.inflightCommit == null) {
            return;
        }
        this.log.debug("Inflight BatchedModifications {} commit failed", (Object)this.inflightCommit.getTransactionId(), (Object)cause);
        if (!(cause instanceof NoShardLeaderException)) {
            this.newInflightCommitWithDifferentTransactionID();
        }
        this.scheduleInflightCommitRetry(shard);
    }

    private void scheduleInflightCommitRetry(EntityOwnershipShard shard) {
        FiniteDuration duration = shard.getDatastoreContext().getShardRaftConfig().getElectionTimeOutInterval();
        this.log.debug("Scheduling retry for BatchedModifications commit {} in {}", (Object)this.inflightCommit.getTransactionId(), (Object)duration);
        this.retryCommitSchedule = shard.getContext().system().scheduler().scheduleOnce(duration, shard.getSelf(), COMMIT_RETRY_MESSAGE, (ExecutionContext)shard.getContext().dispatcher(), ActorRef.noSender());
    }

    void inflightCommitSucceeded(EntityOwnershipShard shard) {
        if (this.inflightCommit == null) {
            return;
        }
        if (this.retryCommitSchedule != null) {
            this.retryCommitSchedule.cancel();
        }
        this.log.debug("BatchedModifications commit {} succeeded", (Object)this.inflightCommit.getTransactionId());
        this.inflightCommit = null;
        this.commitNextBatch(shard);
    }

    void commitNextBatch(EntityOwnershipShard shard) {
        if (this.inflightCommit != null || this.pendingModifications.isEmpty() || !shard.hasLeader()) {
            return;
        }
        this.inflightCommit = this.newBatchedModifications();
        Iterator iter = this.pendingModifications.iterator();
        while (iter.hasNext()) {
            this.inflightCommit.addModification((Modification)iter.next());
            iter.remove();
            if (this.inflightCommit.getModifications().size() < shard.getDatastoreContext().getShardBatchedModificationCount()) continue;
        }
        this.log.debug("Committing next BatchedModifications {}, size {}", (Object)this.inflightCommit.getTransactionId(), (Object)this.inflightCommit.getModifications().size());
        shard.tryCommitModifications(this.inflightCommit);
    }

    void commitModification(Modification modification, EntityOwnershipShard shard) {
        this.commitModifications((List<Modification>)ImmutableList.of((Object)modification), shard);
    }

    void commitModifications(List<Modification> modifications, EntityOwnershipShard shard) {
        if (modifications.isEmpty()) {
            return;
        }
        boolean hasLeader = shard.hasLeader();
        if (this.inflightCommit != null || !hasLeader) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("{} - adding modifications to pending", (Object)(this.inflightCommit != null ? "A commit is inflight" : "No shard leader"));
            }
            this.pendingModifications.addAll(modifications);
        } else {
            this.inflightCommit = this.newBatchedModifications();
            this.inflightCommit.addModifications(modifications);
            shard.tryCommitModifications(this.inflightCommit);
        }
    }

    void onStateChanged(EntityOwnershipShard shard, boolean isLeader) {
        shard.possiblyRemoveAllInitialCandidates(shard.getLeader());
        this.possiblyPrunePendingCommits(shard, isLeader);
        if (!isLeader && this.inflightCommit != null) {
            if (this.retryCommitSchedule != null) {
                this.retryCommitSchedule.cancel();
            }
            this.newInflightCommitWithDifferentTransactionID();
            this.retryInflightCommit(shard);
        } else {
            this.commitNextBatch(shard);
        }
    }

    private void possiblyPrunePendingCommits(EntityOwnershipShard shard, boolean isLeader) {
        if (shard.hasLeader() && !isLeader) {
            shard.convertPendingTransactionsToMessages();
            if (this.inflightCommit != null) {
                this.inflightCommit = this.pruneModifications(this.inflightCommit);
            }
            this.pendingModifications.removeIf(mod -> !this.canForwardModificationToNewLeader((Modification)mod));
        }
    }

    private @Nullable BatchedModifications pruneModifications(BatchedModifications toPrune) {
        BatchedModifications prunedModifications = new BatchedModifications(toPrune.getTransactionId(), toPrune.getVersion());
        prunedModifications.setDoCommitOnReady(toPrune.isDoCommitOnReady());
        if (toPrune.isReady()) {
            prunedModifications.setReady(toPrune.getParticipatingShardNames());
        }
        prunedModifications.setTotalMessagesSent(toPrune.getTotalMessagesSent());
        for (Modification mod : toPrune.getModifications()) {
            if (!this.canForwardModificationToNewLeader(mod)) continue;
            prunedModifications.addModification(mod);
        }
        return !prunedModifications.getModifications().isEmpty() ? prunedModifications : null;
    }

    private boolean canForwardModificationToNewLeader(Modification mod) {
        if (mod instanceof WriteModification) {
            boolean canForward;
            WriteModification writeMod = (WriteModification)mod;
            boolean bl = canForward = !writeMod.getPath().getLastPathArgument().getNodeType().equals((Object)EntityOwnersModel.ENTITY_OWNER_QNAME);
            if (!canForward) {
                this.log.debug("Not forwarding WRITE modification for {} to new leader", (Object)writeMod.getPath());
            }
            return canForward;
        }
        return true;
    }

    private void newInflightCommitWithDifferentTransactionID() {
        BatchedModifications newBatchedModifications = this.newBatchedModifications();
        newBatchedModifications.addModifications((Iterable)this.inflightCommit.getModifications());
        this.inflightCommit = newBatchedModifications;
    }

    private BatchedModifications newBatchedModifications() {
        BatchedModifications modifications = new BatchedModifications(new TransactionIdentifier(this.historyId, ++this.transactionIDCounter), 11);
        modifications.setDoCommitOnReady(true);
        modifications.setReady();
        modifications.setTotalMessagesSent(1);
        return modifications;
    }
}

