/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.jsr160;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.ReflectionException;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.jolokia.backend.RequestDispatcher;
import org.jolokia.backend.executor.MBeanServerExecutor;
import org.jolokia.backend.executor.NotChangedException;
import org.jolokia.config.ConfigKey;
import org.jolokia.config.Configuration;
import org.jolokia.converter.Converters;
import org.jolokia.detector.ServerHandle;
import org.jolokia.handler.JsonRequestHandler;
import org.jolokia.handler.RequestHandlerManager;
import org.jolokia.jsr160.MBeanServerExecutorRemote;
import org.jolokia.request.JmxRequest;
import org.jolokia.request.ProxyTargetConfig;
import org.jolokia.restrictor.Restrictor;

public class Jsr160RequestDispatcher
implements RequestDispatcher {
    public static final String ALLOWED_TARGETS_SYSPROP = "org.jolokia.jsr160ProxyAllowedTargets";
    public static final String ALLOWED_TARGETS_ENV = "JOLOKIA_JSR160_PROXY_ALLOWED_TARGETS";
    private final Set<String> whiteList;
    private final Set<String> blackList;
    private RequestHandlerManager requestHandlerManager;

    public Jsr160RequestDispatcher(Converters pConverters, ServerHandle pServerInfo, Restrictor pRestrictor, Configuration pConfig) {
        this.requestHandlerManager = new RequestHandlerManager(pConverters, pServerInfo, pRestrictor);
        this.whiteList = this.extractWhiteList(pConfig);
        this.blackList = this.extractBlackList(pConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object dispatchRequest(JmxRequest pJmxReq) throws InstanceNotFoundException, AttributeNotFoundException, ReflectionException, MBeanException, IOException, NotChangedException {
        JsonRequestHandler handler = this.requestHandlerManager.getRequestHandler(pJmxReq.getType());
        JMXConnector connector = null;
        try {
            connector = this.createConnector(pJmxReq);
            connector.connect();
            MBeanServerConnection connection = connector.getMBeanServerConnection();
            if (handler.handleAllServersAtOnce(pJmxReq)) {
                MBeanServerExecutorRemote manager = new MBeanServerExecutorRemote(connection);
                Object object = handler.handleRequest((MBeanServerExecutor)manager, pJmxReq);
                return object;
            }
            Object object = handler.handleRequest(connection, pJmxReq);
            return object;
        }
        finally {
            this.releaseConnector(connector);
        }
    }

    private JMXConnector createConnector(JmxRequest pJmxReq) throws IOException {
        ProxyTargetConfig targetConfig = pJmxReq.getTargetConfig();
        if (targetConfig == null) {
            throw new IllegalArgumentException("No proxy configuration in request " + pJmxReq);
        }
        String urlS = targetConfig.getUrl();
        if (!this.acceptTargetUrl(urlS)) {
            throw new SecurityException(String.format("Target URL %s is not allowed by configuration", urlS));
        }
        JMXServiceURL url = new JMXServiceURL(urlS);
        Map<String, Object> env = this.prepareEnv(targetConfig.getEnv());
        return JMXConnectorFactory.newJMXConnector(url, env);
    }

    private void releaseConnector(JMXConnector pConnector) throws IOException {
        if (pConnector != null) {
            pConnector.close();
        }
    }

    protected Map<String, Object> prepareEnv(Map<String, String> pTargetConfig) {
        if (pTargetConfig == null || pTargetConfig.size() == 0) {
            return null;
        }
        HashMap<String, Object> ret = new HashMap<String, Object>(pTargetConfig);
        String user = (String)ret.remove("user");
        String password = (String)ret.remove("password");
        if (user != null && password != null) {
            ret.put("java.naming.security.principal", user);
            ret.put("java.naming.security.credentials", password);
            ret.put("jmx.remote.credentials", new String[]{user, password});
        }
        return ret;
    }

    public boolean canHandle(JmxRequest pJmxRequest) {
        return pJmxRequest.getTargetConfig() != null;
    }

    public boolean useReturnValueWithPath(JmxRequest pJmxRequest) {
        JsonRequestHandler handler = this.requestHandlerManager.getRequestHandler(pJmxRequest.getType());
        return handler.useReturnValueWithPath();
    }

    private boolean acceptTargetUrl(String urlS) {
        if (this.whiteList != null) {
            return this.checkPattern(this.whiteList, urlS, true);
        }
        if (this.blackList != null) {
            return this.checkPattern(this.blackList, urlS, false);
        }
        return true;
    }

    private boolean checkPattern(Set<String> patterns, String urlS, boolean isPositive) {
        for (String pattern : patterns) {
            if (!Pattern.compile(pattern).matcher(urlS).matches()) continue;
            return isPositive;
        }
        return !isPositive;
    }

    private Set<String> extractWhiteList(Configuration pConfig) {
        return this.extractFrom(pConfig != null ? pConfig.get(ConfigKey.JSR160_PROXY_ALLOWED_TARGETS) : null, System.getProperty(ALLOWED_TARGETS_SYSPROP), System.getenv(ALLOWED_TARGETS_ENV));
    }

    private Set<String> extractFrom(String ... paths) {
        HashSet<String> ret = new HashSet<String>();
        for (String path : paths) {
            if (path == null) continue;
            ret.addAll(this.readPatterns(path));
        }
        return ret.size() > 0 ? ret : null;
    }

    private List<? extends String> readPatterns(String pPath) {
        BufferedReader reader = null;
        ArrayList<String> ret = new ArrayList<String>();
        Pattern commentPattern = Pattern.compile("^\\s*#.*$");
        try {
            reader = new BufferedReader(new FileReader(pPath));
            String line = reader.readLine();
            while (line != null) {
                if (!commentPattern.matcher(line).matches()) {
                    ret.add(line);
                }
                line = reader.readLine();
            }
            ArrayList<String> arrayList = ret;
            return arrayList;
        }
        catch (FileNotFoundException e) {
            throw new IllegalArgumentException(String.format("No such pattern file %s", pPath));
        }
        catch (IOException e) {
            throw new IllegalStateException(String.format("Error while reading pattern file %s: %s", pPath, e.getMessage()));
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private Set<String> extractBlackList(Configuration pConfig) {
        return Collections.singleton("service:jmx:rmi:///jndi/ldap:.*");
    }
}

