/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.raft;

import akka.actor.ActorRef;
import akka.actor.PoisonPill;
import akka.actor.Props;
import akka.actor.ReceiveTimeout;
import akka.actor.Status;
import akka.actor.UntypedAbstractActor;
import java.util.Objects;
import java.util.concurrent.TimeoutException;
import org.opendaylight.controller.cluster.raft.ElectionTerm;
import org.opendaylight.controller.cluster.raft.base.messages.CaptureSnapshot;
import org.opendaylight.controller.cluster.raft.base.messages.CaptureSnapshotReply;
import org.opendaylight.controller.cluster.raft.client.messages.GetSnapshotReply;
import org.opendaylight.controller.cluster.raft.persisted.ServerConfigurationPayload;
import org.opendaylight.controller.cluster.raft.persisted.Snapshot;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;

class GetSnapshotReplyActor
extends UntypedAbstractActor {
    private static final Logger LOG = LoggerFactory.getLogger(GetSnapshotReplyActor.class);
    private final Params params;

    GetSnapshotReplyActor(Params params) {
        this.params = params;
        this.getContext().setReceiveTimeout((Duration)params.receiveTimeout);
    }

    public void onReceive(Object message) {
        if (message instanceof CaptureSnapshotReply) {
            Snapshot snapshot = Snapshot.create(((CaptureSnapshotReply)message).getSnapshotState(), this.params.captureSnapshot.getUnAppliedEntries(), this.params.captureSnapshot.getLastIndex(), this.params.captureSnapshot.getLastTerm(), this.params.captureSnapshot.getLastAppliedIndex(), this.params.captureSnapshot.getLastAppliedTerm(), this.params.electionTerm.getCurrentTerm(), this.params.electionTerm.getVotedFor(), this.params.peerInformation);
            LOG.debug("{}: Received CaptureSnapshotReply, sending {}", (Object)this.params.id, (Object)snapshot);
            this.params.replyToActor.tell((Object)new GetSnapshotReply(this.params.id, snapshot), this.getSelf());
            this.getSelf().tell((Object)PoisonPill.getInstance(), this.getSelf());
        } else if (message instanceof ReceiveTimeout) {
            LOG.warn("{}: Got ReceiveTimeout for inactivity - did not receive CaptureSnapshotReply within {} ms", (Object)this.params.id, (Object)this.params.receiveTimeout.toMillis());
            this.params.replyToActor.tell((Object)new Status.Failure((Throwable)new TimeoutException(String.format("Timed out after %d ms while waiting for CaptureSnapshotReply", this.params.receiveTimeout.toMillis()))), this.getSelf());
            this.getSelf().tell((Object)PoisonPill.getInstance(), this.getSelf());
        }
    }

    public static Props props(CaptureSnapshot captureSnapshot, ElectionTerm electionTerm, ActorRef replyToActor, FiniteDuration receiveTimeout, String id, ServerConfigurationPayload updatedPeerInfo) {
        return Props.create(GetSnapshotReplyActor.class, (Object[])new Object[]{new Params(captureSnapshot, electionTerm, replyToActor, receiveTimeout, id, updatedPeerInfo)});
    }

    private static final class Params {
        final CaptureSnapshot captureSnapshot;
        final ActorRef replyToActor;
        final ElectionTerm electionTerm;
        final FiniteDuration receiveTimeout;
        final String id;
        final ServerConfigurationPayload peerInformation;

        Params(CaptureSnapshot captureSnapshot, ElectionTerm electionTerm, ActorRef replyToActor, FiniteDuration receiveTimeout, String id, ServerConfigurationPayload peerInfo) {
            this.captureSnapshot = Objects.requireNonNull(captureSnapshot);
            this.electionTerm = Objects.requireNonNull(electionTerm);
            this.replyToActor = Objects.requireNonNull(replyToActor);
            this.receiveTimeout = Objects.requireNonNull(receiveTimeout);
            this.id = Objects.requireNonNull(id);
            this.peerInformation = peerInfo;
        }
    }
}

