/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.raft;

import akka.persistence.SnapshotSelectionCriteria;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.io.ByteSource;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.controller.cluster.io.FileBackedOutputStream;
import org.opendaylight.controller.cluster.raft.NoopRaftActorSnapshotCohort;
import org.opendaylight.controller.cluster.raft.RaftActorContext;
import org.opendaylight.controller.cluster.raft.RaftActorSnapshotCohort;
import org.opendaylight.controller.cluster.raft.ReplicatedLog;
import org.opendaylight.controller.cluster.raft.ReplicatedLogEntry;
import org.opendaylight.controller.cluster.raft.ReplicatedLogImpl;
import org.opendaylight.controller.cluster.raft.SnapshotState;
import org.opendaylight.controller.cluster.raft.base.messages.ApplySnapshot;
import org.opendaylight.controller.cluster.raft.base.messages.CaptureSnapshot;
import org.opendaylight.controller.cluster.raft.base.messages.SendInstallSnapshot;
import org.opendaylight.controller.cluster.raft.base.messages.SnapshotComplete;
import org.opendaylight.controller.cluster.raft.behaviors.RaftActorBehavior;
import org.opendaylight.controller.cluster.raft.persisted.EmptyState;
import org.opendaylight.controller.cluster.raft.persisted.Snapshot;
import org.slf4j.Logger;
import scala.Long;

public class SnapshotManager
implements SnapshotState {
    private final SnapshotState IDLE = new Idle();
    private final SnapshotState PERSISTING = new Persisting();
    private final SnapshotState CREATING = new Creating();
    private final Logger log;
    private final RaftActorContext context;
    private final LastAppliedTermInformationReader lastAppliedTermInformationReader = new LastAppliedTermInformationReader();
    private final ReplicatedToAllTermInformationReader replicatedToAllTermInformationReader = new ReplicatedToAllTermInformationReader();
    private SnapshotState currentState = this.IDLE;
    private CaptureSnapshot captureSnapshot;
    private long lastSequenceNumber = -1L;
    private Consumer<Optional<OutputStream>> createSnapshotProcedure = null;
    private ApplySnapshot applySnapshot;
    private RaftActorSnapshotCohort snapshotCohort = NoopRaftActorSnapshotCohort.INSTANCE;

    public SnapshotManager(RaftActorContext context, Logger logger) {
        this.context = context;
        this.log = logger;
    }

    public boolean isApplying() {
        return this.applySnapshot != null;
    }

    @Override
    public boolean isCapturing() {
        return this.currentState.isCapturing();
    }

    @Override
    public boolean captureToInstall(ReplicatedLogEntry lastLogEntry, long replicatedToAllIndex, String targetFollower) {
        return this.currentState.captureToInstall(lastLogEntry, replicatedToAllIndex, targetFollower);
    }

    @Override
    public boolean capture(ReplicatedLogEntry lastLogEntry, long replicatedToAllIndex) {
        return this.currentState.capture(lastLogEntry, replicatedToAllIndex);
    }

    @Override
    public void apply(ApplySnapshot snapshot) {
        this.currentState.apply(snapshot);
    }

    @Override
    public void persist(Snapshot.State state, Optional<OutputStream> installSnapshotStream, long totalMemory) {
        this.currentState.persist(state, installSnapshotStream, totalMemory);
    }

    @Override
    public void commit(long sequenceNumber, long timeStamp) {
        this.currentState.commit(sequenceNumber, timeStamp);
    }

    @Override
    public void rollback() {
        this.currentState.rollback();
    }

    @Override
    public long trimLog(long desiredTrimIndex) {
        return this.currentState.trimLog(desiredTrimIndex);
    }

    void setCreateSnapshotConsumer(Consumer<Optional<OutputStream>> createSnapshotProcedure) {
        this.createSnapshotProcedure = createSnapshotProcedure;
    }

    void setSnapshotCohort(RaftActorSnapshotCohort snapshotCohort) {
        this.snapshotCohort = snapshotCohort;
    }

    public @NonNull Snapshot.State convertSnapshot(ByteSource snapshotBytes) throws IOException {
        return this.snapshotCohort.deserializeSnapshot(snapshotBytes);
    }

    public long getLastSequenceNumber() {
        return this.lastSequenceNumber;
    }

    @VisibleForTesting
    public CaptureSnapshot getCaptureSnapshot() {
        return this.captureSnapshot;
    }

    private boolean hasFollowers() {
        return this.context.hasFollowers();
    }

    private String persistenceId() {
        return this.context.getId();
    }

    public CaptureSnapshot newCaptureSnapshot(ReplicatedLogEntry lastLogEntry, long replicatedToAllIndex) {
        long lastLogEntryTerm;
        long lastLogEntryIndex;
        LastAppliedTermInformationReader lastAppliedTermInfoReader = this.lastAppliedTermInformationReader.init(this.context.getReplicatedLog(), this.context.getLastApplied(), lastLogEntry, this.hasFollowers());
        long lastAppliedIndex = lastAppliedTermInfoReader.getIndex();
        long lastAppliedTerm = lastAppliedTermInfoReader.getTerm();
        ReplicatedToAllTermInformationReader replicatedToAllTermInfoReader = this.replicatedToAllTermInformationReader.init(this.context.getReplicatedLog(), replicatedToAllIndex);
        long newReplicatedToAllIndex = replicatedToAllTermInfoReader.getIndex();
        long newReplicatedToAllTerm = replicatedToAllTermInfoReader.getTerm();
        List<ReplicatedLogEntry> unAppliedEntries = this.context.getReplicatedLog().getFrom(lastAppliedIndex + 1L);
        if (lastLogEntry == null) {
            lastAppliedIndex = lastLogEntryIndex = this.context.getReplicatedLog().getSnapshotIndex();
            lastAppliedTerm = lastLogEntryTerm = this.context.getReplicatedLog().getSnapshotTerm();
            this.log.debug("{}: Capturing Snapshot : lastLogEntry is null. Using snapshot values lastAppliedIndex {} and lastAppliedTerm {} instead.", new Object[]{this.persistenceId(), lastAppliedIndex, lastAppliedTerm});
        } else {
            lastLogEntryIndex = lastLogEntry.getIndex();
            lastLogEntryTerm = lastLogEntry.getTerm();
        }
        return new CaptureSnapshot(lastLogEntryIndex, lastLogEntryTerm, lastAppliedIndex, lastAppliedTerm, newReplicatedToAllIndex, newReplicatedToAllTerm, unAppliedEntries);
    }

    private static class ReplicatedToAllTermInformationReader
    implements TermInformationReader {
        private long index;
        private long term;

        private ReplicatedToAllTermInformationReader() {
        }

        ReplicatedToAllTermInformationReader init(ReplicatedLog log, long originalIndex) {
            ReplicatedLogEntry entry = log.get(originalIndex);
            this.index = -1L;
            this.term = -1L;
            if (entry != null) {
                this.index = entry.getIndex();
                this.term = entry.getTerm();
            }
            return this;
        }

        @Override
        public long getIndex() {
            return this.index;
        }

        @Override
        public long getTerm() {
            return this.term;
        }
    }

    static class LastAppliedTermInformationReader
    implements TermInformationReader {
        private long index;
        private long term;

        LastAppliedTermInformationReader() {
        }

        LastAppliedTermInformationReader init(ReplicatedLog log, long originalIndex, ReplicatedLogEntry lastLogEntry, boolean hasFollowers) {
            ReplicatedLogEntry entry = log.get(originalIndex);
            this.index = -1L;
            this.term = -1L;
            if (!hasFollowers) {
                if (lastLogEntry != null) {
                    this.index = lastLogEntry.getIndex();
                    this.term = lastLogEntry.getTerm();
                }
            } else if (entry != null) {
                this.index = entry.getIndex();
                this.term = entry.getTerm();
            } else if (log.getSnapshotIndex() > -1L) {
                this.index = log.getSnapshotIndex();
                this.term = log.getSnapshotTerm();
            }
            return this;
        }

        @Override
        public long getIndex() {
            return this.index;
        }

        @Override
        public long getTerm() {
            return this.term;
        }
    }

    private static interface TermInformationReader {
        public long getIndex();

        public long getTerm();
    }

    private class Persisting
    extends AbstractSnapshotState {
        private Persisting() {
        }

        @Override
        public void commit(long sequenceNumber, long timeStamp) {
            SnapshotManager.this.log.debug("{}: Snapshot success -  sequence number: {}", (Object)SnapshotManager.this.persistenceId(), (Object)sequenceNumber);
            if (SnapshotManager.this.applySnapshot != null) {
                try {
                    Snapshot snapshot = SnapshotManager.this.applySnapshot.getSnapshot();
                    SnapshotManager.this.context.setReplicatedLog(ReplicatedLogImpl.newInstance(snapshot, SnapshotManager.this.context));
                    SnapshotManager.this.context.setLastApplied(snapshot.getLastAppliedIndex());
                    SnapshotManager.this.context.setCommitIndex(snapshot.getLastAppliedIndex());
                    SnapshotManager.this.context.getTermInformation().update(snapshot.getElectionTerm(), snapshot.getElectionVotedFor());
                    if (snapshot.getServerConfiguration() != null) {
                        SnapshotManager.this.context.updatePeerIds(snapshot.getServerConfiguration());
                    }
                    if (!(snapshot.getState() instanceof EmptyState)) {
                        SnapshotManager.this.snapshotCohort.applySnapshot(snapshot.getState());
                    }
                    SnapshotManager.this.applySnapshot.getCallback().onSuccess();
                }
                catch (Exception e) {
                    SnapshotManager.this.log.error("{}: Error applying snapshot", (Object)SnapshotManager.this.context.getId(), (Object)e);
                }
            } else {
                SnapshotManager.this.context.getReplicatedLog().snapshotCommit();
            }
            SnapshotManager.this.context.getPersistenceProvider().deleteSnapshots(new SnapshotSelectionCriteria(Long.MaxValue(), timeStamp - 1L, 0L, 0L));
            SnapshotManager.this.context.getPersistenceProvider().deleteMessages(SnapshotManager.this.lastSequenceNumber);
            this.snapshotComplete();
        }

        @Override
        public void rollback() {
            if (SnapshotManager.this.applySnapshot == null) {
                SnapshotManager.this.context.getReplicatedLog().snapshotRollback();
                SnapshotManager.this.log.info("{}: Replicated Log rolled back. Snapshot will be attempted in the next cycle.snapshotIndex:{}, snapshotTerm:{}, log-size:{}", new Object[]{SnapshotManager.this.persistenceId(), SnapshotManager.this.context.getReplicatedLog().getSnapshotIndex(), SnapshotManager.this.context.getReplicatedLog().getSnapshotTerm(), SnapshotManager.this.context.getReplicatedLog().size()});
            } else {
                SnapshotManager.this.applySnapshot.getCallback().onFailure();
            }
            this.snapshotComplete();
        }

        private void snapshotComplete() {
            SnapshotManager.this.lastSequenceNumber = -1L;
            SnapshotManager.this.applySnapshot = null;
            SnapshotManager.this.currentState = SnapshotManager.this.IDLE;
            SnapshotManager.this.context.getActor().tell((Object)SnapshotComplete.INSTANCE, SnapshotManager.this.context.getActor());
        }

        public String toString() {
            return "Persisting";
        }
    }

    private class Creating
    extends AbstractSnapshotState {
        private Creating() {
        }

        @Override
        public void persist(Snapshot.State snapshotState, Optional<OutputStream> installSnapshotStream, long totalMemory) {
            Snapshot snapshot = Snapshot.create(snapshotState, SnapshotManager.this.captureSnapshot.getUnAppliedEntries(), SnapshotManager.this.captureSnapshot.getLastIndex(), SnapshotManager.this.captureSnapshot.getLastTerm(), SnapshotManager.this.captureSnapshot.getLastAppliedIndex(), SnapshotManager.this.captureSnapshot.getLastAppliedTerm(), SnapshotManager.this.context.getTermInformation().getCurrentTerm(), SnapshotManager.this.context.getTermInformation().getVotedFor(), SnapshotManager.this.context.getPeerServerInfo(true));
            SnapshotManager.this.context.getPersistenceProvider().saveSnapshot((Object)snapshot);
            SnapshotManager.this.log.info("{}: Persisting of snapshot done: {}", (Object)SnapshotManager.this.persistenceId(), (Object)snapshot);
            long dataThreshold = totalMemory * (long)SnapshotManager.this.context.getConfigParams().getSnapshotDataThresholdPercentage() / 100L;
            boolean dataSizeThresholdExceeded = (long)SnapshotManager.this.context.getReplicatedLog().dataSize() > dataThreshold;
            boolean logSizeExceededSnapshotBatchCount = SnapshotManager.this.context.getReplicatedLog().size() >= SnapshotManager.this.context.getConfigParams().getSnapshotBatchCount();
            RaftActorBehavior currentBehavior = SnapshotManager.this.context.getCurrentBehavior();
            if (dataSizeThresholdExceeded || logSizeExceededSnapshotBatchCount) {
                if (SnapshotManager.this.log.isDebugEnabled()) {
                    if (dataSizeThresholdExceeded) {
                        SnapshotManager.this.log.debug("{}: log data size {} exceeds the memory threshold {} - doing snapshotPreCommit with index {}", new Object[]{SnapshotManager.this.context.getId(), SnapshotManager.this.context.getReplicatedLog().dataSize(), dataThreshold, SnapshotManager.this.captureSnapshot.getLastAppliedIndex()});
                    } else {
                        SnapshotManager.this.log.debug("{}: log size {} exceeds the snapshot batch count {} - doing snapshotPreCommit with index {}", new Object[]{SnapshotManager.this.context.getId(), SnapshotManager.this.context.getReplicatedLog().size(), SnapshotManager.this.context.getConfigParams().getSnapshotBatchCount(), SnapshotManager.this.captureSnapshot.getLastAppliedIndex()});
                    }
                }
                SnapshotManager.this.context.getReplicatedLog().snapshotPreCommit(SnapshotManager.this.captureSnapshot.getLastAppliedIndex(), SnapshotManager.this.captureSnapshot.getLastAppliedTerm());
                if (SnapshotManager.this.captureSnapshot.getReplicatedToAllIndex() >= 0L) {
                    currentBehavior.setReplicatedToAllIndex(SnapshotManager.this.captureSnapshot.getReplicatedToAllIndex());
                }
            } else if (SnapshotManager.this.captureSnapshot.getReplicatedToAllIndex() != -1L) {
                SnapshotManager.this.context.getReplicatedLog().snapshotPreCommit(SnapshotManager.this.captureSnapshot.getReplicatedToAllIndex(), SnapshotManager.this.captureSnapshot.getReplicatedToAllTerm());
                currentBehavior.setReplicatedToAllIndex(SnapshotManager.this.captureSnapshot.getReplicatedToAllIndex());
            } else {
                SnapshotManager.this.context.getReplicatedLog().snapshotPreCommit(SnapshotManager.this.context.getReplicatedLog().getSnapshotIndex(), SnapshotManager.this.context.getReplicatedLog().getSnapshotTerm());
            }
            SnapshotManager.this.log.info("{}: Removed in-memory snapshotted entries, adjusted snaphsotIndex: {} and term: {}", new Object[]{SnapshotManager.this.context.getId(), SnapshotManager.this.context.getReplicatedLog().getSnapshotIndex(), SnapshotManager.this.context.getReplicatedLog().getSnapshotTerm()});
            if (installSnapshotStream.isPresent()) {
                if (SnapshotManager.this.context.getId().equals(currentBehavior.getLeaderId())) {
                    try {
                        ByteSource snapshotBytes = ((FileBackedOutputStream)installSnapshotStream.get()).asByteSource();
                        currentBehavior.handleMessage(SnapshotManager.this.context.getActor(), new SendInstallSnapshot(snapshot, snapshotBytes));
                    }
                    catch (IOException e) {
                        SnapshotManager.this.log.error("{}: Snapshot install failed due to an unrecoverable streaming error", (Object)SnapshotManager.this.context.getId(), (Object)e);
                    }
                } else {
                    ((FileBackedOutputStream)installSnapshotStream.get()).cleanup();
                }
            }
            SnapshotManager.this.captureSnapshot = null;
            SnapshotManager.this.currentState = SnapshotManager.this.PERSISTING;
        }

        public String toString() {
            return "Creating";
        }
    }

    private class Idle
    extends AbstractSnapshotState {
        private Idle() {
        }

        @Override
        public boolean isCapturing() {
            return false;
        }

        private boolean capture(ReplicatedLogEntry lastLogEntry, long replicatedToAllIndex, String targetFollower) {
            SnapshotManager.this.captureSnapshot = SnapshotManager.this.newCaptureSnapshot(lastLogEntry, replicatedToAllIndex);
            FileBackedOutputStream installSnapshotStream = null;
            if (targetFollower != null) {
                installSnapshotStream = SnapshotManager.this.context.getFileBackedOutputStreamFactory().newInstance();
                SnapshotManager.this.log.info("{}: Initiating snapshot capture {} to install on {}", new Object[]{SnapshotManager.this.persistenceId(), SnapshotManager.this.captureSnapshot, targetFollower});
            } else {
                SnapshotManager.this.log.info("{}: Initiating snapshot capture {}", (Object)SnapshotManager.this.persistenceId(), (Object)SnapshotManager.this.captureSnapshot);
            }
            SnapshotManager.this.lastSequenceNumber = SnapshotManager.this.context.getPersistenceProvider().getLastSequenceNumber();
            SnapshotManager.this.log.debug("{}: lastSequenceNumber prior to capture: {}", (Object)SnapshotManager.this.persistenceId(), (Object)SnapshotManager.this.lastSequenceNumber);
            SnapshotManager.this.currentState = SnapshotManager.this.CREATING;
            try {
                SnapshotManager.this.createSnapshotProcedure.accept(Optional.ofNullable(installSnapshotStream));
            }
            catch (Exception e) {
                SnapshotManager.this.currentState = SnapshotManager.this.IDLE;
                SnapshotManager.this.log.error("Error creating snapshot", (Throwable)e);
                return false;
            }
            return true;
        }

        @Override
        public boolean capture(ReplicatedLogEntry lastLogEntry, long replicatedToAllIndex) {
            return this.capture(lastLogEntry, replicatedToAllIndex, null);
        }

        @Override
        public boolean captureToInstall(ReplicatedLogEntry lastLogEntry, long replicatedToAllIndex, String targetFollower) {
            return this.capture(lastLogEntry, replicatedToAllIndex, targetFollower);
        }

        @Override
        public void apply(ApplySnapshot toApply) {
            SnapshotManager.this.applySnapshot = toApply;
            SnapshotManager.this.lastSequenceNumber = SnapshotManager.this.context.getPersistenceProvider().getLastSequenceNumber();
            SnapshotManager.this.log.debug("lastSequenceNumber prior to persisting applied snapshot: {}", (Object)SnapshotManager.this.lastSequenceNumber);
            SnapshotManager.this.context.getPersistenceProvider().saveSnapshot((Object)toApply.getSnapshot());
            SnapshotManager.this.currentState = SnapshotManager.this.PERSISTING;
        }

        public String toString() {
            return "Idle";
        }

        @Override
        public long trimLog(long desiredTrimIndex) {
            return this.doTrimLog(desiredTrimIndex);
        }
    }

    private class AbstractSnapshotState
    implements SnapshotState {
        private AbstractSnapshotState() {
        }

        @Override
        public boolean isCapturing() {
            return true;
        }

        @Override
        public boolean capture(ReplicatedLogEntry lastLogEntry, long replicatedToAllIndex) {
            SnapshotManager.this.log.debug("capture should not be called in state {}", (Object)this);
            return false;
        }

        @Override
        public boolean captureToInstall(ReplicatedLogEntry lastLogEntry, long replicatedToAllIndex, String targetFollower) {
            SnapshotManager.this.log.debug("captureToInstall should not be called in state {}", (Object)this);
            return false;
        }

        @Override
        public void apply(ApplySnapshot snapshot) {
            SnapshotManager.this.log.debug("apply should not be called in state {}", (Object)this);
        }

        @Override
        public void persist(Snapshot.State state, Optional<OutputStream> installSnapshotStream, long totalMemory) {
            SnapshotManager.this.log.debug("persist should not be called in state {}", (Object)this);
        }

        @Override
        public void commit(long sequenceNumber, long timeStamp) {
            SnapshotManager.this.log.debug("commit should not be called in state {}", (Object)this);
        }

        @Override
        public void rollback() {
            SnapshotManager.this.log.debug("rollback should not be called in state {}", (Object)this);
        }

        @Override
        public long trimLog(long desiredTrimIndex) {
            SnapshotManager.this.log.debug("trimLog should not be called in state {}", (Object)this);
            return -1L;
        }

        protected long doTrimLog(long desiredTrimIndex) {
            long lastApplied = SnapshotManager.this.context.getLastApplied();
            long tempMin = Math.min(desiredTrimIndex, lastApplied > -1L ? lastApplied - 1L : -1L);
            if (SnapshotManager.this.log.isTraceEnabled()) {
                SnapshotManager.this.log.trace("{}: performSnapshotWithoutCapture: desiredTrimIndex: {}, lastApplied: {}, tempMin: {}", new Object[]{SnapshotManager.this.persistenceId(), desiredTrimIndex, lastApplied, tempMin});
            }
            if (tempMin > -1L && SnapshotManager.this.context.getReplicatedLog().isPresent(tempMin)) {
                SnapshotManager.this.log.debug("{}: fakeSnapshot purging log to {} for term {}", new Object[]{SnapshotManager.this.persistenceId(), tempMin, SnapshotManager.this.context.getTermInformation().getCurrentTerm()});
                ReplicatedLogEntry entry = SnapshotManager.this.context.getReplicatedLog().get(tempMin);
                SnapshotManager.this.context.getReplicatedLog().snapshotPreCommit(tempMin, entry.getTerm());
                SnapshotManager.this.context.getReplicatedLog().snapshotCommit();
                return tempMin;
            }
            RaftActorBehavior currentBehavior = SnapshotManager.this.context.getCurrentBehavior();
            if (tempMin > currentBehavior.getReplicatedToAllIndex()) {
                currentBehavior.setReplicatedToAllIndex(tempMin);
            }
            return -1L;
        }
    }
}

