/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.raft;

import akka.actor.Cancellable;
import java.util.Objects;
import org.opendaylight.controller.cluster.raft.RaftActor;
import scala.concurrent.ExecutionContext;
import scala.concurrent.duration.FiniteDuration;

abstract class TimedRunnable
implements Runnable {
    private final Cancellable cancelTimer;
    private boolean canRun = true;

    TimedRunnable(FiniteDuration timeout, RaftActor actor) {
        this.cancelTimer = Objects.requireNonNull(actor).getContext().system().scheduler().scheduleOnce(Objects.requireNonNull(timeout), actor.self(), this::cancel, (ExecutionContext)actor.getContext().system().dispatcher(), actor.self());
    }

    @Override
    public void run() {
        if (this.canRun) {
            this.canRun = false;
            this.cancelTimer.cancel();
            this.doRun();
        }
    }

    private void cancel() {
        this.canRun = false;
        this.doCancel();
    }

    protected abstract void doRun();

    protected abstract void doCancel();
}

