/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.raft.base.messages;

import akka.dispatch.ControlMessage;
import java.util.Collections;
import java.util.List;
import org.opendaylight.controller.cluster.raft.ReplicatedLogEntry;

public class CaptureSnapshot
implements ControlMessage {
    private final long lastAppliedIndex;
    private final long lastAppliedTerm;
    private final long lastIndex;
    private final long lastTerm;
    private final long replicatedToAllIndex;
    private final long replicatedToAllTerm;
    private final List<ReplicatedLogEntry> unAppliedEntries;

    public CaptureSnapshot(long lastIndex, long lastTerm, long lastAppliedIndex, long lastAppliedTerm, long replicatedToAllIndex, long replicatedToAllTerm, List<ReplicatedLogEntry> unAppliedEntries) {
        this.lastIndex = lastIndex;
        this.lastTerm = lastTerm;
        this.lastAppliedIndex = lastAppliedIndex;
        this.lastAppliedTerm = lastAppliedTerm;
        this.replicatedToAllIndex = replicatedToAllIndex;
        this.replicatedToAllTerm = replicatedToAllTerm;
        this.unAppliedEntries = unAppliedEntries != null ? unAppliedEntries : Collections.emptyList();
    }

    public long getLastAppliedIndex() {
        return this.lastAppliedIndex;
    }

    public long getLastAppliedTerm() {
        return this.lastAppliedTerm;
    }

    public long getLastIndex() {
        return this.lastIndex;
    }

    public long getLastTerm() {
        return this.lastTerm;
    }

    public long getReplicatedToAllIndex() {
        return this.replicatedToAllIndex;
    }

    public long getReplicatedToAllTerm() {
        return this.replicatedToAllTerm;
    }

    public List<ReplicatedLogEntry> getUnAppliedEntries() {
        return this.unAppliedEntries;
    }

    public String toString() {
        return "CaptureSnapshot [lastAppliedIndex=" + this.lastAppliedIndex + ", lastAppliedTerm=" + this.lastAppliedTerm + ", lastIndex=" + this.lastIndex + ", lastTerm=" + this.lastTerm + ", installSnapshotInitiated=, replicatedToAllIndex=" + this.replicatedToAllIndex + ", replicatedToAllTerm=" + this.replicatedToAllTerm + ", unAppliedEntries size=" + this.unAppliedEntries.size() + "]";
    }
}

