/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.raft.client.messages;

import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.controller.cluster.raft.client.messages.FollowerInfo;

public class OnDemandRaftState {
    private long lastLogIndex = -1L;
    private long lastLogTerm = -1L;
    private long currentTerm = -1L;
    private long commitIndex = -1L;
    private long lastApplied = -1L;
    private long lastIndex = -1L;
    private long lastTerm = -1L;
    private long snapshotIndex = -1L;
    private long snapshotTerm = -1L;
    private long replicatedToAllIndex = -1L;
    private long inMemoryJournalDataSize;
    private long inMemoryJournalLogSize;
    private String leader;
    private String raftState;
    private String votedFor;
    private boolean isSnapshotCaptureInitiated;
    private String customRaftPolicyClassName;
    private boolean isVoting;
    private List<FollowerInfo> followerInfoList = Collections.emptyList();
    private Map<String, String> peerAddresses = Collections.emptyMap();
    private Map<String, Boolean> peerVotingStates = Collections.emptyMap();

    protected OnDemandRaftState() {
    }

    public static Builder builder() {
        return new Builder();
    }

    public long getLastLogIndex() {
        return this.lastLogIndex;
    }

    public long getLastLogTerm() {
        return this.lastLogTerm;
    }

    public long getCurrentTerm() {
        return this.currentTerm;
    }

    public long getCommitIndex() {
        return this.commitIndex;
    }

    public long getLastApplied() {
        return this.lastApplied;
    }

    public long getLastIndex() {
        return this.lastIndex;
    }

    public long getLastTerm() {
        return this.lastTerm;
    }

    public long getSnapshotIndex() {
        return this.snapshotIndex;
    }

    public long getSnapshotTerm() {
        return this.snapshotTerm;
    }

    public long getReplicatedToAllIndex() {
        return this.replicatedToAllIndex;
    }

    public long getInMemoryJournalDataSize() {
        return this.inMemoryJournalDataSize;
    }

    public long getInMemoryJournalLogSize() {
        return this.inMemoryJournalLogSize;
    }

    public String getLeader() {
        return this.leader;
    }

    public String getRaftState() {
        return this.raftState;
    }

    public String getVotedFor() {
        return this.votedFor;
    }

    public boolean isSnapshotCaptureInitiated() {
        return this.isSnapshotCaptureInitiated;
    }

    public boolean isVoting() {
        return this.isVoting;
    }

    public List<FollowerInfo> getFollowerInfoList() {
        return this.followerInfoList;
    }

    public Map<String, String> getPeerAddresses() {
        return this.peerAddresses;
    }

    public Map<String, Boolean> getPeerVotingStates() {
        return this.peerVotingStates;
    }

    public String getCustomRaftPolicyClassName() {
        return this.customRaftPolicyClassName;
    }

    public static class Builder
    extends AbstractBuilder<Builder, OnDemandRaftState> {
        private final OnDemandRaftState state = new OnDemandRaftState();

        @Override
        protected OnDemandRaftState state() {
            return this.state;
        }
    }

    public static abstract class AbstractBuilder<B extends AbstractBuilder<B, T>, T extends OnDemandRaftState> {
        protected B self() {
            return (B)this;
        }

        protected abstract @NonNull OnDemandRaftState state();

        public B lastLogIndex(long value) {
            this.state().lastLogIndex = value;
            return this.self();
        }

        public B lastLogTerm(long value) {
            this.state().lastLogTerm = value;
            return this.self();
        }

        public B currentTerm(long value) {
            this.state().currentTerm = value;
            return this.self();
        }

        public B commitIndex(long value) {
            this.state().commitIndex = value;
            return this.self();
        }

        public B lastApplied(long value) {
            this.state().lastApplied = value;
            return this.self();
        }

        public B lastIndex(long value) {
            this.state().lastIndex = value;
            return this.self();
        }

        public B lastTerm(long value) {
            this.state().lastTerm = value;
            return this.self();
        }

        public B snapshotIndex(long value) {
            this.state().snapshotIndex = value;
            return this.self();
        }

        public B snapshotTerm(long value) {
            this.state().snapshotTerm = value;
            return this.self();
        }

        public B replicatedToAllIndex(long value) {
            this.state().replicatedToAllIndex = value;
            return this.self();
        }

        public B inMemoryJournalDataSize(long value) {
            this.state().inMemoryJournalDataSize = value;
            return this.self();
        }

        public B inMemoryJournalLogSize(long value) {
            this.state().inMemoryJournalLogSize = value;
            return this.self();
        }

        public B leader(String value) {
            this.state().leader = value;
            return this.self();
        }

        public B raftState(String value) {
            this.state().raftState = value;
            return this.self();
        }

        public B votedFor(String value) {
            this.state().votedFor = value;
            return this.self();
        }

        public B isVoting(boolean isVoting) {
            this.state().isVoting = isVoting;
            return this.self();
        }

        public B followerInfoList(List<FollowerInfo> followerInfoList) {
            this.state().followerInfoList = followerInfoList;
            return this.self();
        }

        public B peerAddresses(Map<String, String> peerAddresses) {
            this.state().peerAddresses = peerAddresses;
            return this.self();
        }

        public B peerVotingStates(Map<String, Boolean> peerVotingStates) {
            this.state().peerVotingStates = ImmutableMap.copyOf(peerVotingStates);
            return this.self();
        }

        public B isSnapshotCaptureInitiated(boolean value) {
            this.state().isSnapshotCaptureInitiated = value;
            return this.self();
        }

        public B customRaftPolicyClassName(String className) {
            this.state().customRaftPolicyClassName = className;
            return this.self();
        }

        public T build() {
            return (T)this.state();
        }
    }
}

