/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.SetMultimap;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.xml.transform.TransformerException;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContext;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.parser.api.YangParser;
import org.opendaylight.yangtools.yang.model.parser.api.YangParserException;
import org.opendaylight.yangtools.yang.model.parser.api.YangSyntaxErrorException;
import org.opendaylight.yangtools.yang.model.repo.api.SchemaSourceRepresentation;
import org.opendaylight.yangtools.yang.model.repo.api.YangTextSchemaSource;
import org.opendaylight.yangtools.yang.model.repo.api.YinDomSchemaSource;
import org.opendaylight.yangtools.yang.model.repo.api.YinTextSchemaSource;
import org.opendaylight.yangtools.yang.model.repo.api.YinXmlSchemaSource;
import org.opendaylight.yangtools.yang.parser.rfc7950.repo.ASTSchemaSource;
import org.opendaylight.yangtools.yang.parser.rfc7950.repo.YangStatementStreamSource;
import org.opendaylight.yangtools.yang.parser.rfc7950.repo.YinStatementStreamSource;
import org.opendaylight.yangtools.yang.parser.rfc7950.repo.YinTextToDomTransformer;
import org.opendaylight.yangtools.yang.parser.spi.meta.ReactorException;
import org.opendaylight.yangtools.yang.parser.spi.source.StatementStreamSource;
import org.opendaylight.yangtools.yang.parser.stmt.reactor.CrossSourceStatementReactor;
import org.xml.sax.SAXException;

final class YangParserImpl
implements YangParser {
    private static final @NonNull Collection<Class<? extends SchemaSourceRepresentation>> REPRESENTATIONS = ImmutableList.of(ASTSchemaSource.class, YangTextSchemaSource.class, YinDomSchemaSource.class, YinXmlSchemaSource.class, YinTextSchemaSource.class);
    private final CrossSourceStatementReactor.BuildAction buildAction;

    YangParserImpl(CrossSourceStatementReactor.BuildAction buildAction) {
        this.buildAction = Objects.requireNonNull(buildAction);
    }

    public @NonNull Collection<Class<? extends SchemaSourceRepresentation>> supportedSourceRepresentations() {
        return REPRESENTATIONS;
    }

    public @NonNull Set<QName> supportedStatements() {
        return null;
    }

    public @NonNull YangParser addSource(SchemaSourceRepresentation source) throws IOException, YangSyntaxErrorException {
        this.buildAction.addSources(new StatementStreamSource[]{YangParserImpl.sourceToStatementStream(source)});
        return this;
    }

    public @NonNull YangParser addLibSource(SchemaSourceRepresentation source) throws IOException, YangSyntaxErrorException {
        this.buildAction.addLibSources(new StatementStreamSource[]{YangParserImpl.sourceToStatementStream(source)});
        return this;
    }

    public @NonNull YangParser setSupportedFeatures(Set<QName> supportedFeatures) {
        this.buildAction.setSupportedFeatures(supportedFeatures);
        return this;
    }

    public @NonNull YangParser setModulesWithSupportedDeviations(SetMultimap<QNameModule, QNameModule> modulesDeviatedByModules) {
        this.buildAction.setModulesWithSupportedDeviations(modulesDeviatedByModules);
        return this;
    }

    public @NonNull List<DeclaredStatement<?>> buildDeclaredModel() throws YangParserException {
        try {
            return this.buildAction.build().getRootStatements();
        }
        catch (ReactorException e) {
            throw YangParserImpl.decodeReactorException(e);
        }
    }

    public @NonNull EffectiveModelContext buildEffectiveModel() throws YangParserException {
        try {
            return this.buildAction.buildEffective();
        }
        catch (ReactorException e) {
            throw YangParserImpl.decodeReactorException(e);
        }
    }

    private static YangParserException decodeReactorException(ReactorException reported) {
        return new YangParserException("Failed to assemble sources", (Throwable)reported);
    }

    private static StatementStreamSource sourceToStatementStream(SchemaSourceRepresentation source) throws IOException, YangSyntaxErrorException {
        Objects.requireNonNull(source);
        if (source instanceof ASTSchemaSource) {
            return YangStatementStreamSource.create((ASTSchemaSource)((ASTSchemaSource)source));
        }
        if (source instanceof YangTextSchemaSource) {
            return YangStatementStreamSource.create((YangTextSchemaSource)((YangTextSchemaSource)source));
        }
        if (source instanceof YinDomSchemaSource) {
            return YinStatementStreamSource.create((YinDomSchemaSource)((YinDomSchemaSource)source));
        }
        if (source instanceof YinTextSchemaSource) {
            try {
                return YinStatementStreamSource.create((YinDomSchemaSource)YinTextToDomTransformer.transformSource((YinTextSchemaSource)((YinTextSchemaSource)source)));
            }
            catch (SAXException e) {
                throw new YangSyntaxErrorException(source.getIdentifier(), 0, 0, "Failed to parse XML text", (Throwable)e);
            }
        }
        if (source instanceof YinXmlSchemaSource) {
            try {
                return YinStatementStreamSource.create((YinXmlSchemaSource)((YinXmlSchemaSource)source));
            }
            catch (TransformerException e) {
                throw new YangSyntaxErrorException(source.getIdentifier(), 0, 0, "Failed to assemble in-memory representation", (Throwable)e);
            }
        }
        throw new IllegalArgumentException("Unsupported source " + source);
    }
}

