/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.blueprint.ext;

import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Predicate;
import org.opendaylight.mdsal.binding.spec.reflect.BindingReflections;
import org.opendaylight.mdsal.dom.spi.RpcRoutingStrategy;
import org.opendaylight.yangtools.yang.binding.RpcService;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.model.api.Module;
import org.opendaylight.yangtools.yang.model.api.RpcDefinition;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class RpcUtil {
    private static final Logger LOG = LoggerFactory.getLogger(RpcUtil.class);

    private RpcUtil() {
        throw new UnsupportedOperationException();
    }

    static Collection<SchemaPath> decomposeRpcService(Class<RpcService> service, SchemaContext schemaContext, Predicate<RpcRoutingStrategy> filter) {
        QNameModule moduleName = BindingReflections.getQNameModule(service);
        Module module = (Module)schemaContext.findModule(moduleName).orElseThrow(() -> new IllegalArgumentException("Module not found in SchemaContext: " + moduleName + "; service: " + service));
        LOG.debug("Resolved service {} to module {}", service, (Object)module);
        Collection rpcs = module.getRpcs();
        ArrayList<SchemaPath> ret = new ArrayList<SchemaPath>(rpcs.size());
        for (RpcDefinition rpc : rpcs) {
            RpcRoutingStrategy strategy = RpcRoutingStrategy.from((RpcDefinition)rpc);
            if (!filter.test(strategy)) continue;
            ret.add(rpc.getPath());
        }
        return ret;
    }
}

