/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.akka.segjournal;

import akka.actor.AbstractActor;
import akka.actor.Props;
import akka.persistence.AtomicWrite;
import akka.persistence.PersistentRepr;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.google.common.base.MoreObjects;
import com.google.common.base.Verify;
import io.atomix.storage.StorageLevel;
import io.atomix.storage.journal.Indexed;
import io.atomix.storage.journal.JournalReader;
import io.atomix.storage.journal.JournalWriter;
import io.atomix.storage.journal.SegmentedJournal;
import io.atomix.storage.journal.SegmentedJournalReader;
import io.atomix.storage.journal.SegmentedJournalWriter;
import io.atomix.utils.serializer.Namespace;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.opendaylight.controller.akka.segjournal.DataJournalEntry;
import org.opendaylight.controller.akka.segjournal.DataJournalEntrySerializer;
import org.opendaylight.controller.cluster.reporting.MetricsReporter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.collection.Seq;
import scala.concurrent.Future;
import scala.concurrent.Promise;
import scala.jdk.javaapi.CollectionConverters;

final class SegmentedJournalActor
extends AbstractActor {
    private static final Logger LOG = LoggerFactory.getLogger(SegmentedJournalActor.class);
    private static final Namespace DELETE_NAMESPACE = Namespace.builder().register(Long.class).build();
    private static final int DELETE_SEGMENT_SIZE = 65536;
    private final String persistenceId;
    private final StorageLevel storage;
    private final int maxSegmentSize;
    private final int maxEntrySize;
    private final File directory;
    private Timer batchWriteTime;
    private Meter messageWriteCount;
    private Histogram messageSize;
    private SegmentedJournal<DataJournalEntry> dataJournal;
    private SegmentedJournal<Long> deleteJournal;
    private long lastDelete;
    private int largestObservedSize;

    SegmentedJournalActor(String persistenceId, File directory, StorageLevel storage, int maxEntrySize, int maxSegmentSize) {
        this.persistenceId = Objects.requireNonNull(persistenceId);
        this.directory = Objects.requireNonNull(directory);
        this.storage = Objects.requireNonNull(storage);
        this.maxEntrySize = maxEntrySize;
        this.maxSegmentSize = maxSegmentSize;
    }

    static Props props(String persistenceId, File directory, StorageLevel storage, int maxEntrySize, int maxSegmentSize) {
        return Props.create(SegmentedJournalActor.class, (Object[])new Object[]{Objects.requireNonNull(persistenceId), directory, storage, maxEntrySize, maxSegmentSize});
    }

    public AbstractActor.Receive createReceive() {
        return this.receiveBuilder().match(DeleteMessagesTo.class, this::handleDeleteMessagesTo).match(ReadHighestSequenceNr.class, this::handleReadHighestSequenceNr).match(ReplayMessages.class, this::handleReplayMessages).match(WriteMessages.class, this::handleWriteMessages).matchAny(this::handleUnknown).build();
    }

    public void preStart() throws Exception {
        LOG.debug("{}: actor starting", (Object)this.persistenceId);
        super.preStart();
        MetricRegistry registry = MetricsReporter.getInstance((String)"org.opendaylight.controller.actor.metric").getMetricsRegistry();
        String actorName = this.self().path().parent().toStringWithoutAddress() + "/" + this.directory.getName();
        this.batchWriteTime = registry.timer(MetricRegistry.name((String)actorName, (String[])new String[]{"batchWriteTime"}));
        this.messageWriteCount = registry.meter(MetricRegistry.name((String)actorName, (String[])new String[]{"messageWriteCount"}));
        this.messageSize = registry.histogram(MetricRegistry.name((String)actorName, (String[])new String[]{"messageSize"}));
    }

    public void postStop() throws Exception {
        LOG.debug("{}: actor stopping", (Object)this.persistenceId);
        if (this.dataJournal != null) {
            this.dataJournal.close();
            LOG.debug("{}: data journal closed", (Object)this.persistenceId);
            this.dataJournal = null;
        }
        if (this.deleteJournal != null) {
            this.deleteJournal.close();
            LOG.debug("{}: delete journal closed", (Object)this.persistenceId);
            this.deleteJournal = null;
        }
        LOG.debug("{}: actor stopped", (Object)this.persistenceId);
        super.postStop();
    }

    static AsyncMessage<Void> deleteMessagesTo(long toSequenceNr) {
        return new DeleteMessagesTo(toSequenceNr);
    }

    static AsyncMessage<Long> readHighestSequenceNr(long fromSequenceNr) {
        return new ReadHighestSequenceNr(fromSequenceNr);
    }

    static AsyncMessage<Void> replayMessages(long fromSequenceNr, long toSequenceNr, long max, Consumer<PersistentRepr> replayCallback) {
        return new ReplayMessages(fromSequenceNr, toSequenceNr, max, replayCallback);
    }

    private void handleDeleteMessagesTo(DeleteMessagesTo message) {
        this.ensureOpen();
        LOG.debug("{}: delete messages {}", (Object)this.persistenceId, (Object)message);
        long to = Long.min(((SegmentedJournalWriter)this.dataJournal.writer()).getLastIndex(), message.toSequenceNr);
        LOG.debug("{}: adjusted delete to {}", (Object)this.persistenceId, (Object)to);
        if (this.lastDelete < to) {
            LOG.debug("{}: deleting entries up to {}", (Object)this.persistenceId, (Object)to);
            this.lastDelete = to;
            JournalWriter deleteWriter = this.deleteJournal.writer();
            Indexed<Long> entry = ((SegmentedJournalWriter)deleteWriter).append(this.lastDelete);
            ((SegmentedJournalWriter)deleteWriter).commit(entry.index());
            ((SegmentedJournalWriter)this.dataJournal.writer()).commit(this.lastDelete);
            LOG.debug("{}: compaction started", (Object)this.persistenceId);
            this.dataJournal.compact(this.lastDelete + 1L);
            this.deleteJournal.compact(entry.index());
            LOG.debug("{}: compaction finished", (Object)this.persistenceId);
        } else {
            LOG.debug("{}: entries up to {} already deleted", (Object)this.persistenceId, (Object)this.lastDelete);
        }
        message.promise.success(null);
    }

    private void handleReadHighestSequenceNr(ReadHighestSequenceNr message) {
        Long sequence;
        LOG.debug("{}: looking for highest sequence on {}", (Object)this.persistenceId, (Object)message);
        if (this.directory.isDirectory()) {
            this.ensureOpen();
            sequence = ((SegmentedJournalWriter)this.dataJournal.writer()).getLastIndex();
        } else {
            sequence = 0L;
        }
        LOG.debug("{}: highest sequence is {}", (Object)message, (Object)sequence);
        message.promise.success((Object)sequence);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleReplayMessages(ReplayMessages message) {
        LOG.debug("{}: replaying messages {}", (Object)this.persistenceId, (Object)message);
        this.ensureOpen();
        long from = Long.max(this.lastDelete + 1L, message.fromSequenceNr);
        LOG.debug("{}: adjusted fromSequenceNr to {}", (Object)this.persistenceId, (Object)from);
        try (JournalReader reader = this.dataJournal.openReader(from);){
            Object next;
            int count = 0;
            while (((SegmentedJournalReader)reader).hasNext() && (long)count < message.max && ((Indexed)(next = ((SegmentedJournalReader)reader).next())).index() <= message.toSequenceNr) {
                LOG.trace("{}: replay {}", (Object)this.persistenceId, next);
                this.updateLargestSize(((Indexed)next).size());
                DataJournalEntry entry = (DataJournalEntry)((Indexed)next).entry();
                Verify.verify((boolean)(entry instanceof DataJournalEntry.FromPersistence), (String)"Unexpected entry %s", (Object)entry);
                PersistentRepr repr = ((DataJournalEntry.FromPersistence)entry).toRepr(this.persistenceId, ((Indexed)next).index());
                LOG.debug("{}: replaying {}", (Object)this.persistenceId, (Object)repr);
                message.replayCallback.accept(repr);
                ++count;
            }
            LOG.debug("{}: successfully replayed {} entries", (Object)this.persistenceId, (Object)count);
        }
        catch (Exception e) {
            LOG.warn("{}: failed to replay messages for {}", new Object[]{this.persistenceId, message, e});
            message.promise.failure((Throwable)e);
        }
        finally {
            message.promise.success(null);
        }
    }

    private void handleWriteMessages(WriteMessages message) {
        this.ensureOpen();
        JournalWriter writer = this.dataJournal.writer();
        long startTicks = System.nanoTime();
        int count = message.requests.size();
        long start = ((SegmentedJournalWriter)writer).getLastIndex();
        for (int i = 0; i < count; ++i) {
            long mark = ((SegmentedJournalWriter)writer).getLastIndex();
            try {
                this.writeRequest((SegmentedJournalWriter<DataJournalEntry>)writer, message.requests.get(i));
            }
            catch (Exception e) {
                LOG.warn("{}: failed to write out request", (Object)this.persistenceId, (Object)e);
                message.results.get(i).success(Optional.of(e));
                ((SegmentedJournalWriter)writer).truncate(mark);
                continue;
            }
            message.results.get(i).success(Optional.empty());
        }
        ((SegmentedJournalWriter)writer).flush();
        this.batchWriteTime.update(System.nanoTime() - startTicks, TimeUnit.NANOSECONDS);
        this.messageWriteCount.mark(((SegmentedJournalWriter)writer).getLastIndex() - start);
    }

    private void writeRequest(SegmentedJournalWriter<DataJournalEntry> writer, AtomicWrite request) {
        for (PersistentRepr repr : CollectionConverters.asJava((Seq)request.payload())) {
            Object payload = repr.payload();
            if (!(payload instanceof Serializable)) {
                throw new UnsupportedOperationException("Non-serializable payload encountered " + payload.getClass());
            }
            int size = writer.append(new DataJournalEntry.ToPersistence(repr)).size();
            this.messageSize.update(size);
            this.updateLargestSize(size);
        }
    }

    private void handleUnknown(Object message) {
        LOG.error("{}: Received unknown message {}", (Object)this.persistenceId, message);
    }

    private void updateLargestSize(int size) {
        if (size > this.largestObservedSize) {
            this.largestObservedSize = size;
        }
    }

    private void ensureOpen() {
        if (this.dataJournal != null) {
            Verify.verifyNotNull(this.deleteJournal);
            return;
        }
        this.deleteJournal = SegmentedJournal.builder().withDirectory(this.directory).withName("delete").withNamespace(DELETE_NAMESPACE).withMaxSegmentSize(65536).build();
        Indexed lastEntry = ((SegmentedJournalWriter)this.deleteJournal.writer()).getLastEntry();
        this.lastDelete = lastEntry == null ? 0L : (Long)lastEntry.entry();
        this.dataJournal = SegmentedJournal.builder().withStorageLevel(this.storage).withDirectory(this.directory).withName("data").withNamespace(Namespace.builder().register(new DataJournalEntrySerializer(this.context().system()), DataJournalEntry.FromPersistence.class, DataJournalEntry.ToPersistence.class).build()).withMaxEntrySize(this.maxEntrySize).withMaxSegmentSize(this.maxSegmentSize).build();
        JournalWriter writer = this.dataJournal.writer();
        ((SegmentedJournalWriter)writer).commit(this.lastDelete);
        LOG.debug("{}: journal open with last index {}, deleted to {}", new Object[]{this.persistenceId, ((SegmentedJournalWriter)writer).getLastIndex(), this.lastDelete});
    }

    private static final class DeleteMessagesTo
    extends AsyncMessage<Void> {
        final long toSequenceNr;

        DeleteMessagesTo(long toSequenceNr) {
            this.toSequenceNr = toSequenceNr;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("toSequenceNr", this.toSequenceNr).toString();
        }
    }

    static final class WriteMessages {
        private final List<AtomicWrite> requests = new ArrayList<AtomicWrite>();
        private final List<Promise<Optional<Exception>>> results = new ArrayList<Promise<Optional<Exception>>>();

        WriteMessages() {
        }

        Future<Optional<Exception>> add(AtomicWrite write) {
            Promise promise = Promise.apply();
            this.requests.add(write);
            this.results.add((Promise<Optional<Exception>>)promise);
            return promise.future();
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("requests", this.requests).toString();
        }
    }

    private static final class ReplayMessages
    extends AsyncMessage<Void> {
        private final long fromSequenceNr;
        private final long toSequenceNr;
        private final long max;
        private final Consumer<PersistentRepr> replayCallback;

        ReplayMessages(long fromSequenceNr, long toSequenceNr, long max, Consumer<PersistentRepr> replayCallback) {
            this.fromSequenceNr = fromSequenceNr;
            this.toSequenceNr = toSequenceNr;
            this.max = max;
            this.replayCallback = Objects.requireNonNull(replayCallback);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("fromSequenceNr", this.fromSequenceNr).add("toSequenceNr", this.toSequenceNr).add("max", this.max).toString();
        }
    }

    private static final class ReadHighestSequenceNr
    extends AsyncMessage<Long> {
        private final long fromSequenceNr;

        ReadHighestSequenceNr(long fromSequenceNr) {
            this.fromSequenceNr = fromSequenceNr;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("fromSequenceNr", this.fromSequenceNr).toString();
        }
    }

    static abstract class AsyncMessage<T> {
        final Promise<T> promise = Promise.apply();

        AsyncMessage() {
        }
    }
}

