/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.sample.kitchen.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.Collection;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.opendaylight.controller.md.sal.common.util.jmx.AbstractMXBean;
import org.opendaylight.controller.sample.kitchen.api.EggsType;
import org.opendaylight.controller.sample.kitchen.api.KitchenService;
import org.opendaylight.controller.sample.kitchen.api.KitchenServiceRuntimeMXBean;
import org.opendaylight.yang.gen.v1.http.netconfcentral.org.ns.toaster.rev091120.MakeToastInput;
import org.opendaylight.yang.gen.v1.http.netconfcentral.org.ns.toaster.rev091120.MakeToastInputBuilder;
import org.opendaylight.yang.gen.v1.http.netconfcentral.org.ns.toaster.rev091120.MakeToastOutput;
import org.opendaylight.yang.gen.v1.http.netconfcentral.org.ns.toaster.rev091120.MakeToastOutputBuilder;
import org.opendaylight.yang.gen.v1.http.netconfcentral.org.ns.toaster.rev091120.ToastType;
import org.opendaylight.yang.gen.v1.http.netconfcentral.org.ns.toaster.rev091120.ToasterListener;
import org.opendaylight.yang.gen.v1.http.netconfcentral.org.ns.toaster.rev091120.ToasterOutOfBread;
import org.opendaylight.yang.gen.v1.http.netconfcentral.org.ns.toaster.rev091120.ToasterRestocked;
import org.opendaylight.yang.gen.v1.http.netconfcentral.org.ns.toaster.rev091120.ToasterService;
import org.opendaylight.yang.gen.v1.http.netconfcentral.org.ns.toaster.rev091120.WheatBread;
import org.opendaylight.yangtools.yang.common.RpcError;
import org.opendaylight.yangtools.yang.common.RpcResult;
import org.opendaylight.yangtools.yang.common.RpcResultBuilder;
import org.opendaylight.yangtools.yang.common.Uint32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KitchenServiceImpl
extends AbstractMXBean
implements KitchenService,
KitchenServiceRuntimeMXBean,
ToasterListener {
    private static final Logger LOG = LoggerFactory.getLogger(KitchenServiceImpl.class);
    private static final MakeToastOutput EMPTY_MAKE_OUTPUT = new MakeToastOutputBuilder().build();
    private final ToasterService toaster;
    private final ListeningExecutorService executor = MoreExecutors.listeningDecorator((ExecutorService)Executors.newCachedThreadPool());
    private volatile boolean toasterOutOfBread;

    public KitchenServiceImpl(ToasterService toaster) {
        super("KitchenService", "toaster-consumer", null);
        this.toaster = toaster;
    }

    @Override
    public Future<RpcResult<Void>> makeBreakfast(EggsType eggsType, Class<? extends ToastType> toastType, int toastDoneness) {
        ListenableFuture<RpcResult<MakeToastOutput>> makeToastFuture = this.makeToast(toastType, toastDoneness);
        ListenableFuture<RpcResult<Void>> makeEggsFuture = this.makeEggs(eggsType);
        ListenableFuture combinedFutures = Futures.allAsList((Iterable)ImmutableList.of(makeToastFuture, makeEggsFuture));
        return Futures.transformAsync((ListenableFuture)combinedFutures, results -> {
            boolean atLeastOneSucceeded = false;
            ImmutableList.Builder errorList = ImmutableList.builder();
            for (RpcResult result : results) {
                if (result.isSuccessful()) {
                    atLeastOneSucceeded = true;
                }
                if (result.getErrors() == null) continue;
                errorList.addAll((Iterable)result.getErrors());
            }
            return Futures.immediateFuture((Object)RpcResultBuilder.status((boolean)atLeastOneSucceeded).withRpcErrors((Collection)errorList.build()).build());
        }, (Executor)MoreExecutors.directExecutor());
    }

    private ListenableFuture<RpcResult<Void>> makeEggs(EggsType eggsType) {
        return this.executor.submit(() -> RpcResultBuilder.success().build());
    }

    private ListenableFuture<RpcResult<MakeToastOutput>> makeToast(Class<? extends ToastType> toastType, int toastDoneness) {
        if (this.toasterOutOfBread) {
            LOG.info("We're out of toast but we can make eggs");
            return Futures.immediateFuture((Object)RpcResultBuilder.success((Object)EMPTY_MAKE_OUTPUT).withWarning(RpcError.ErrorType.APPLICATION, "partial-operation", "Toaster is out of bread but we can make you eggs").build());
        }
        MakeToastInput toastInput = new MakeToastInputBuilder().setToasterDoneness(Uint32.valueOf((int)toastDoneness)).setToasterToastType(toastType).build();
        return this.toaster.makeToast(toastInput);
    }

    @Override
    public Boolean makeScrambledWithWheat() {
        try {
            RpcResult<Void> result = this.makeBreakfast(EggsType.SCRAMBLED, WheatBread.class, 2).get();
            if (result.isSuccessful()) {
                LOG.info("makeBreakfast succeeded");
            } else {
                LOG.warn("makeBreakfast failed: {}", (Object)result.getErrors());
            }
            return result.isSuccessful();
        }
        catch (InterruptedException | ExecutionException e) {
            LOG.warn("An error occurred while maing breakfast", (Throwable)e);
            return Boolean.FALSE;
        }
    }

    public void onToasterOutOfBread(ToasterOutOfBread notification) {
        LOG.info("ToasterOutOfBread notification");
        this.toasterOutOfBread = true;
    }

    public void onToasterRestocked(ToasterRestocked notification) {
        LOG.info("ToasterRestocked notification - amountOfBread: {}", (Object)notification.getAmountOfBread());
        this.toasterOutOfBread = false;
    }
}

