/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.dom.store.inmemory;

import com.google.common.annotations.Beta;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionHandler;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.mdsal.dom.api.DOMDataTreeChangeListener;
import org.opendaylight.mdsal.dom.api.DOMDataTreeIdentifier;
import org.opendaylight.mdsal.dom.api.DOMDataTreeShard;
import org.opendaylight.mdsal.dom.spi.DOMDataTreePrefixTable;
import org.opendaylight.mdsal.dom.spi.shard.ChildShardContext;
import org.opendaylight.mdsal.dom.spi.shard.ForeignShardModificationContext;
import org.opendaylight.mdsal.dom.spi.shard.ReadableWriteableDOMDataTreeShard;
import org.opendaylight.mdsal.dom.spi.shard.SubshardProducerSpecification;
import org.opendaylight.mdsal.dom.spi.shard.WriteableDOMDataTreeShard;
import org.opendaylight.mdsal.dom.store.inmemory.InMemoryDOMDataTreeShardChangePublisher;
import org.opendaylight.mdsal.dom.store.inmemory.InMemoryDOMDataTreeShardProducer;
import org.opendaylight.mdsal.dom.store.inmemory.InMemoryShardDataModificationFactory;
import org.opendaylight.mdsal.dom.store.inmemory.InmemoryDOMDataTreeShardWriteTransaction;
import org.opendaylight.mdsal.dom.store.inmemory.InmemoryShardDataModificationFactoryBuilder;
import org.opendaylight.yangtools.concepts.ListenerRegistration;
import org.opendaylight.yangtools.util.concurrent.CountingRejectedExecutionHandler;
import org.opendaylight.yangtools.util.concurrent.FastThreadPoolExecutor;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.tree.CursorAwareDataTreeSnapshot;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTree;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeConfiguration;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeSnapshot;
import org.opendaylight.yangtools.yang.data.impl.schema.tree.InMemoryDataTreeFactory;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContext;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContextListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public class InMemoryDOMDataTreeShard
implements ReadableWriteableDOMDataTreeShard,
EffectiveModelContextListener {
    private static final Logger LOG = LoggerFactory.getLogger(InMemoryDOMDataTreeShard.class);
    private static final int DEFAULT_SUBMIT_QUEUE_SIZE = 1000;
    private final DOMDataTreePrefixTable<ChildShardContext> childShardsTable = DOMDataTreePrefixTable.create();
    private final Map<DOMDataTreeIdentifier, ChildShardContext> childShards = new HashMap<DOMDataTreeIdentifier, ChildShardContext>();
    private final Collection<InMemoryDOMDataTreeShardProducer> producers = new HashSet<InMemoryDOMDataTreeShardProducer>();
    private final InMemoryDOMDataTreeShardChangePublisher shardChangePublisher;
    private final ListeningExecutorService executor;
    private final DOMDataTreeIdentifier prefix;
    private final DataTree dataTree;

    InMemoryDOMDataTreeShard(DOMDataTreeIdentifier prefix, Executor dataTreeChangeExecutor, int maxDataChangeListenerQueueSize, int submitQueueSize) {
        this.prefix = Objects.requireNonNull(prefix);
        DataTreeConfiguration treeBaseConfig = InMemoryDOMDataTreeShard.treeTypeFor(prefix.getDatastoreType());
        DataTreeConfiguration treeConfig = new DataTreeConfiguration.Builder(treeBaseConfig.getTreeType()).setMandatoryNodesValidation(treeBaseConfig.isMandatoryNodesValidationEnabled()).setUniqueIndexes(treeBaseConfig.isUniqueIndexEnabled()).setRootPath(prefix.getRootIdentifier()).build();
        this.dataTree = new InMemoryDataTreeFactory().create(treeConfig);
        this.shardChangePublisher = new InMemoryDOMDataTreeShardChangePublisher(dataTreeChangeExecutor, maxDataChangeListenerQueueSize, this.dataTree, prefix.getRootIdentifier(), this.childShards);
        FastThreadPoolExecutor fte = new FastThreadPoolExecutor(1, submitQueueSize, "Shard[" + prefix + "]", InMemoryDOMDataTreeShard.class);
        fte.setRejectedExecutionHandler((RejectedExecutionHandler)CountingRejectedExecutionHandler.newCallerWaitsPolicy());
        this.executor = MoreExecutors.listeningDecorator((ExecutorService)fte);
    }

    public static InMemoryDOMDataTreeShard create(DOMDataTreeIdentifier id, Executor dataTreeChangeExecutor, int maxDataChangeListenerQueueSize) {
        return new InMemoryDOMDataTreeShard(id.toOptimized(), dataTreeChangeExecutor, maxDataChangeListenerQueueSize, 1000);
    }

    public static InMemoryDOMDataTreeShard create(DOMDataTreeIdentifier id, Executor dataTreeChangeExecutor, int maxDataChangeListenerQueueSize, int submitQueueSize) {
        return new InMemoryDOMDataTreeShard(id.toOptimized(), dataTreeChangeExecutor, maxDataChangeListenerQueueSize, submitQueueSize);
    }

    public void onModelContextUpdated(EffectiveModelContext newModelContext) {
        this.dataTree.setEffectiveModelContext(newModelContext);
    }

    public void onChildAttached(DOMDataTreeIdentifier childPrefix, DOMDataTreeShard child) {
        Preconditions.checkArgument((child != this ? 1 : 0) != 0, (String)"Attempted to attach child %s onto self", (Object)this);
        this.reparentChildShards(childPrefix, child);
        ChildShardContext context = InMemoryDOMDataTreeShard.createContextFor(childPrefix, child);
        this.childShards.put(childPrefix, context);
        this.childShardsTable.store(childPrefix, (Object)context);
        this.updateProducers();
    }

    public void onChildDetached(DOMDataTreeIdentifier childPrefix, DOMDataTreeShard child) {
        this.childShards.remove(childPrefix);
        this.childShardsTable.remove(childPrefix);
        this.updateProducers();
    }

    private void updateProducers() {
        for (InMemoryDOMDataTreeShardProducer p : this.producers) {
            p.setModificationFactory(this.createModificationFactory(p.getPrefixes()));
        }
    }

    @VisibleForTesting
    InMemoryShardDataModificationFactory createModificationFactory(Collection<DOMDataTreeIdentifier> prefixes) {
        HashMap<DOMDataTreeIdentifier, SubshardProducerSpecification> affected = new HashMap<DOMDataTreeIdentifier, SubshardProducerSpecification>();
        for (DOMDataTreeIdentifier producerPrefix : prefixes) {
            for (ChildShardContext child : this.childShards.values()) {
                DOMDataTreeIdentifier bindPath;
                if (producerPrefix.contains(child.getPrefix())) {
                    bindPath = child.getPrefix();
                } else {
                    if (!child.getPrefix().contains(producerPrefix)) continue;
                    bindPath = producerPrefix;
                }
                SubshardProducerSpecification spec = (SubshardProducerSpecification)affected.get(child.getPrefix());
                if (spec == null) {
                    spec = new SubshardProducerSpecification(child);
                    affected.put(child.getPrefix(), spec);
                }
                spec.addPrefix(bindPath);
            }
        }
        InmemoryShardDataModificationFactoryBuilder builder = new InmemoryShardDataModificationFactoryBuilder(this.prefix);
        for (SubshardProducerSpecification spec : affected.values()) {
            ForeignShardModificationContext foreignContext = new ForeignShardModificationContext(spec.getPrefix(), spec.createProducer());
            builder.addSubshard(foreignContext);
            builder.addSubshard(spec.getPrefix(), foreignContext);
        }
        return builder.build();
    }

    public InMemoryDOMDataTreeShardProducer createProducer(Collection<DOMDataTreeIdentifier> prefixes) {
        for (DOMDataTreeIdentifier prodPrefix : prefixes) {
            Preconditions.checkArgument((boolean)this.prefix.contains(prodPrefix), (String)"Prefix %s is not contained under shard root", (Object)prodPrefix, (Object)this.prefix);
        }
        InMemoryDOMDataTreeShardProducer ret = new InMemoryDOMDataTreeShardProducer(this, prefixes, this.createModificationFactory(prefixes));
        this.producers.add(ret);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void closeProducer(InMemoryDOMDataTreeShardProducer producer) {
        InMemoryDOMDataTreeShard inMemoryDOMDataTreeShard = this;
        synchronized (inMemoryDOMDataTreeShard) {
            if (!this.producers.remove(producer)) {
                LOG.warn("Producer {} not found in shard {}", (Object)producer, (Object)this);
            }
        }
    }

    public <L extends DOMDataTreeChangeListener> ListenerRegistration<L> registerTreeChangeListener(YangInstanceIdentifier treeId, L listener) {
        return this.shardChangePublisher.registerTreeChangeListener(treeId, listener);
    }

    private void reparentChildShards(DOMDataTreeIdentifier newChildPrefix, DOMDataTreeShard newChild) {
        Iterator<Map.Entry<DOMDataTreeIdentifier, ChildShardContext>> actualChildren = this.childShards.entrySet().iterator();
        HashMap<DOMDataTreeIdentifier, ChildShardContext> reparented = new HashMap<DOMDataTreeIdentifier, ChildShardContext>();
        while (actualChildren.hasNext()) {
            Map.Entry<DOMDataTreeIdentifier, ChildShardContext> actualChild = actualChildren.next();
            DOMDataTreeIdentifier actualPrefix = actualChild.getKey();
            Preconditions.checkArgument((!newChildPrefix.equals((Object)actualPrefix) ? 1 : 0) != 0, (String)"Child shard with prefix %s already attached", (Object)newChildPrefix);
            if (!newChildPrefix.contains(actualPrefix)) continue;
            ChildShardContext actualContext = actualChild.getValue();
            actualChildren.remove();
            newChild.onChildAttached(actualPrefix, (DOMDataTreeShard)actualContext.getShard());
            reparented.put(actualChild.getKey(), actualContext);
            this.childShardsTable.remove(actualPrefix);
        }
        this.updateProducersAndListeners(reparented);
    }

    private void updateProducersAndListeners(Map<DOMDataTreeIdentifier, ChildShardContext> reparented) {
        if (reparented.isEmpty()) {
            return;
        }
        throw new UnsupportedOperationException();
    }

    private static ChildShardContext createContextFor(DOMDataTreeIdentifier prefix, DOMDataTreeShard child) {
        Preconditions.checkArgument((boolean)(child instanceof WriteableDOMDataTreeShard), (String)"Child %s is not a writable shared", (Object)child);
        return new ChildShardContext(prefix, (WriteableDOMDataTreeShard)child);
    }

    private static DataTreeConfiguration treeTypeFor(LogicalDatastoreType dsType) {
        switch (dsType) {
            case CONFIGURATION: {
                return DataTreeConfiguration.DEFAULT_CONFIGURATION;
            }
            case OPERATIONAL: {
                return DataTreeConfiguration.DEFAULT_OPERATIONAL;
            }
        }
        throw new IllegalArgumentException("Unsupported Data Store type:" + dsType);
    }

    @VisibleForTesting
    Map<DOMDataTreeIdentifier, DOMDataTreeShard> getChildShards() {
        return ImmutableMap.copyOf((Map)Maps.transformValues(this.childShards, ChildShardContext::getShard));
    }

    DataTreeSnapshot takeSnapshot() {
        return this.dataTree.takeSnapshot();
    }

    InmemoryDOMDataTreeShardWriteTransaction createTransaction(String transactionId, InMemoryDOMDataTreeShardProducer producer, DataTreeSnapshot snapshot) {
        Preconditions.checkArgument((boolean)(snapshot instanceof CursorAwareDataTreeSnapshot));
        return new InmemoryDOMDataTreeShardWriteTransaction(producer, producer.getModificationFactory().createModification((CursorAwareDataTreeSnapshot)snapshot), this.dataTree, this.shardChangePublisher, this.executor);
    }

    @VisibleForTesting
    public Collection<InMemoryDOMDataTreeShardProducer> getProducers() {
        return this.producers;
    }
}

