/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.dom.store.inmemory;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.mdsal.dom.api.DOMDataTreeIdentifier;
import org.opendaylight.mdsal.dom.spi.shard.DOMDataTreeShardProducer;
import org.opendaylight.mdsal.dom.store.inmemory.InMemoryDOMDataTreeShard;
import org.opendaylight.mdsal.dom.store.inmemory.InMemoryShardDataModificationFactory;
import org.opendaylight.mdsal.dom.store.inmemory.InmemoryDOMDataTreeShardWriteTransaction;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeModification;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeSnapshot;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class InMemoryDOMDataTreeShardProducer
implements DOMDataTreeShardProducer {
    private static final Logger LOG = LoggerFactory.getLogger(InMemoryDOMDataTreeShardProducer.class);
    private static final AtomicLong COUNTER = new AtomicLong();
    private final InMemoryDOMDataTreeShard parentShard;
    private final Collection<DOMDataTreeIdentifier> prefixes;
    private final Idle idleState = new Idle(this);
    private static final AtomicReferenceFieldUpdater<InMemoryDOMDataTreeShardProducer, State> STATE_UPDATER = AtomicReferenceFieldUpdater.newUpdater(InMemoryDOMDataTreeShardProducer.class, State.class, "state");
    private volatile State state;
    private InMemoryShardDataModificationFactory modificationFactory;

    InMemoryDOMDataTreeShardProducer(InMemoryDOMDataTreeShard parentShard, Collection<DOMDataTreeIdentifier> prefixes, InMemoryShardDataModificationFactory modificationFactory) {
        this.parentShard = Objects.requireNonNull(parentShard);
        this.prefixes = ImmutableSet.copyOf(prefixes);
        this.modificationFactory = Objects.requireNonNull(modificationFactory);
        this.state = this.idleState;
    }

    public InmemoryDOMDataTreeShardWriteTransaction createTransaction() {
        InmemoryDOMDataTreeShardWriteTransaction ret;
        State localState;
        String transactionId = InMemoryDOMDataTreeShardProducer.nextIdentifier();
        while (!STATE_UPDATER.compareAndSet(this, localState = this.state, new Allocated(ret = this.parentShard.createTransaction(transactionId, this, localState.getSnapshot(transactionId))))) {
        }
        return ret;
    }

    public void close() {
        Shutdown shutdown = new Shutdown("Producer closed");
        if (!STATE_UPDATER.compareAndSet(this, this.idleState, shutdown)) {
            throw new IllegalStateException("Producer " + this + " in unexpected state " + this.state);
        }
        this.getParentShard().closeProducer(this);
        this.getModificationFactory().close();
    }

    void transactionReady(InmemoryDOMDataTreeShardWriteTransaction tx, DataTreeModification modification) {
        State localState = this.state;
        LOG.debug("Transaction was readied {}, current state {}", (Object)tx.getIdentifier(), (Object)localState);
        if (localState instanceof Allocated) {
            Allocated allocated = (Allocated)localState;
            InmemoryDOMDataTreeShardWriteTransaction transaction = allocated.getTransaction();
            Preconditions.checkState((boolean)tx.equals(transaction), (String)"Mis-ordered ready transaction %s last allocated was %s", (Object)tx, (Object)transaction);
            allocated.setSnapshot((DataTreeSnapshot)modification);
        } else {
            LOG.debug("Ignoring transaction {} readiness due to state {}", (Object)tx, (Object)localState);
        }
    }

    void onTransactionCommited(InmemoryDOMDataTreeShardWriteTransaction transaction) {
        State localState = this.state;
        LOG.debug("Transaction {} commit done, current state {}", (Object)transaction.getIdentifier(), (Object)localState);
        if (!(localState instanceof Allocated)) {
            LOG.debug("Ignoring successful transaction {} in state {}", (Object)transaction, (Object)localState);
            return;
        }
        Allocated allocated = (Allocated)localState;
        InmemoryDOMDataTreeShardWriteTransaction tx = allocated.getTransaction();
        if (!tx.equals(transaction)) {
            LOG.debug("Ignoring non-latest successful transaction {} in state {}", (Object)transaction, (Object)allocated);
            return;
        }
        if (!STATE_UPDATER.compareAndSet(this, localState, this.idleState)) {
            LOG.debug("Producer {} has already transitioned from {} to {}, not making it idle", new Object[]{this, localState, this.state});
        }
    }

    void transactionAborted(InmemoryDOMDataTreeShardWriteTransaction tx) {
        boolean success;
        Allocated allocated;
        State localState = this.state;
        if (localState instanceof Allocated && (allocated = (Allocated)localState).getTransaction().equals(tx) && !(success = STATE_UPDATER.compareAndSet(this, localState, this.idleState))) {
            LOG.warn("Transaction {} aborted, but producer {} state already transitioned from {} to {}", new Object[]{tx, this, localState, this.state});
        }
    }

    private static String nextIdentifier() {
        return "INMEMORY-SHARD-TX-" + COUNTER.getAndIncrement();
    }

    DataTreeSnapshot takeSnapshot() {
        return this.parentShard.takeSnapshot();
    }

    public Collection<DOMDataTreeIdentifier> getPrefixes() {
        return this.prefixes;
    }

    @NonNull InMemoryDOMDataTreeShard getParentShard() {
        return this.parentShard;
    }

    InMemoryShardDataModificationFactory getModificationFactory() {
        return this.modificationFactory;
    }

    void setModificationFactory(InMemoryShardDataModificationFactory modificationFactory) {
        this.getModificationFactory().close();
        this.modificationFactory = Objects.requireNonNull(modificationFactory);
    }

    private static final class Shutdown
    extends State {
        private final String message;

        Shutdown(String message) {
            this.message = Objects.requireNonNull(message);
        }

        @Override
        protected DataTreeSnapshot getSnapshot(Object transactionId) {
            throw new IllegalStateException(this.message);
        }
    }

    private static final class Allocated
    extends State {
        private static final AtomicReferenceFieldUpdater<Allocated, DataTreeSnapshot> SNAPSHOT_UPDATER = AtomicReferenceFieldUpdater.newUpdater(Allocated.class, DataTreeSnapshot.class, "snapshot");
        private final InmemoryDOMDataTreeShardWriteTransaction transaction;
        private volatile DataTreeSnapshot snapshot;

        Allocated(InmemoryDOMDataTreeShardWriteTransaction transaction) {
            this.transaction = Objects.requireNonNull(transaction);
        }

        InmemoryDOMDataTreeShardWriteTransaction getTransaction() {
            return this.transaction;
        }

        @Override
        protected DataTreeSnapshot getSnapshot(Object transactionId) {
            DataTreeSnapshot ret = this.snapshot;
            Preconditions.checkState((ret != null ? 1 : 0) != 0, (String)"Could not get snapshot for transaction %s - previous transaction %s is not ready yet", (Object)transactionId, (Object)this.transaction.getIdentifier());
            return ret;
        }

        void setSnapshot(DataTreeSnapshot snapshot) {
            boolean success = SNAPSHOT_UPDATER.compareAndSet(this, null, snapshot);
            Preconditions.checkState((boolean)success, (String)"Transaction %s has already been marked as ready", (Object)this.transaction.getIdentifier());
        }
    }

    private static final class Idle
    extends State {
        private final InMemoryDOMDataTreeShardProducer producer;

        Idle(InMemoryDOMDataTreeShardProducer producer) {
            this.producer = Objects.requireNonNull(producer);
        }

        @Override
        protected DataTreeSnapshot getSnapshot(Object transactionId) {
            return this.producer.takeSnapshot();
        }
    }

    private static abstract class State {
        private State() {
        }

        protected abstract DataTreeSnapshot getSnapshot(Object var1);
    }
}

