/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.dom.store.inmemory;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.mdsal.dom.api.DOMDataTreeIdentifier;
import org.opendaylight.mdsal.dom.spi.shard.DOMDataTreeShardProducer;
import org.opendaylight.mdsal.dom.spi.shard.ForeignShardModificationContext;
import org.opendaylight.mdsal.dom.spi.shard.WriteableModificationNode;
import org.opendaylight.mdsal.dom.store.inmemory.ShardDataModification;
import org.opendaylight.mdsal.dom.store.inmemory.ShardRootModificationContext;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.tree.CursorAwareDataTreeSnapshot;

final class InMemoryShardDataModificationFactory {
    private final Map<DOMDataTreeIdentifier, ForeignShardModificationContext> childShards;
    private final Map<YangInstanceIdentifier.PathArgument, WriteableModificationNode> children;
    private final DOMDataTreeIdentifier root;

    InMemoryShardDataModificationFactory(DOMDataTreeIdentifier root, Map<YangInstanceIdentifier.PathArgument, WriteableModificationNode> children, Map<DOMDataTreeIdentifier, ForeignShardModificationContext> childShards) {
        this.root = Objects.requireNonNull(root);
        this.children = ImmutableMap.copyOf(children);
        this.childShards = ImmutableMap.copyOf(childShards);
    }

    @VisibleForTesting
    Map<YangInstanceIdentifier.PathArgument, WriteableModificationNode> getChildren() {
        return this.children;
    }

    @VisibleForTesting
    Map<DOMDataTreeIdentifier, ForeignShardModificationContext> getChildShards() {
        return this.childShards;
    }

    ShardDataModification createModification(CursorAwareDataTreeSnapshot snapshot) {
        return new ShardDataModification(new ShardRootModificationContext(this.root, snapshot), this.children, this.childShards);
    }

    void close() {
        this.childShards.values().stream().map(ForeignShardModificationContext::getProducer).forEach(DOMDataTreeShardProducer::close);
    }
}

