/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.dom.store.inmemory;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicLong;
import org.opendaylight.mdsal.dom.api.DOMDataTreeIdentifier;
import org.opendaylight.mdsal.dom.api.DOMDataTreeWriteCursor;
import org.opendaylight.mdsal.dom.spi.shard.DOMDataTreeShardWriteTransaction;
import org.opendaylight.mdsal.dom.spi.shard.ForeignShardModificationContext;
import org.opendaylight.mdsal.dom.spi.shard.ForeignShardThreePhaseCommitCohort;
import org.opendaylight.mdsal.dom.spi.store.DOMStoreThreePhaseCommitCohort;
import org.opendaylight.mdsal.dom.store.inmemory.InMemoryDOMDataTreeShardChangePublisher;
import org.opendaylight.mdsal.dom.store.inmemory.InMemoryDOMDataTreeShardProducer;
import org.opendaylight.mdsal.dom.store.inmemory.InMemoryDOMDataTreeShardThreePhaseCommitCohort;
import org.opendaylight.mdsal.dom.store.inmemory.InMemoryShardDataModificationCursor;
import org.opendaylight.mdsal.dom.store.inmemory.ShardCanCommitCoordinationTask;
import org.opendaylight.mdsal.dom.store.inmemory.ShardCommitCoordinationTask;
import org.opendaylight.mdsal.dom.store.inmemory.ShardDataModification;
import org.opendaylight.mdsal.dom.store.inmemory.ShardPreCommitCoordinationTask;
import org.opendaylight.mdsal.dom.store.inmemory.ShardSubmitCoordinationTask;
import org.opendaylight.yangtools.concepts.Identifiable;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTree;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeModification;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class InmemoryDOMDataTreeShardWriteTransaction
implements DOMDataTreeShardWriteTransaction,
Identifiable<String> {
    private static final Logger LOG = LoggerFactory.getLogger(InmemoryDOMDataTreeShardWriteTransaction.class);
    private static final AtomicLong COUNTER = new AtomicLong();
    private final ArrayList<DOMStoreThreePhaseCommitCohort> cohorts = new ArrayList();
    private final InMemoryDOMDataTreeShardChangePublisher changePublisher;
    private final InMemoryDOMDataTreeShardProducer producer;
    private final ShardDataModification modification;
    private final ListeningExecutorService executor;
    private final DataTree rootShardDataTree;
    private final String identifier;
    private DataTreeModification rootModification = null;
    private DOMDataTreeWriteCursor cursor;
    private boolean finished = false;

    InmemoryDOMDataTreeShardWriteTransaction(InMemoryDOMDataTreeShardProducer producer, ShardDataModification root, DataTree rootShardDataTree, InMemoryDOMDataTreeShardChangePublisher changePublisher, ListeningExecutorService executor) {
        this.producer = producer;
        this.modification = Objects.requireNonNull(root);
        this.rootShardDataTree = Objects.requireNonNull(rootShardDataTree);
        this.changePublisher = Objects.requireNonNull(changePublisher);
        this.identifier = "INMEMORY-SHARD-TX-" + COUNTER.getAndIncrement();
        LOG.debug("Shard transaction{} created", (Object)this.identifier);
        this.executor = executor;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    private DOMDataTreeWriteCursor getCursor() {
        if (this.cursor == null) {
            this.cursor = new InMemoryShardDataModificationCursor(this.modification, this);
        }
        return this.cursor;
    }

    void delete(YangInstanceIdentifier path) {
        YangInstanceIdentifier relativePath = this.toRelative(path);
        Preconditions.checkArgument((!relativePath.isEmpty() ? 1 : 0) != 0, (Object)"Deletion of shard root is not allowed");
        SimpleCursorOperation.DELETE.apply(this.getCursor(), relativePath, null);
    }

    void merge(YangInstanceIdentifier path, NormalizedNode<?, ?> data) {
        SimpleCursorOperation.MERGE.apply(this.getCursor(), this.toRelative(path), data);
    }

    void write(YangInstanceIdentifier path, NormalizedNode<?, ?> data) {
        SimpleCursorOperation.WRITE.apply(this.getCursor(), this.toRelative(path), data);
    }

    private YangInstanceIdentifier toRelative(YangInstanceIdentifier path) {
        Optional relative = path.relativeTo(this.modification.getPrefix().getRootIdentifier());
        Preconditions.checkArgument((boolean)relative.isPresent());
        return (YangInstanceIdentifier)relative.get();
    }

    public void close() {
        Preconditions.checkState((!this.finished ? 1 : 0) != 0, (Object)"Attempting to close an already finished transaction.");
        this.modification.closeTransactions();
        if (this.cursor != null) {
            this.cursor.close();
        }
        this.producer.transactionAborted(this);
        this.finished = true;
    }

    void cursorClosed() {
        Objects.requireNonNull(this.cursor);
        this.modification.closeCursor();
        this.cursor = null;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public void ready() {
        Preconditions.checkState((!this.finished ? 1 : 0) != 0, (Object)"Attempting to ready an already finished transaction.");
        Preconditions.checkState((this.cursor == null ? 1 : 0) != 0, (Object)"Attempting to ready a transaction that has an open cursor.");
        Objects.requireNonNull(this.modification, "Attempting to ready an empty transaction.");
        LOG.debug("Readying open transaction on shard {}", (Object)this.modification.getPrefix());
        this.rootModification = this.modification.seal();
        this.producer.transactionReady(this, this.rootModification);
        this.cohorts.add(new InMemoryDOMDataTreeShardThreePhaseCommitCohort(this.rootShardDataTree, this.rootModification, this.changePublisher));
        for (Map.Entry<DOMDataTreeIdentifier, ForeignShardModificationContext> entry : this.modification.getChildShards().entrySet()) {
            this.cohorts.add((DOMStoreThreePhaseCommitCohort)new ForeignShardThreePhaseCommitCohort(entry.getKey(), entry.getValue()));
        }
        this.finished = true;
    }

    public ListenableFuture<Void> submit() {
        LOG.debug("Submitting open transaction on shard {}", (Object)this.modification.getPrefix());
        Objects.requireNonNull(this.cohorts);
        Preconditions.checkState((!this.cohorts.isEmpty() ? 1 : 0) != 0, (Object)"Transaction was not readied yet.");
        return this.executor.submit((Callable)new ShardSubmitCoordinationTask(this.modification.getPrefix(), this.cohorts, this));
    }

    public ListenableFuture<Boolean> validate() {
        LOG.debug("CanCommit on open transaction on shard {}", (Object)this.modification.getPrefix());
        return this.executor.submit((Callable)new ShardCanCommitCoordinationTask(this.modification.getPrefix(), this.cohorts));
    }

    public ListenableFuture<Void> prepare() {
        LOG.debug("PreCommit on open transaction on shard {}", (Object)this.modification.getPrefix());
        return this.executor.submit((Callable)new ShardPreCommitCoordinationTask(this.modification.getPrefix(), this.cohorts));
    }

    public ListenableFuture<Void> commit() {
        LOG.debug("Commit open transaction on shard {}", (Object)this.modification.getPrefix());
        return this.executor.submit((Callable)new ShardCommitCoordinationTask(this.modification.getPrefix(), this.cohorts, this));
    }

    DataTreeModification getRootModification() {
        Objects.requireNonNull(this.rootModification, "Transaction wasn't sealed yet");
        return this.rootModification;
    }

    void transactionCommited(InmemoryDOMDataTreeShardWriteTransaction tx) {
        this.producer.onTransactionCommited(tx);
    }

    public DOMDataTreeWriteCursor createCursor(DOMDataTreeIdentifier prefix) {
        Preconditions.checkState((!this.finished ? 1 : 0) != 0, (Object)"Transaction is finished/closed already.");
        Preconditions.checkState((this.cursor == null ? 1 : 0) != 0, (Object)"Previous cursor wasn't closed");
        YangInstanceIdentifier relativePath = this.toRelative(prefix.getRootIdentifier());
        DOMDataTreeWriteCursor ret = this.getCursor();
        ret.enter((Iterable)relativePath.getPathArguments());
        return ret;
    }

    private static enum SimpleCursorOperation {
        MERGE{

            @Override
            void applyOnLeaf(DOMDataTreeWriteCursor cur, YangInstanceIdentifier.PathArgument child, NormalizedNode<?, ?> data) {
                cur.merge(child, data);
            }
        }
        ,
        DELETE{

            @Override
            void applyOnLeaf(DOMDataTreeWriteCursor cur, YangInstanceIdentifier.PathArgument child, NormalizedNode<?, ?> data) {
                cur.delete(child);
            }
        }
        ,
        WRITE{

            @Override
            void applyOnLeaf(DOMDataTreeWriteCursor cur, YangInstanceIdentifier.PathArgument child, NormalizedNode<?, ?> data) {
                cur.write(child, data);
            }
        };


        abstract void applyOnLeaf(DOMDataTreeWriteCursor var1, YangInstanceIdentifier.PathArgument var2, NormalizedNode<?, ?> var3);

        void apply(DOMDataTreeWriteCursor cur, YangInstanceIdentifier path, NormalizedNode<?, ?> data) {
            int enterCount = 0;
            Iterator it = path.getPathArguments().iterator();
            if (it.hasNext()) {
                while (true) {
                    YangInstanceIdentifier.PathArgument currentArg = (YangInstanceIdentifier.PathArgument)it.next();
                    if (!it.hasNext()) {
                        this.applyOnLeaf(cur, currentArg, data);
                        break;
                    }
                    cur.enter(currentArg);
                    ++enterCount;
                }
            }
            cur.exit(enterCount);
        }
    }
}

