/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.dom.store.inmemory;

import com.google.common.annotations.Beta;
import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.Callable;
import org.opendaylight.mdsal.common.api.TransactionCommitFailedException;
import org.opendaylight.mdsal.dom.api.DOMDataTreeIdentifier;
import org.opendaylight.mdsal.dom.spi.store.DOMStoreThreePhaseCommitCohort;
import org.opendaylight.mdsal.dom.store.inmemory.InmemoryDOMDataTreeShardWriteTransaction;
import org.opendaylight.mdsal.dom.store.inmemory.ShardCanCommitCoordinationTask;
import org.opendaylight.mdsal.dom.store.inmemory.ShardCommitCoordinationTask;
import org.opendaylight.mdsal.dom.store.inmemory.ShardPreCommitCoordinationTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public class ShardSubmitCoordinationTask
implements Callable<Void> {
    private static final Logger LOG = LoggerFactory.getLogger(ShardSubmitCoordinationTask.class);
    private final DOMDataTreeIdentifier rootShardPrefix;
    private final ShardCanCommitCoordinationTask canCommitCoordinationTask;
    private final ShardPreCommitCoordinationTask preCommitCoordinationTask;
    private final ShardCommitCoordinationTask commitCoordinationTask;
    private final InmemoryDOMDataTreeShardWriteTransaction transaction;

    public ShardSubmitCoordinationTask(DOMDataTreeIdentifier rootShardPrefix, Collection<DOMStoreThreePhaseCommitCohort> cohorts, InmemoryDOMDataTreeShardWriteTransaction transaction) {
        this.rootShardPrefix = Objects.requireNonNull(rootShardPrefix);
        this.transaction = transaction;
        this.canCommitCoordinationTask = new ShardCanCommitCoordinationTask(rootShardPrefix, cohorts);
        this.preCommitCoordinationTask = new ShardPreCommitCoordinationTask(rootShardPrefix, cohorts);
        this.commitCoordinationTask = new ShardCommitCoordinationTask(rootShardPrefix, cohorts, transaction);
    }

    @Override
    public Void call() throws TransactionCommitFailedException {
        LOG.debug("Shard {}, tx{} CanCommit started", (Object)this.transaction.getIdentifier(), (Object)this.rootShardPrefix);
        this.canCommitCoordinationTask.canCommitBlocking();
        LOG.debug("Shard {}, tx{} PreCommit started", (Object)this.transaction.getIdentifier(), (Object)this.rootShardPrefix);
        this.preCommitCoordinationTask.preCommitBlocking();
        LOG.debug("Shard {}, tx{} commit started", (Object)this.transaction.getIdentifier(), (Object)this.rootShardPrefix);
        this.commitCoordinationTask.commitBlocking();
        this.transaction.transactionCommited(this.transaction);
        return null;
    }
}

