/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.util;

import com.google.common.annotations.Beta;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.DataNodeContainer;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.GroupingDefinition;
import org.opendaylight.yangtools.yang.model.api.TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.UsesNode;

@Beta
public final class SingleChildDataNodeContainer
implements DataNodeContainer {
    private final DataSchemaNode child;

    public SingleChildDataNodeContainer(DataSchemaNode child) {
        this.child = Objects.requireNonNull(child);
    }

    public Optional<DataSchemaNode> findDataChildByName(QName name) {
        return this.child.getQName().equals((Object)name) ? Optional.of(this.child) : Optional.empty();
    }

    public Collection<DataSchemaNode> getChildNodes() {
        return ImmutableSet.of((Object)this.child);
    }

    public Set<TypeDefinition<?>> getTypeDefinitions() {
        return ImmutableSet.of();
    }

    public Set<GroupingDefinition> getGroupings() {
        return ImmutableSet.of();
    }

    public Set<UsesNode> getUses() {
        return ImmutableSet.of();
    }
}

